/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Array;
import mirah.lang.ast.ClassAppendSelf;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ConstantAssign;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAnnotationRequest;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.FieldDeclaration;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Import;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Noop;
import mirah.lang.ast.OptionalArgument;
import mirah.lang.ast.Position;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StaticMethodDefinition;
import mirah.lang.ast.Super;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.TypeRefImpl;
import org.mirah.jvm.compiler.AnnotationCollector;
import org.mirah.jvm.compiler.ConstructorCleanup;
import org.mirah.jvm.compiler.MethodCleanup;
import org.mirah.jvm.compiler.MethodState;
import org.mirah.jvm.types.JVMField;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.macros.Compiler;
import org.mirah.typer.MethodType;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.Logger;
import org.mirah.util.MirahDiagnostic;

public class ClassCleanup
extends NodeScanner {
    private Typer typer;
    private static Logger log = Logger.getLogger(ClassCleanup.class.getName());
    private ArrayList methods;
    private ArrayList init_nodes;
    private ArrayList constructors;
    private AnnotationCollector field_annotations;
    private Compiler parser;
    private Map field_annotation_requestss;
    private ClassDefinition klass;
    private Map method_states;
    private MethodDefinition cinit;
    private Context context;
    private boolean alreadyCleaned;
    private ArrayList static_init_nodes;

    public ClassCleanup(Context context, ClassDefinition klass) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.parser = (Compiler)context.get(Compiler.class);
        this.klass = klass;
        this.static_init_nodes = new ArrayList();
        this.init_nodes = new ArrayList();
        this.constructors = new ArrayList();
        this.field_annotations = new AnnotationCollector(context);
        this.field_annotation_requestss = new HashMap(16);
        this.methods = new ArrayList();
        this.method_states = new HashMap(16);
    }

    public void clean() {
        if (!this.addCleanedAnnotation()) {
            return;
        }
        this.scan(this.klass.body(), null);
        if (!this.static_init_nodes.isEmpty()) {
            if (this.cinit == null) {
                this.cinit = (StaticMethodDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/class_cleanup.mirah", 63, 34, "def self.initialize:void; end", new ArrayList(0));
                this.klass.body().add(this.cinit);
                this.typer.infer(this.cinit, false);
            }
            NodeList nodes = new NodeList();
            for (Node node : this.static_init_nodes) {
                node.parent().removeChild(node);
                node.setParent(null);
                nodes.add(node);
            }
            NodeList old_body = this.cinit.body();
            this.cinit.body_set(nodes);
            this.cinit.body().add(old_body);
            this.typer.infer(nodes, false);
        }
        if (this.constructors.isEmpty() && !(this.klass instanceof InterfaceDeclaration)) {
            this.add_default_constructor();
        }
        NodeList init = this.init_nodes == null ? null : new NodeList(this.init_nodes);
        ConstructorCleanup cleanup = new ConstructorCleanup(this.context);
        for (ConstructorDefinition n : this.constructors) {
            cleanup.clean(n, init);
        }
        this.declareFields();
        for (MethodDefinition m : this.methods) {
            this.addOptionalMethods(m);
        }
    }

    public boolean addCleanedAnnotation() {
        int i = 0;
        int gensym0 = this.klass.annotations_size();
        if (i < gensym0) {
            do {
                Annotation anno;
                if (!"org.mirah.jvm.compiler.Cleaned".equals((anno = this.klass.annotations(i)).type().typeref().name())) continue;
                return false;
            } while (++i < gensym0);
        }
        this.klass.annotations().add(new Annotation(new SimpleString("org.mirah.jvm.compiler.Cleaned"), Collections.emptyList()));
        return true;
    }

    public boolean add_default_constructor() {
        ConstructorDefinition constructor = (ConstructorDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/class_cleanup.mirah", 112, 35, "def initialize; end", new ArrayList(0));
        constructor.body().add(new Super(constructor.position(), Collections.emptyList(), null));
        this.klass.body().add(constructor);
        this.typer.infer(constructor);
        return this.constructors.add(constructor);
    }

    public TypeRef makeTypeRef(JVMType type) {
        return new TypeRefImpl(type.name(), JVMTypeUtils.isArray(type), false, null);
    }

    public void declareFields() {
        Object var14_1 = null;
        if (this.alreadyCleaned) {
            return;
        }
        int gensym1 = 0;
        JVMType type = (JVMType)this.typer.getResolvedType(this.klass);
        JVMField[] gensym0 = type.getDeclaredFields();
        if (gensym1 < gensym0.length) {
            do {
                FieldAnnotationRequest field_annotation_request2;
                String name;
                AnnotationList $or$1;
                JVMField f = gensym0[gensym1];
                java.util.logging.Logger gensym2_javalogger = log.internal_logger();
                if (gensym2_javalogger.isLoggable(Level.FINEST)) {
                    gensym2_javalogger.finest("creating field declaration for " + f.name());
                }
                AnnotationList annotations = ($or$1 = this.field_annotations.getAnnotations(name = f.name())) != null ? $or$1 : new AnnotationList();
                boolean isStatic = type.hasStaticField(f.name());
                Array flags = new Array(Collections.emptyList());
                if (isStatic) {
                    flags.values().add(new SimpleString("STATIC"));
                }
                SimpleString simpleString = new SimpleString("org.mirah.jvm.types.Modifiers");
                ArrayList<HashEntry> arrayList = new ArrayList<HashEntry>(2);
                arrayList.add(new HashEntry(new SimpleString("access"), new SimpleString("PRIVATE")));
                arrayList.add(new HashEntry(new SimpleString("flags"), flags));
                Annotation modifiers = new Annotation(simpleString, arrayList);
                annotations.add(modifiers);
                List field_annotation_requests = (List)this.field_annotation_requestss.get(name);
                if (field_annotation_requests != null) {
                    for (FieldAnnotationRequest field_annotation_request2 : field_annotation_requests) {
                        if (field_annotation_request2.annotations() == null) continue;
                        for (Object a : field_annotation_request2.annotations()) {
                            Annotation annotation = (Annotation)a;
                            annotation.parent().removeChild(annotation);
                            annotations.add(annotation);
                        }
                    }
                }
                FieldDeclaration decl = new FieldDeclaration(new SimpleString(name), this.makeTypeRef(f.returnType()), field_annotation_request2 != null ? field_annotation_request2.value() : null, Collections.emptyList());
                decl.isStatic_set(isStatic);
                decl.annotations_set(annotations);
                this.klass.body().add(decl);
                this.typer.infer(modifiers);
                this.typer.infer(decl);
            } while (++gensym1 < gensym0.length);
        }
    }

    public DiagnosticListener error(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.error(position, message));
        return diagnosticListener;
    }

    public DiagnosticListener note(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.note(position, message));
        return diagnosticListener;
    }

    public void addMethodState(MethodState state) {
        ArrayList<MethodState> methods = (ArrayList<MethodState>)this.method_states.get(state.name());
        if (methods == null) {
            ArrayList<MethodState> val0 = new ArrayList<MethodState>(0);
            this.method_states.put(state.name(), val0);
            methods = val0;
        }
        for (MethodState m : methods) {
            Diagnostic.Kind conflict = m.conflictsWith(state);
            if (conflict == null) continue;
            String desc = conflict == Diagnostic.Kind.ERROR ? "Conflicting definition of " + state : "Possibly conflicting definition of " + state;
            ((DiagnosticListener)this.context.get(DiagnosticListener.class)).report(new MirahDiagnostic(conflict, state.position(), desc));
            this.note("Previous definition of " + m, m.position());
            return;
        }
        methods.add(state);
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.error("Statement (" + node.getClass() + ") not enclosed in a method", node.position());
        return false;
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        new MethodCleanup(this.context, node).clean();
        this.methods.add(node);
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getResolvedType(node)));
        return false;
    }

    @Override
    public boolean enterStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        if ("initialize".equals(node.name().identifier())) {
            this.field_annotations.collect(node.body());
            this.setCinit(node);
        }
        this.methods.add(node);
        new MethodCleanup(this.context, node).clean();
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getResolvedType(node)));
        return false;
    }

    public boolean isStatic(Node node) {
        return this.typer.scoper().getScope(node).selfType().resolve().isMeta();
    }

    public void setCinit(MethodDefinition node) {
        if (this.cinit != null) {
            this.error("Duplicate static initializer", node.position());
            if (this.cinit.position() != null) {
                this.note("Previously declared here", this.cinit.position());
            }
            return;
        }
        this.cinit = node;
    }

    @Override
    public boolean enterConstructorDefinition(ConstructorDefinition node, Object arg) {
        this.constructors.add(node);
        this.field_annotations.collect(node.body());
        new MethodCleanup(this.context, node).clean();
        this.methods.add(node);
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getResolvedType(node)));
        return false;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        new ClassCleanup(this.context, node).clean();
        return false;
    }

    @Override
    public boolean enterInterfaceDeclaration(InterfaceDeclaration node, Object arg) {
        this.enterClassDefinition(node, arg);
        return false;
    }

    @Override
    public boolean enterImport(Import node, Object arg) {
        return false;
    }

    @Override
    public boolean enterNoop(Noop node, Object arg) {
        return false;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }

    @Override
    public boolean enterClassAppendSelf(ClassAppendSelf node, Object arg) {
        return true;
    }

    @Override
    public boolean enterConstantAssign(ConstantAssign node, Object arg) {
        this.static_init_nodes.add(node);
        return false;
    }

    @Override
    public boolean enterFieldAssign(FieldAssign node, Object arg) {
        this.field_annotations.collect(node);
        boolean $or$2 = node.isStatic();
        if ($or$2 ? $or$2 : this.isStatic(node)) {
            this.static_init_nodes.add(node);
        } else {
            this.init_nodes.add(node);
            node.parent().removeChild(node);
        }
        return false;
    }

    @Override
    public boolean enterFieldAnnotationRequest(FieldAnnotationRequest node, Object arg) {
        Map $ptemp$3 = this.field_annotation_requestss;
        String $ptemp$4 = node.name().identifier();
        Object $or$5 = $ptemp$3.get($ptemp$4);
        if ($or$5 == null) {
            $ptemp$3.put($ptemp$4, new ArrayList(0));
        }
        ((List)this.field_annotation_requestss.get(node.name().identifier())).add(node);
        return false;
    }

    @Override
    public boolean enterFieldDeclaration(FieldDeclaration node, Object arg) {
        this.alreadyCleaned = true;
        return false;
    }

    @Override
    public boolean enterMacroDefinition(MacroDefinition node, Object arg) {
        this.addMethodState(new MethodState(node));
        return false;
    }

    public void addOptionalMethods(MethodDefinition mdef) {
        block4: {
            int gensym1;
            int i;
            if (mdef.arguments().optional_size() <= 0) break block4;
            NodeList parent = (NodeList)mdef.parent();
            List params = this.buildDefaultParameters(mdef.arguments());
            Arguments new_args = (Arguments)mdef.arguments().clone();
            int num_optional_args = new_args.optional_size();
            int optional_arg_offset = new_args.required_size();
            java.util.logging.Logger gensym0 = log.internal_logger();
            if (gensym0.isLoggable(Level.FINE)) {
                gensym0.fine("Generating " + num_optional_args + " optarg methods for " + mdef.name().identifier());
            }
            if ((i = num_optional_args - 1) >= (gensym1 = 0)) {
                do {
                    java.util.logging.Logger gensym2;
                    if ((gensym2 = log.internal_logger()).isLoggable(Level.FINER)) {
                        gensym2.finer("Generating optarg method " + i);
                    }
                    OptionalArgument arg = new_args.optional().remove(i);
                    params.set(optional_arg_offset + i, arg.value());
                    Node method = this.buildOptargBridge(mdef, new_args, params);
                    parent.add(method);
                    this.typer.infer(method);
                } while (--i >= gensym1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List buildDefaultParameters(Arguments arguments) {
        int gensym2;
        int gensym1;
        RequiredArgument arg;
        void args;
        Object var5_2 = null;
        ArrayList<LocalAccess> params = new ArrayList<LocalAccess>();
        int i = 0;
        int gensym0 = args.required_size();
        if (i < gensym0) {
            do {
                arg = args.required(i);
                params.add(new LocalAccess(arg.position(), arg.name()));
            } while (++i < gensym0);
        }
        if ((i = 0) < (gensym1 = args.optional_size())) {
            do {
                OptionalArgument optarg = args.optional(i);
                params.add(new LocalAccess(optarg.position(), optarg.name()));
            } while (++i < gensym1);
        }
        if (args.rest() != null) {
            params.add(new LocalAccess(args.rest().position(), arg.name()));
        }
        if ((i = 0) < (gensym2 = args.required2_size())) {
            do {
                arg = args.required2(i);
                params.add(new LocalAccess(arg.position(), arg.name()));
            } while (++i < gensym2);
        }
        return params;
    }

    public Node buildOptargBridge(MethodDefinition orig, Arguments args, List params) {
        MethodDefinition mdef = (MethodDefinition)orig.clone();
        mdef.arguments_set((Arguments)args.clone());
        ArrayList<FunctionalCall> arrayList = new ArrayList<FunctionalCall>(1);
        arrayList.add(new FunctionalCall(mdef.position(), mdef.name(), params, null));
        mdef.body_set(new NodeList(arrayList));
        Position position = mdef.position();
        SimpleString simpleString = new SimpleString("org.mirah.jvm.types.Modifiers");
        ArrayList<HashEntry> arrayList2 = new ArrayList<HashEntry>(2);
        arrayList2.add(new HashEntry(new SimpleString("access"), new SimpleString("PUBLIC")));
        SimpleString simpleString2 = new SimpleString("flags");
        ArrayList<SimpleString> arrayList3 = new ArrayList<SimpleString>(2);
        arrayList3.add(new SimpleString("SYNTHETIC"));
        arrayList3.add(new SimpleString("BRIDGE"));
        arrayList2.add(new HashEntry(simpleString2, new Array(arrayList3)));
        Annotation modifiers = new Annotation(position, simpleString, arrayList2);
        MethodDefinition methodDefinition = mdef;
        ArrayList<Annotation> arrayList4 = new ArrayList<Annotation>(1);
        arrayList4.add(modifiers);
        methodDefinition.annotations_set(new AnnotationList(arrayList4));
        return methodDefinition;
    }
}

