/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.ClassAppendSelf;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldDeclaration;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.StaticMethodDefinition;
import mirah.lang.ast.TypeName;
import org.mirah.jvm.compiler.AnnotationCompiler;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.InnerClassCompiler;
import org.mirah.jvm.compiler.InterfaceCompiler;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.compiler.MethodCompiler;
import org.mirah.jvm.compiler.MirahClassWriter;
import org.mirah.jvm.types.JVMType;
import org.mirah.util.Context;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.Method;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClassCompiler
extends BaseCompiler
implements InnerClassCompiler {
    private boolean static;
    private static org.mirah.util.Logger log = org.mirah.util.Logger.getLogger(ClassCompiler.class.getName());
    private ClassDefinition classdef;
    private JVMType outerClass;
    private Map fields;
    private JVMType type;
    private Method enclosingMethod;
    private MirahClassWriter classwriter;
    private LinkedList innerClasses;

    public ClassCompiler(Context context, ClassDefinition classdef) {
        super(context);
        this.classdef = classdef;
        this.fields = new HashMap(16);
        this.innerClasses = new LinkedList();
        this.type = this.getInferredType(this.classdef);
    }

    public ClassCompiler(Context context, ClassDefinition classdef, JVMType outerClass, Method method) {
        this(context, classdef);
        this.outerClass = outerClass;
        this.enclosingMethod = method;
    }

    public void compile() {
        block1: {
            Logger gensym0 = log.internal_logger();
            if (gensym0.isLoggable(Level.FINE)) {
                gensym0.fine("Compiling class " + this.classdef.name().identifier());
            }
            this.startClass();
            this.visit(this.classdef.body(), null);
            this.classwriter.visitEnd();
            Logger gensym1 = log.internal_logger();
            if (!gensym1.isLoggable(Level.FINE)) break block1;
            gensym1.fine("Finished class " + this.classdef.name().identifier());
        }
    }

    public String getInternalName(JVMType type) {
        return type.getAsmType().getInternalName();
    }

    @Override
    public Object visitClassAppendSelf(ClassAppendSelf node, Object expression) {
        boolean saved = this.static;
        this.static = true;
        this.visit(node.body(), expression);
        this.static = saved;
        return null;
    }

    @Override
    public Object visitMethodDefinition(MethodDefinition node, Object expression) {
        MethodCompiler method;
        boolean $or$1 = this.static;
        boolean isStatic = $or$1 ? $or$1 : node instanceof StaticMethodDefinition;
        boolean constructor = isStatic ? "initialize".equals(node.name().identifier()) : false;
        String name = constructor ? "<clinit>" : node.name().identifier().replaceFirst("=$", "_set");
        MethodCompiler methodCompiler = method = new MethodCompiler(this, this.type, this.methodFlags(node, isStatic), name);
        methodCompiler.compile(this.classwriter, node);
        return methodCompiler;
    }

    @Override
    public Object visitStaticMethodDefinition(StaticMethodDefinition node, Object expression) {
        return this.visitMethodDefinition(node, expression);
    }

    @Override
    public Object visitConstructorDefinition(ConstructorDefinition node, Object expression) {
        MethodCompiler method;
        MethodCompiler methodCompiler = method = new MethodCompiler(this, this.type, Opcodes.ACC_PUBLIC, "<init>");
        methodCompiler.compile(this.classwriter, node);
        return methodCompiler;
    }

    @Override
    public Object visitClassDefinition(ClassDefinition node, Object expression) {
        ClassCompiler classCompiler = this;
        classCompiler.compileInnerClass(node, null);
        return classCompiler;
    }

    @Override
    public Object visitInterfaceDeclaration(InterfaceDeclaration node, Object expression) {
        ClassCompiler classCompiler = this;
        classCompiler.compileInnerInterface(node, null);
        return classCompiler;
    }

    @Override
    public void compileInnerClass(ClassDefinition node, Method method) {
        ClassCompiler compiler = new ClassCompiler(this.context(), node, this.type, method);
        this.innerClasses.add(compiler);
        this.classwriter.visitInnerClass(compiler.internal_name(), null, null, 0);
        compiler.compile();
    }

    public void compileInnerInterface(InterfaceDeclaration node, Method method) {
        InterfaceCompiler compiler = new InterfaceCompiler(this.context(), node, this.type, method);
        this.innerClasses.add(compiler);
        this.classwriter.visitInnerClass(compiler.internal_name(), null, null, 0);
        compiler.compile();
    }

    public byte[] getBytes() {
        return this.classwriter.toByteArray();
    }

    public void startClass() {
        Object var3_1 = null;
        Object var4_2 = null;
        JvmVersion jvm = (JvmVersion)this.context().get(JvmVersion.class);
        this.classwriter = new MirahClassWriter(this.context(), jvm.flags());
        this.classwriter.visit(jvm.version(), this.flags(), this.internal_name(), null, this.superclass(), this.interfaces());
        String filename = this.filename();
        if (filename != null) {
            this.classwriter.visitSource(filename, null);
        }
        if (this.outerClass != null) {
            String desc;
            String method;
            if (this.enclosingMethod != null) {
                method = this.enclosingMethod.getName();
            }
            if (this.enclosingMethod != null) {
                desc = this.enclosingMethod.getDescriptor();
            }
            this.classwriter.visitOuterClass(this.getInternalName(this.outerClass), method, desc);
        }
        ((AnnotationCompiler)this.context().get(AnnotationCompiler.class)).compile(this.classdef.annotations(), this.classwriter);
    }

    @Override
    public Object visitFieldDeclaration(FieldDeclaration node, Object expression) {
        int flags = this.calculateFlagsFromAnnotations(Opcodes.ACC_PRIVATE, node.annotations());
        Long initial_value = null;
        if ((flags & (Opcodes.ACC_FINAL | Opcodes.ACC_STATIC)) == (Opcodes.ACC_FINAL | Opcodes.ACC_STATIC)) {
            if (node.type().typeref().name().equals("long")) {
                initial_value = new Long(((Fixnum)node.value()).value());
            } else {
                throw new Exception("Cannot support field declaration " + node + ": node.type.typeref.name=" + node.type().typeref().name() + ".");
            }
        }
        FieldVisitor fv = this.classwriter.visitField(flags, node.name().identifier(), this.getInferredType(node).getAsmType().getDescriptor(), null, initial_value);
        ((AnnotationCompiler)this.context().get(AnnotationCompiler.class)).compile(node.annotations(), fv);
        FieldVisitor fieldVisitor = fv;
        fieldVisitor.visitEnd();
        return fieldVisitor;
    }

    public int flags() {
        return this.calculateFlagsFromAnnotations(Opcodes.ACC_PUBLIC, this.classdef.annotations()) | Opcodes.ACC_SUPER;
    }

    public int methodFlags(MethodDefinition mdef, boolean isStatic) {
        int flags = this.calculateFlagsFromAnnotations(Opcodes.ACC_PUBLIC, mdef.annotations());
        return isStatic ? flags | Opcodes.ACC_STATIC : flags;
    }

    public String internal_name() {
        return this.getInternalName(this.type);
    }

    public String filename() {
        if (this.classdef.position() != null) {
            String path = this.classdef.position().source().name();
            int lastslash = path.lastIndexOf(File.separatorChar);
            if (lastslash == -1) {
                return path;
            }
            return path.substring(lastslash + 1);
        }
        return null;
    }

    public String superclass() {
        return this.type.superclass() != null ? this.getInternalName(this.type.superclass()) : null;
    }

    public String[] interfaces() {
        int size = this.classdef.interfaces().size();
        String[] array = new String[size];
        int i = 0;
        i = 0;
        int gensym0 = size;
        if (i < gensym0) {
            do {
                TypeName node = this.classdef.interfaces().get(i);
                array[i] = this.getInternalName(this.getInferredType(node));
            } while (++i < gensym0);
        }
        return array;
    }

    public Collection innerClasses() {
        return Collections.unmodifiableCollection(this.innerClasses);
    }
}

