/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Collections;
import java.util.logging.Level;
import mirah.lang.ast.Call;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.Ensure;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.Self;
import mirah.lang.ast.SimpleNodeVisitor;
import mirah.lang.ast.Super;
import mirah.lang.ast.ZSuper;
import org.mirah.typer.Typer;
import org.mirah.util.AstFormatter;
import org.mirah.util.Context;
import org.mirah.util.Logger;

public class ConstructorCleanup
extends SimpleNodeVisitor {
    private Typer typer;
    private static Logger log = Logger.getLogger(ConstructorCleanup.class.getName());
    private Context context;

    public ConstructorCleanup(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
    }

    public void clean(ConstructorDefinition constructor, NodeList extra_init) {
        block3: {
            java.util.logging.Logger gensym0 = log.internal_logger();
            Level gensym1 = Level.FINER;
            if (gensym0.isLoggable(Level.FINER)) {
                gensym0.log(Level.FINER, "Before cleanup {0}", new AstFormatter(constructor));
            }
            Object found_delegate = constructor.body().accept(this, extra_init);
            java.util.logging.Logger gensym2_javalogger = log.internal_logger();
            if (gensym2_javalogger.isLoggable(Level.FINEST)) {
                gensym2_javalogger.finest("found_delegate: " + found_delegate);
            }
            if (!Boolean.TRUE.equals(found_delegate)) {
                Super delegate = new Super(constructor.name().position(), Collections.emptyList(), null);
                constructor.body().insert(0, delegate);
                this.typer.infer(delegate, false);
                this.insertNodesAfter(constructor.body().get(0), extra_init);
            }
            java.util.logging.Logger gensym3 = log.internal_logger();
            Level gensym4 = Level.FINE;
            if (!gensym3.isLoggable(Level.FINE)) break block3;
            gensym3.log(Level.FINE, "After cleanup {0}", new AstFormatter(constructor));
        }
    }

    @Override
    public Object defaultNode(Node node, Object arg) {
        return null;
    }

    @Override
    public Object visitNodeList(NodeList node, Object arg) {
        int i = 0;
        int gensym0 = node.size();
        if (i < gensym0) {
            do {
                Node child;
                Object res;
                if ((res = (child = node.get(i)).accept(this, arg)) == null) continue;
                return res;
            } while (++i < gensym0);
        }
        return null;
    }

    @Override
    public Object visitClassDefinition(ClassDefinition node, Object arg) {
        return null;
    }

    @Override
    public Object visitClosureDefinition(ClosureDefinition node, Object arg) {
        return null;
    }

    @Override
    public Object visitEnsure(Ensure node, Object arg) {
        return node.body() != null ? node.body().accept(this, arg) : null;
    }

    @Override
    public Object visitRescue(Rescue node, Object arg) {
        return node.body() != null ? node.body().accept(this, arg) : null;
    }

    @Override
    public Object visitZSuper(ZSuper node, Object arg) {
        this.insertNodesAfter(node, arg);
        return Boolean.TRUE;
    }

    @Override
    public Object visitSuper(Super node, Object arg) {
        this.insertNodesAfter(node, arg);
        return Boolean.TRUE;
    }

    @Override
    public Object visitFunctionalCall(FunctionalCall node, Object arg) {
        return "initialize".equals(node.name().identifier()) ? Boolean.TRUE : null;
    }

    @Override
    public Object visitCall(Call node, Object arg) {
        return (node.target() instanceof Self ? "initialize".equals(node.name().identifier()) : false) ? Boolean.TRUE : null;
    }

    public void insertNodesAfter(Node node, Object arg) {
        block0: {
            if (arg == null) break block0;
            NodeList parent = (NodeList)node.parent();
            parent.insert(1, (Node)arg);
            this.typer.infer(parent.get(1));
        }
    }
}

