/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Package;
import mirah.lang.ast.Position;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.Unquote;
import org.mirah.jvm.compiler.Backend;
import org.mirah.typer.Typer;
import org.mirah.util.Logger;

public class ExtensionCleanup
extends NodeScanner {
    private String macro_destination;
    private static Logger log = Logger.getLogger(ExtensionCleanup.class.getName());
    private Backend macro_backend;
    private Typer macro_typer;
    private Map extension_classes;

    public ExtensionCleanup(Backend macro_backend, Map extension_classes, String macro_destination, Typer macro_typer) {
        this.macro_backend = macro_backend;
        this.extension_classes = extension_classes;
        this.macro_destination = macro_destination;
        this.macro_typer = macro_typer;
    }

    @Override
    public boolean enterPackage(Package pac, Object map) {
        ((Map)map).put("package", pac.name().identifier());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean enterClassDefinition(ClassDefinition classDefinition, Object object) {
        block3: {
            void map;
            Annotation extensions_anno;
            void classdef;
            Object var6_3 = null;
            int i = 0;
            int gensym0 = classdef.annotations_size();
            if (i < gensym0) {
                do {
                    Annotation anno;
                    if (!(anno = classdef.annotations(i)).type().typeref().name().equals("org.mirah.macros.anno.Extensions")) continue;
                    extensions_anno = anno;
                    break;
                } while (++i < gensym0);
            }
            if (extensions_anno == null) {
                return false;
            }
            Position pos = classdef.position();
            classdef.annotations().removeChild(extensions_anno);
            Constant class_name = new Constant(pos, new SimpleString(pos, classdef.name().identifier() + "$Extensions"));
            List list = Collections.emptyList();
            List list2 = Collections.emptyList();
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(1);
            arrayList.add(extensions_anno);
            ClassDefinition new_klass = new ClassDefinition(pos, class_name, null, list, list2, arrayList);
            String pkg_str = (String)((Map)map).get("package");
            Unquote pkg_name = new Unquote(pos, new SimpleString(pkg_str));
            Package new_pkg = new Package(pos, pkg_name, null);
            ArrayList<NodeImpl> arrayList2 = new ArrayList<NodeImpl>(2);
            arrayList2.add(new_pkg);
            arrayList2.add(new_klass);
            Script script = new Script(pos, arrayList2);
            this.macro_typer.infer(script, false);
            this.macro_backend.clean(script, null);
            this.macro_backend.compile(script, null);
            String class_name_written = Backend.write_out_file(this.macro_backend, this.extension_classes, this.macro_destination);
            java.util.logging.Logger gensym1 = log.internal_logger();
            if (!gensym1.isLoggable(Level.FINE)) break block3;
            gensym1.fine("extensions file compiled " + class_name_written);
        }
        return true;
    }
}

