/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalInfo {
    private Label scopeEnd;
    private String name;
    private int index;
    private Type type;
    private Label scopeStart;

    public LocalInfo(String name, int index, Type type, Label scopeStart, Label scopeEnd) {
        this.name = name;
        this.index = index;
        this.type = type;
        this.scopeStart = scopeStart;
        this.scopeEnd = scopeEnd;
    }

    public void declare(MethodVisitor visitor) {
        visitor.visitLocalVariable(this.name, this.type.getDescriptor(), null, this.scopeStart, this.scopeEnd, this.index);
    }

    public String toString() {
        return "<Local " + this.index() + " (" + this.name() + ":" + this.type().getDescriptor() + ")>";
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.index;
    }

    public Type type() {
        return this.type;
    }

    public Label scopeStart() {
        return this.scopeStart;
    }

    public Label scopeEnd() {
        return this.scopeEnd;
    }
}

