/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import javax.tools.Diagnostic;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Position;
import mirah.lang.ast.StaticMethodDefinition;
import org.mirah.jvm.types.JVMType;
import org.mirah.typer.MethodType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MethodState {
    private boolean static;
    private int num_args;
    private String signature;
    private String name;
    private Position position;
    private JVMType returnType;

    public MethodState(MacroDefinition macrodef) {
        if (macrodef.arguments() != null) {
            this.num_args = macrodef.arguments().required_size();
            if (macrodef.arguments().block() != null) {
                ++this.num_args;
            }
        } else {
            this.num_args = 0;
        }
        this.name = macrodef.name().identifier();
        this.position = macrodef.name().position();
        this.signature = null;
        this.static = macrodef.isStatic();
    }

    public MethodState(MethodDefinition method, MethodType type) {
        this.name = method.name().identifier();
        this.position = method.name().position();
        this.num_args = type.parameterTypes().size();
        this.returnType = (JVMType)type.returnType();
        StringBuilder signature = new StringBuilder();
        for (JVMType t : type.parameterTypes()) {
            signature.append(t.getAsmType().getDescriptor());
        }
        this.signature = signature.toString();
        this.static = method instanceof StaticMethodDefinition;
    }

    public Diagnostic.Kind conflictsWith(MethodState other) {
        Object object;
        if (!this.name.equals(other.name())) {
            return null;
        }
        if (this.num_args != other.num_args()) {
            return null;
        }
        boolean bl = this.isMacro() ? !other.isMacro() : false;
        if (bl) {
            object = other.conflictsWith(this);
        } else if (!this.isMacro() ? other.isMacro() : false) {
            object = this.num_args != 0 ? Diagnostic.Kind.WARNING : Diagnostic.Kind.ERROR;
        } else if (this.isMacro() ? other.isMacro() : false) {
            object = this.num_args == 0 ? (this.static() ^ other.static() ? null : Diagnostic.Kind.ERROR) : Diagnostic.Kind.WARNING;
        } else if (this.signature.equals(other.signature())) {
            boolean $or$1;
            boolean bl2 = $or$1 = this.static() == other.static();
            object = ($or$1 ? $or$1 : !this.name().equals("initialize")) ? Diagnostic.Kind.WARNING : null;
        } else {
            object = null;
        }
        return object;
    }

    public int num_args() {
        return this.num_args;
    }

    public String name() {
        return this.name;
    }

    public Position position() {
        return this.position;
    }

    public JVMType returnType() {
        return this.returnType;
    }

    public boolean static() {
        return this.static;
    }

    public void num_args_set(int value) {
        this.num_args = value;
    }

    public void name_set(String value) {
        this.name = value;
    }

    public void position_set(Position value) {
        this.position = value;
    }

    public void returnType_set(JVMType value) {
        this.returnType = value;
    }

    public void static_set(boolean value) {
        this.static = value;
    }

    public String signature() {
        return this.signature;
    }

    public void signature_set(String value) {
        this.signature = value;
    }

    public String toString() {
        return (this.signature != null ? "method" : "macro") + " " + this.name;
    }

    public boolean isMacro() {
        return this.signature == null;
    }
}

