/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mirah.jvm.mirrors.AsyncMirror;
import org.mirah.jvm.mirrors.DeclaredMirrorType;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MetaType;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirrorLoader;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.ResolvedCall;
import org.mirah.jvm.mirrors.generics.TypeInvoker;
import org.mirah.jvm.types.JVMField;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.MethodType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BytecodeMirror
extends AsyncMirror
implements DeclaredMirrorType {
    private String superName;
    private String signature;
    private MirrorLoader loader;
    private List methods;
    private LinkedHashMap typeParams;
    private List interface_names;
    private List annotations;
    private JVMField[] field_mirrors;
    private boolean methods_loaded;
    private List innerClassNodes;
    private Context context;
    private List fields;
    private boolean linked;

    public BytecodeMirror(Context context, ClassNode klass, MirrorLoader loader) {
        super(context, Type.getObjectType(klass.name), klass.access);
        this.context = context;
        this.loader = loader;
        this.fields = klass.fields;
        this.methods = klass.methods;
        this.superName = klass.superName;
        this.signature = klass.signature;
        this.interface_names = klass.interfaces;
        this.annotations = klass.visibleAnnotations;
        this.innerClassNodes = klass.innerClasses;
        this.typeParams = new LinkedHashMap();
        this.linked = false;
    }

    public static MirrorType lookupType(MirrorLoader loader, String internalName) {
        if (internalName != null) {
            return loader.loadMirror(Type.getType("L" + internalName + ";"));
        }
        return null;
    }

    @Override
    public void ensure_linked() {
        block0: {
            if (this.linked) break block0;
            this.linked = true;
            this.link_internal();
        }
    }

    protected void link_internal() {
        MirrorTypeSystem types = (MirrorTypeSystem)this.context.get(MirrorTypeSystem.class);
        if (this.signature != null) {
            TypeInvoker invoker = new TypeInvoker(this.context, null, new ArrayList(0), new HashMap(16));
            invoker.read(this.signature);
            this.setSupertypes(invoker.superclass(), invoker.interfaces());
            for (Object var : invoker.getFormalTypeParameters()) {
                String string = var.toString();
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved((MirrorType)var);
                this.typeParams.put(string, baseTypeFuture);
            }
        } else {
            TypeFuture superclass = this.superName != null ? types.wrap(Type.getType("L" + this.superName + ";")) : null;
            TypeFuture[] interfaces = new TypeFuture[this.interface_names != null ? this.interface_names.size() : 0];
            if (this.interface_names != null) {
                Iterator it = this.interface_names.iterator();
                int i = 0;
                int gensym0 = interfaces.length;
                if (i < gensym0) {
                    do {
                        interfaces[i] = types.wrap(Type.getType("L" + it.next() + ";"));
                    } while (++i < gensym0);
                }
            }
            this.setSupertypes(superclass, interfaces);
        }
        types.addClassIntrinsic(this);
    }

    public MirrorType lookupType(String internalName) {
        return BytecodeMirror.lookupType(this.loader, internalName);
    }

    public MirrorType lookup(Type type) {
        return this.loader.loadMirror(type);
    }

    public void addMethod(MethodNode method) {
        MemberKind kind = "<clinit>".equals(method.name) ? MemberKind.STATIC_INITIALIZER : ("<init>".equals(method.name) ? MemberKind.CONSTRUCTOR : (0 != (method.access & Opcodes.ACC_STATIC) ? MemberKind.STATIC_METHOD : MemberKind.METHOD));
        Type method_type = Type.getType(method.desc);
        LinkedList<MirrorType> argument_mirrors = new LinkedList<MirrorType>();
        int gensym1 = 0;
        Type[] argument_types = method_type.getArgumentTypes();
        Type[] gensym0 = argument_types;
        if (gensym1 < gensym0.length) {
            do {
                Type t = gensym0[gensym1];
                argument_mirrors.add(this.lookup(t));
            } while (++gensym1 < gensym0.length);
        }
        Member member = new Member(method.access, this, method.name, argument_mirrors, this.lookup(method_type.getReturnType()), kind);
        member.signature_set(method.signature);
        this.add(member);
    }

    public void addInnerClass(InnerClassNode node) {
        int flags = node.access | Opcodes.ACC_STATIC;
        String name = node.innerName;
        List args = Collections.emptyList();
        MetaType result = new MetaType(this.lookupType(node.name));
        MemberKind kind = MemberKind.CLASS_LITERAL;
        this.add(new Member(flags, this, name, args, result, kind));
    }

    @Override
    public String retention() {
        if (this.annotations == null) {
            return "CLASS";
        }
        for (AnnotationNode anno : this.annotations) {
            if (!"Ljava/lang/annotation/Retention;".equals(anno.desc)) continue;
            String[] value = (String[])anno.values.get(1);
            return value[1];
        }
        return null;
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public boolean load_methods() {
        if (this.methods != null) {
            for (MethodNode m : this.methods) {
                this.addMethod(m);
            }
        }
        this.methods = null;
        for (InnerClassNode n : this.innerClassNodes) {
            this.addInnerClass(n);
        }
        return true;
    }

    @Override
    public JVMField[] getDeclaredFields() {
        JVMField[] jVMFieldArray;
        if (this.field_mirrors != null) {
            jVMFieldArray = this.field_mirrors;
        } else {
            JVMField[] mirrors = new JVMField[this.fields.size()];
            Iterator it = this.fields.iterator();
            int i = 0;
            int gensym0 = this.fields.size();
            if (i < gensym0) {
                do {
                    FieldNode field = (FieldNode)it.next();
                    MirrorType type = this.lookup(Type.getType(field.desc));
                    MemberKind kind = Opcodes.ACC_STATIC == (field.access & Opcodes.ACC_STATIC) ? MemberKind.STATIC_FIELD_ACCESS : MemberKind.FIELD_ACCESS;
                    Member member = new Member(field.access, this, field.name, new ArrayList(0), type, kind);
                    member.signature_set(field.signature);
                    mirrors[i] = member;
                } while (++i < gensym0);
            }
            this.fields = null;
            this.field_mirrors = mirrors;
            jVMFieldArray = this.field_mirrors;
        }
        return jVMFieldArray;
    }

    @Override
    public JVMField getDeclaredField(String name) {
        int gensym1 = 0;
        JVMField[] gensym0 = this.getDeclaredFields();
        if (gensym1 < gensym0.length) {
            do {
                JVMField field;
                if (!(field = gensym0[gensym1]).name().equals(name)) continue;
                return field;
            } while (++gensym1 < gensym0.length);
        }
        return null;
    }

    @Override
    public Map getTypeVariableMap() {
        return this.typeParams;
    }

    @Override
    public JVMMethod getMethod(String name, List params) {
        TypeFuture t;
        if (this.methods_loaded) {
        } else {
            this.methods_loaded = this.load_methods();
        }
        List members = this.getMembers(name);
        if (members != null) {
            for (Member member : members) {
                if (!member.argumentTypes().equals(params)) continue;
                return member;
            }
        }
        if ((t = ((MethodLookup)this.context.get(MethodLookup.class)).findMethod(null, this, name, params, null, null, false)) != null) {
            return ((ResolvedCall)((MethodType)t.resolve()).returnType()).member();
        }
        return null;
    }
}

