/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mirah.jvm.mirrors.ArrayType;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.BytecodeMirror;
import org.mirah.jvm.mirrors.MacroMember;
import org.mirah.jvm.mirrors.MirrorLoader;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.OrErrorLoader;
import org.mirah.jvm.mirrors.ResourceLoader;
import org.mirah.jvm.mirrors.SimpleMirrorLoader;
import org.mirah.util.Context;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class BytecodeMirrorLoader
extends SimpleMirrorLoader {
    private OrErrorLoader ancestorLoader;
    private MirrorLoader parent;
    private static org.mirah.util.Logger log = org.mirah.util.Logger.getLogger(BytecodeMirrorLoader.class.getName());
    private ResourceLoader loader;
    private Context context;

    public BytecodeMirrorLoader(Context context, ResourceLoader resourceLoader, MirrorLoader parent) {
        super(parent);
        this.context = context;
        this.loader = resourceLoader;
        this.ancestorLoader = new OrErrorLoader(this);
        this.parent = parent;
    }

    @Override
    public MirrorType findMirror(Type type) {
        MirrorType mirrorType;
        MirrorType $or$10 = super.findMirror(type);
        if ($or$10 != null) {
            mirrorType = $or$10;
        } else {
            Logger gensym2;
            Logger gensym0 = log.internal_logger();
            if (gensym0.isLoggable(Level.FINE)) {
                gensym0.fine("findMirror " + type);
            }
            if (type.getSort() == Type.ARRAY) {
                return this.findArrayMirror(Type.getType(type.getDescriptor().substring(1)));
            }
            String classfile = type.getInternalName() + ".class";
            while (true) {
                int lastSlash;
                InputStream bytecode = this.loader.getResourceAsStream(classfile);
                if (bytecode != null) {
                    ClassNode node = BytecodeMirrorLoader.class_node_for(bytecode);
                    if ((node.name + ".class").equals(classfile)) {
                        Logger gensym1 = log.internal_logger();
                        if (gensym1.isLoggable(Level.FINE)) {
                            gensym1.fine("Found " + classfile);
                        }
                        BytecodeMirror mirror = new BytecodeMirror(this.context, node, this.ancestorLoader);
                        ClassLoader macro_loader = (ClassLoader)this.context.get(ClassLoader.class);
                        BytecodeMirrorLoader.findOldAndNewStyleMacros(macro_loader, mirror, node, classfile);
                        return mirror;
                    }
                }
                if ((lastSlash = classfile.lastIndexOf(47)) == -1) break;
                classfile = classfile.substring(0, lastSlash) + "$" + classfile.substring(lastSlash + 1);
            }
            if ((gensym2 = log.internal_logger()).isLoggable(Level.FINE)) {
                gensym2.fine("Cannot find " + classfile);
            }
            mirrorType = null;
        }
        return mirrorType;
    }

    public MirrorType findArrayMirror(Type type) {
        MirrorType component = this.loadMirror(type);
        return component != null ? new ArrayType(this.context, component) : null;
    }

    public static Logger addMacro(BaseType type, String name) {
        Logger logger;
        MacroMember member = BytecodeMirrorLoader.internalAddMacro(type, name);
        Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINE)) {
            Logger logger2 = gensym0;
            logger = logger2;
            logger2.fine("Loaded macro " + member);
        } else {
            logger = null;
        }
        return logger;
    }

    public static MacroMember internalAddMacro(BaseType type, String name) {
        ClassLoader classloader = (ClassLoader)type.context().get(ClassLoader.class);
        Class<?> klass = classloader != null ? classloader.loadClass(name) : Class.forName(name);
        MacroMember member = MacroMember.create(klass, type, type.context());
        type.add(member);
        return member;
    }

    public static BytecodeMirrorLoader extendClass(BaseType type, Class extensions) {
        Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINE)) {
            gensym0.fine("extend class " + type + " with " + extensions);
        }
        ClassLoader mirah_classloader = extensions.getClassLoader();
        String path = extensions.getName().replace('.', '/') + ".class";
        ClassNode node = BytecodeMirrorLoader.class_node_for(mirah_classloader.getResourceAsStream(path));
        BytecodeMirrorLoader.findOldAndNewStyleMacros(mirah_classloader, type, node, path);
        return null;
    }

    public static void findOldAndNewStyleMacros(ClassLoader macro_loader, BaseType type, ClassNode initialByteCode, String classfile) {
        block6: {
            block5: {
                InputStream bytecode;
                if (initialByteCode == null) {
                    return;
                }
                if (macro_loader == null) {
                    return;
                }
                Logger gensym0 = log.internal_logger();
                if (gensym0.isLoggable(Level.FINER)) {
                    gensym0.finer("  attempting old style lookup on: " + classfile);
                }
                BytecodeMirrorLoader.findAndAddMacros(initialByteCode, type);
                String new_style_extension_classname = classfile.replace(".class", "$Extensions.class");
                Logger gensym1 = log.internal_logger();
                if (gensym1.isLoggable(Level.FINER)) {
                    gensym1.finer("  attempting new style: " + new_style_extension_classname);
                }
                if ((bytecode = macro_loader.getResourceAsStream(new_style_extension_classname)) == null) break block5;
                Logger gensym2 = log.internal_logger();
                if (gensym2.isLoggable(Level.FINE)) {
                    gensym2.fine("  macro class found on classpath");
                }
                ClassNode node = BytecodeMirrorLoader.class_node_for(bytecode);
                BytecodeMirrorLoader.findAndAddMacros(node, type);
                break block6;
            }
            Logger gensym3 = log.internal_logger();
            if (!gensym3.isLoggable(Level.FINER)) break block6;
            gensym3.finer("  macro class not found on classpath");
        }
    }

    public static void findAndAddMacros(ClassNode node, BaseType type) {
        List macros = BytecodeMirrorLoader.findMacros(node);
        Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINE)) {
            gensym0.fine("  found " + macros.size() + " macros. Loading");
        }
        for (Object name : macros) {
            MacroMember member = BytecodeMirrorLoader.internalAddMacro(type, (String)name);
            Logger gensym2 = log.internal_logger();
            if (!gensym2.isLoggable(Level.FINE)) continue;
            gensym2.fine("    " + member);
        }
    }

    public static List findMacros(ClassNode klass) {
        if (klass.invisibleAnnotations != null) {
            for (Object a : klass.invisibleAnnotations) {
                AnnotationNode annotation = (AnnotationNode)a;
                if (!"Lorg/mirah/macros/anno/Extensions;".equals(annotation.desc)) continue;
                return (List)annotation.values.get(1);
            }
        }
        return Collections.emptyList();
    }

    public static ClassNode class_node_for(InputStream bytecode) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytecode);
        reader.accept(node, ClassReader.SKIP_CODE);
        return node;
    }

    public BytecodeMirrorLoader(Context context, ResourceLoader resourceLoader) {
        this(context, resourceLoader, null);
    }
}

