/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mirah.jvm.mirrors.MirrorScope;
import org.mirah.typer.TypeFuture;

public class ImportsAndSearchPackages {
    private Map imports;
    private HashSet staticImports;
    private List search_packages = new ArrayList(0);

    public Map imports() {
        return this.imports;
    }

    public List search_packages() {
        return this.search_packages;
    }

    public Set staticImports() {
        return this.staticImports;
    }

    public ImportsAndSearchPackages() {
        this.imports = new HashMap(16);
        this.staticImports = new HashSet();
    }

    public void add(String fullname, String shortname) {
        if ("*".equals(shortname)) {
            this.search_packages.add(fullname);
        } else {
            this.imports.put(shortname, fullname);
        }
    }

    public void addStaticImport(TypeFuture type) {
        this.staticImports.add(type);
    }

    public Map collect_imports(Map map, MirrorScope outer_scope) {
        if (outer_scope != null) {
            outer_scope.fetch_imports(map);
        }
        map.putAll(this.imports);
        return map;
    }

    public List collect_search_packages(List list, MirrorScope outer_scope) {
        if (outer_scope != null) {
            outer_scope.fetch_packages(list);
        }
        list.addAll(this.search_packages);
        return list;
    }

    public Set collect_static_imports(Set set, MirrorScope outer_scope) {
        if (outer_scope != null) {
            outer_scope.fetch_static_imports(set);
        }
        set.addAll(this.staticImports);
        return set;
    }
}

