/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.AsyncMember;
import org.mirah.jvm.mirrors.JvmErrorType;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodListener;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirahMethod$1;
import org.mirah.jvm.mirrors.MirahMethod$2;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.OverrideFuture;
import org.mirah.jvm.mirrors.ReturnTypeFuture;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.DelegateFuture;
import org.mirah.typer.DerivedFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;

public class MirahMethod
extends AsyncMember
implements MethodListener {
    private ReturnTypeFuture return_type;
    private TypeFuture declared_return_type;
    private MethodLookup lookup;
    private int arity;
    private DelegateFuture super_return_type;
    private Context context;
    private DelegateFuture[] arguments;
    private Position position;
    private ErrorType error;

    public MirahMethod(Context context, Position position, int flags, MirrorType klass, String name, List argumentTypes, TypeFuture returnType, MemberKind kind) {
        this.return_type = new ReturnTypeFuture(context, position);
        super(flags, klass, name, argumentTypes, this.return_type, kind);
        this.context = context;
        this.lookup = (MethodLookup)context.get(MethodLookup.class);
        this.position = position;
        this.super_return_type = new DelegateFuture();
        this.declared_return_type = returnType;
        this.return_type.declare(this.wrap(this.super_return_type), position);
        this.return_type.error_message_set("Cannot determine return type.");
        this.arity = argumentTypes.size();
        this.setupOverrides(argumentTypes);
    }

    public ErrorType generate_error() {
        ErrorType errorType;
        if (this.error != null) {
            errorType = this.error;
        } else {
            ArrayList arrayList = new ArrayList(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add("Does not override a method from a supertype.");
            arrayList2.add(this.position);
            arrayList.add(arrayList2);
            errorType = this.error = new ErrorType(arrayList);
        }
        return errorType;
    }

    public TypeFuture wrap(TypeFuture target) {
        MirahMethod$1 mirahMethod$1 = new MirahMethod$1();
        mirahMethod$1.me = this;
        return new DerivedFuture(target, new MirahMethod$2(mirahMethod$1));
    }

    public ResolvedType wrap_error(ResolvedType type) {
        return new JvmErrorType(this.context, (ErrorType)type);
    }

    public void setupOverrides(List argumentTypes) {
        boolean args_declared;
        boolean gensym0 = true;
        for (AssignableTypeFuture x : argumentTypes) {
            boolean $or$1 = x.hasDeclaration();
            if ($or$1 ? $or$1 : x.assignedValues(false, false).size() > 0) continue;
            gensym0 = false;
            break;
        }
        if (!(args_declared = gensym0)) {
            this.declareArguments(argumentTypes);
        }
        MirrorType type = (MirrorType)this.declaringClass();
        type.addMethodListener(this.name(), this);
        this.checkOverrides();
    }

    public void declareArguments(List argumentTypes) {
        int size = argumentTypes.size();
        this.arguments = new DelegateFuture[size];
        int i = 0;
        int gensym0 = size;
        if (i < gensym0) {
            do {
                this.arguments[i] = new DelegateFuture();
                this.arguments[i].type_set(this.generate_error());
                AssignableTypeFuture arg = (AssignableTypeFuture)argumentTypes.get(i);
                boolean $or$2 = arg.hasDeclaration();
                if ($or$2 ? $or$2 : arg.assignedValues(false, false).size() > 0) continue;
                arg.declare(this.arguments[i], this.position);
            } while (++i < gensym0);
        }
    }

    @Override
    public void methodChanged(JVMType type, String name) {
        this.checkOverrides();
    }

    public void checkOverrides() {
        List supertype_methods = this.lookup.findOverrides((MirrorType)this.declaringClass(), this.name(), this.arity);
        if (this.arguments != null) {
            this.processArguments(supertype_methods);
        }
        this.processReturnType(supertype_methods);
    }

    public void processArguments(List supertype_methods) {
        if (supertype_methods.size() == 1) {
            Member method = (Member)supertype_methods.get(0);
            int i = 0;
            int gensym0 = this.arity;
            if (i < gensym0) {
                do {
                    this.arguments[i].type_set(method.asyncArgument(i));
                } while (++i < gensym0);
            }
        } else {
            ErrorType errorType;
            if (supertype_methods.isEmpty()) {
                errorType = this.generate_error();
            } else {
                ArrayList arrayList = new ArrayList(1);
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add("Ambiguous override: " + supertype_methods);
                arrayList2.add(this.position);
                arrayList.add(arrayList2);
                errorType = new ErrorType(arrayList);
            }
            ErrorType error = errorType;
            DelegateFuture[] gensym1 = this.arguments;
            int gensym2 = 0;
            if (gensym2 < gensym1.length) {
                do {
                    DelegateFuture arg = gensym1[gensym2];
                    arg.type_set(error);
                } while (++gensym2 < gensym1.length);
            }
        }
    }

    public void processReturnType(List supertype_methods) {
        if (this.declared_return_type != null) {
            this.super_return_type.type_set(this.declared_return_type);
            this.return_type.setHasDeclaration(true);
            return;
        }
        ArrayList<Member> filtered = new ArrayList<Member>(supertype_methods.size());
        for (Member method : supertype_methods) {
            boolean match = true;
            Iterator gensym1 = this.argumentTypes().iterator();
            Iterator gensym2 = method.argumentTypes().iterator();
            while (gensym1.hasNext()) {
                ResolvedType a = (ResolvedType)gensym1.next();
                ResolvedType b = gensym2.hasNext() ? gensym2.next() : null;
                boolean $or$3 = a.isError();
                if (($or$3 ? $or$3 : b.isError()) || ((MirrorType)a).isSameType((MirrorType)b)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            filtered.add(method);
        }
        if (filtered.isEmpty()) {
            this.super_return_type.type_set(this.generate_error());
            this.return_type.setHasDeclaration(false);
        } else {
            this.return_type.setHasDeclaration(true);
            OverrideFuture future = new OverrideFuture();
            for (Member m : filtered) {
                future.addType(m.asyncReturnType());
            }
            future.addType(((Member)supertype_methods.get(0)).asyncReturnType());
            this.super_return_type.type_set(future);
        }
    }
}

