/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mirah.jvm.mirrors.AsyncMirror;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.types.JVMField;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class MirahMirror
extends AsyncMirror {
    private int flags;
    private Member default_constructor;
    private Map fields;

    @Override
    public int flags() {
        return this.flags;
    }

    public void flags_set(int value) {
        this.flags = value;
    }

    public MirahMirror(Context context, Type type, int flags, TypeFuture superclass, TypeFuture[] interfaces) {
        super(context, type, flags, superclass, interfaces);
        this.flags = flags;
        this.default_constructor = new Member(Opcodes.ACC_PUBLIC, this, "<init>", new ArrayList(0), this, MemberKind.CONSTRUCTOR);
        this.fields = new HashMap(16);
    }

    public Map getTypeVariableMap() {
        return Collections.emptyMap();
    }

    @Override
    public void declareField(JVMField field) {
        this.fields.put(field.name(), field);
    }

    @Override
    public JVMField[] getDeclaredFields() {
        JVMField[] fields = new JVMField[this.fields.size()];
        this.fields.values().toArray(fields);
        return fields;
    }

    @Override
    public JVMField getDeclaredField(String name) {
        return (JVMField)this.fields.get(name);
    }

    @Override
    public List getDeclaredMethods(String name) {
        ArrayList<Member> arrayList;
        ArrayList<Member> result = super.getDeclaredMethods(name);
        if (result.isEmpty() ? "<init>".equals(name) : false) {
            ArrayList<Member> arrayList2 = new ArrayList<Member>(1);
            arrayList = arrayList2;
            arrayList2.add(this.default_constructor);
        } else {
            arrayList = result;
        }
        return arrayList;
    }
}

