/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import javax.lang.model.util.Types;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.Node;
import mirah.lang.ast.Position;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeRef;
import org.mirah.MirahLogFormatter;
import org.mirah.jvm.mirrors.ArrayType;
import org.mirah.jvm.mirrors.AsyncLoaderAdapter;
import org.mirah.jvm.mirrors.AsyncMember;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.BlockType;
import org.mirah.jvm.mirrors.BytecodeMirrorLoader;
import org.mirah.jvm.mirrors.ClassResourceLoader;
import org.mirah.jvm.mirrors.ImplicitNil;
import org.mirah.jvm.mirrors.JvmErrorType;
import org.mirah.jvm.mirrors.MacroMember;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MetaType;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirahMethod;
import org.mirah.jvm.mirrors.MirahMirror;
import org.mirah.jvm.mirrors.MirrorFuture;
import org.mirah.jvm.mirrors.MirrorObjectExtensions;
import org.mirah.jvm.mirrors.MirrorProxy;
import org.mirah.jvm.mirrors.MirrorScope;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem$1;
import org.mirah.jvm.mirrors.MirrorTypeSystem$10;
import org.mirah.jvm.mirrors.MirrorTypeSystem$11;
import org.mirah.jvm.mirrors.MirrorTypeSystem$12;
import org.mirah.jvm.mirrors.MirrorTypeSystem$13;
import org.mirah.jvm.mirrors.MirrorTypeSystem$14;
import org.mirah.jvm.mirrors.MirrorTypeSystem$15;
import org.mirah.jvm.mirrors.MirrorTypeSystem$16;
import org.mirah.jvm.mirrors.MirrorTypeSystem$17;
import org.mirah.jvm.mirrors.MirrorTypeSystem$2;
import org.mirah.jvm.mirrors.MirrorTypeSystem$3;
import org.mirah.jvm.mirrors.MirrorTypeSystem$4;
import org.mirah.jvm.mirrors.MirrorTypeSystem$5;
import org.mirah.jvm.mirrors.MirrorTypeSystem$6;
import org.mirah.jvm.mirrors.MirrorTypeSystem$7;
import org.mirah.jvm.mirrors.MirrorTypeSystem$8;
import org.mirah.jvm.mirrors.MirrorTypeSystem$9;
import org.mirah.jvm.mirrors.NullType;
import org.mirah.jvm.mirrors.PrimitiveLoader;
import org.mirah.jvm.mirrors.ResourceLoader;
import org.mirah.jvm.mirrors.SimpleAsyncMirrorLoader;
import org.mirah.jvm.types.JVMField;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.macros.ExtensionsProvider;
import org.mirah.macros.ExtensionsService;
import org.mirah.macros.anno.ExtensionsRegistration;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.CallFuture;
import org.mirah.typer.DelegateFuture;
import org.mirah.typer.DerivedFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.GenericTypeFuture;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.NarrowingTypeFuture;
import org.mirah.typer.PickFirst;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeFutureTypeRef;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.UnreachableType;
import org.mirah.util.Context;
import org.mirah.util.Logger;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MirrorTypeSystem
implements TypeSystem,
ExtensionsService {
    private TypeFuture object_future;
    private Map anonymousClasses;
    private TypeFuture void;
    private HashSet array_extensions;
    private static Logger log = Logger.getLogger(MirrorTypeSystem.class.getName());
    private SimpleAsyncMirrorLoader loader;
    private MethodLookup methods;
    private BaseTypeFuture implicit_nil;
    private Map unpinned_field_futures;
    private Map primitives;
    private Map cached_array_types;
    private Context context;
    private BlockType block;
    private BaseTypeFuture nullType;
    private BaseType object;

    public MirrorTypeSystem(Context context, ResourceLoader classloader) {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("boolean", "Z");
        hashMap.put("byte", "B");
        hashMap.put("char", "C");
        hashMap.put("short", "S");
        hashMap.put("int", "I");
        hashMap.put("long", "J");
        hashMap.put("float", "F");
        hashMap.put("double", "D");
        hashMap.put("void", "V");
        this.primitives = hashMap;
        if (context == null) {
            context = new Context();
        }
        this.context = context;
        context.add(MirrorTypeSystem.class, this);
        if (classloader == null) {
            classloader = new ClassResourceLoader(MirrorTypeSystem.class);
        }
        BytecodeMirrorLoader bytecode_loader = new BytecodeMirrorLoader(context, classloader, new PrimitiveLoader(context));
        this.loader = new SimpleAsyncMirrorLoader(context, new AsyncLoaderAdapter(context, bytecode_loader));
        this.methods = new MethodLookup(context);
        context.add(MethodLookup.class, this.methods);
        context.add(Types.class, new org.mirah.jvm.model.Types(context));
        this.object_future = this.wrap(Type.getType("Ljava/lang/Object;"));
        this.object = (BaseType)this.object_future.resolve();
        this.anonymousClasses = new HashMap(16);
        this.unpinned_field_futures = new HashMap(16);
        this.cached_array_types = new HashMap(16);
        this.array_extensions = new HashSet();
        this.register_extensions();
        this.addObjectIntrinsics();
        this.initBoxes();
    }

    public Context context() {
        return this.context;
    }

    public DelegateFuture parameterize(TypeFuture type, List args, Map seen_signatures) {
        new MirrorTypeSystem$1().args = args;
        new MirrorTypeSystem$1().seen_signatures = seen_signatures;
        MirrorTypeSystem$1 mirrorTypeSystem$1 = new MirrorTypeSystem$1();
        mirrorTypeSystem$1.context = this.context;
        mirrorTypeSystem$1.future = new DelegateFuture();
        mirrorTypeSystem$1.future.type_set(type);
        type.onUpdate(new MirrorTypeSystem$2(mirrorTypeSystem$1));
        return mirrorTypeSystem$1.future;
    }

    public DerivedFuture box(TypeFuture type) {
        MirrorTypeSystem$3 mirrorTypeSystem$3 = new MirrorTypeSystem$3();
        return new DerivedFuture(type, new MirrorTypeSystem$4(mirrorTypeSystem$3));
    }

    @Override
    public TypeFuture getSuperClass(TypeFuture type) {
        MirrorTypeSystem$5 mirrorTypeSystem$5 = new MirrorTypeSystem$5();
        return new DerivedFuture(type, new MirrorTypeSystem$6(mirrorTypeSystem$5));
    }

    @Override
    public TypeFuture getMainType(Scope scope, Script script) {
        return this.getMetaType(this.defineType(scope, script, MirrorTypeSystem.getMainClassName(script), null, new ArrayList(0)));
    }

    public static String getMainClassName(Script script) {
        String $or$1 = (((script != null ? script.position() : null) != null ? script.position().source() : null) != null ? script.position().source().name() : null) != null ? MirrorTypeSystem.classnameFromFilename(script.position().source().name()) : null;
        return $or$1 != null ? $or$1 : "DashE";
    }

    @Override
    public void addDefaultImports(Scope scope) {
        scope.import("java.lang", "*");
    }

    @Override
    public TypeFuture getFixnumType(long value) {
        TypeFuture typeFuture;
        Long box = value;
        if ((long)box.intValue() != value) {
            typeFuture = this.wrap(Type.getType("J"));
        } else if ((long)box.shortValue() != value) {
            typeFuture = this.wrap(Type.getType("I"));
        } else {
            TypeFuture wide = this.wrap(Type.getType("I"));
            TypeFuture narrow = (long)box.byteValue() == value ? this.wrap(Type.getType("B")) : this.wrap(Type.getType("S"));
            typeFuture = new NarrowingTypeFuture(null, wide.resolve(), narrow.resolve());
        }
        return typeFuture;
    }

    @Override
    public TypeFuture getCharType(int value) {
        return this.wrap(Type.getType("C"));
    }

    @Override
    public TypeFuture getFloatType(double value) {
        TypeFuture typeFuture;
        Double box = value;
        TypeFuture wide = this.wrap(Type.getType("D"));
        if (value == (double)box.floatValue()) {
            TypeFuture narrow = this.wrap(Type.getType("F"));
            typeFuture = new NarrowingTypeFuture(null, wide.resolve(), narrow.resolve());
        } else {
            typeFuture = wide;
        }
        return typeFuture;
    }

    @Override
    public TypeFuture getVoidType() {
        return this.void != null ? this.void : (this.void = this.wrap(Type.getType("V")));
    }

    @Override
    public ResolvedType getBlockType() {
        return this.block != null ? this.block : (this.block = new BlockType());
    }

    @Override
    public TypeFuture getBooleanType() {
        return this.wrap(Type.getType("Z"));
    }

    @Override
    public TypeFuture getImplicitNilType() {
        BaseTypeFuture baseTypeFuture;
        if (this.implicit_nil != null) {
            baseTypeFuture = this.implicit_nil;
        } else {
            BaseTypeFuture baseTypeFuture2 = new BaseTypeFuture();
            baseTypeFuture2.resolved(new ImplicitNil());
            baseTypeFuture = this.implicit_nil = baseTypeFuture2;
        }
        return baseTypeFuture;
    }

    @Override
    public TypeFuture getStringType() {
        return this.wrap(Type.getType("Ljava/lang/String;"));
    }

    @Override
    public TypeFuture getRegexType() {
        return this.wrap(Type.getType("Ljava/util/regex/Pattern;"));
    }

    @Override
    public TypeFuture getBaseExceptionType() {
        return this.wrap(Type.getType("Ljava/lang/Throwable;"));
    }

    @Override
    public TypeFuture getDefaultExceptionType() {
        return this.wrap(Type.getType("Ljava/lang/Exception;"));
    }

    @Override
    public TypeFuture getArrayLiteralType(TypeFuture valueType, Position position) {
        GenericTypeFuture typevar = new GenericTypeFuture(position, this.object);
        typevar.assign(this.box(valueType), position);
        TypeFuture typeFuture = this.loadNamedType("java.util.List");
        ArrayList<GenericTypeFuture> arrayList = new ArrayList<GenericTypeFuture>(1);
        arrayList.add(typevar);
        return this.parameterize(typeFuture, arrayList);
    }

    @Override
    public TypeFuture getHashLiteralType(TypeFuture keyType, TypeFuture valueType, Position position) {
        GenericTypeFuture keyVar = new GenericTypeFuture(position, this.object);
        keyVar.assign(this.box(keyType), position);
        GenericTypeFuture valueVar = new GenericTypeFuture(position, this.object);
        valueVar.assign(this.box(valueType), position);
        TypeFuture typeFuture = this.loadNamedType("java.util.Map");
        ArrayList<GenericTypeFuture> arrayList = new ArrayList<GenericTypeFuture>(2);
        arrayList.add(keyVar);
        arrayList.add(valueVar);
        return this.parameterize(typeFuture, arrayList);
    }

    @Override
    public MethodFuture getMethodDefType(TypeFuture target, String name, List argTypes, TypeFuture declaredReturnType, Position position) {
        name = name.replaceAll("=$", "_set");
        return this.createMember((MirrorType)target.peekInferredType(), name, argTypes, declaredReturnType, position);
    }

    @Override
    public TypeFuture getNullType() {
        BaseTypeFuture baseTypeFuture;
        if (this.nullType != null) {
            baseTypeFuture = this.nullType;
        } else {
            BaseTypeFuture baseTypeFuture2 = new BaseTypeFuture();
            baseTypeFuture2.resolved(new NullType());
            baseTypeFuture = this.nullType = baseTypeFuture2;
        }
        return baseTypeFuture;
    }

    @Override
    public TypeFuture getMethodType(CallFuture call) {
        new MirrorTypeSystem$7().call = call;
        MirrorTypeSystem$7 mirrorTypeSystem$7 = new MirrorTypeSystem$7();
        mirrorTypeSystem$7.future = new DelegateFuture();
        if (mirrorTypeSystem$7.call.resolved_target() != null) {
            boolean $or$2 = mirrorTypeSystem$7.call.resolved_target().isError();
            if ($or$2 ? $or$2 : mirrorTypeSystem$7.call.resolved_target() instanceof UnreachableType) {
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved(mirrorTypeSystem$7.call.resolved_target());
                return baseTypeFuture;
            }
            mirrorTypeSystem$7.target = (MirrorType)mirrorTypeSystem$7.call.resolved_target();
            mirrorTypeSystem$7.method_name = this.resolveMethodName(mirrorTypeSystem$7.call.scope(), mirrorTypeSystem$7.target, mirrorTypeSystem$7.call.name());
            if ("<init>".equals(mirrorTypeSystem$7.method_name)) {
                mirrorTypeSystem$7.target = mirrorTypeSystem$7.target.unmeta();
            }
            ArrayList arrayList = new ArrayList(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add("Can't find method " + this.format(mirrorTypeSystem$7.target, mirrorTypeSystem$7.call.name(), mirrorTypeSystem$7.call.resolved_parameters()));
            arrayList2.add(mirrorTypeSystem$7.call.position());
            arrayList.add(arrayList2);
            mirrorTypeSystem$7.error = new JvmErrorType(arrayList, Type.getType("V"), null);
            mirrorTypeSystem$7.macro_params = new LinkedList();
            List nodes = mirrorTypeSystem$7.call.parameterNodes();
            if (nodes != null) {
                for (Object n : nodes) {
                    String typename = n.getClass().getName();
                    mirrorTypeSystem$7.macro_params.add(this.loadMacroType(typename));
                }
            }
            TypeFuture method = this.methods.findMethod(mirrorTypeSystem$7.call.scope(), mirrorTypeSystem$7.target, mirrorTypeSystem$7.method_name, mirrorTypeSystem$7.call.resolved_parameters(), mirrorTypeSystem$7.macro_params, mirrorTypeSystem$7.call.position(), !mirrorTypeSystem$7.call.explicitTarget());
            TypeFuture $or$3 = method;
            mirrorTypeSystem$7.future.type_set($or$3 != null ? $or$3 : mirrorTypeSystem$7.error);
            Logger log = MirrorTypeSystem.log;
            java.util.logging.Logger gensym1 = log.internal_logger();
            if (gensym1.isLoggable(Level.FINER)) {
                gensym1.finer("Adding listener for " + mirrorTypeSystem$7.target + "." + mirrorTypeSystem$7.method_name + " (" + mirrorTypeSystem$7.target.getClass() + ")");
            }
            mirrorTypeSystem$7.method_lookup = this.methods;
            mirrorTypeSystem$7.listener = new MirrorTypeSystem$8(mirrorTypeSystem$7);
            mirrorTypeSystem$7.target.addMethodListener(mirrorTypeSystem$7.method_name, mirrorTypeSystem$7.listener);
            boolean $or$5 = mirrorTypeSystem$7.call.explicitTarget();
            if (!($or$5 ? $or$5 : mirrorTypeSystem$7.call.scope() == null)) {
                for (TypeFuture f : ((MirrorScope)mirrorTypeSystem$7.call.scope()).staticImports()) {
                    f.onUpdate(new MirrorTypeSystem$9(mirrorTypeSystem$7));
                }
            }
        }
        return mirrorTypeSystem$7.future;
    }

    @Override
    public AssignableTypeFuture getFieldType(TypeFuture target, String name, Position position) {
        MirrorType resolved = (MirrorType)target.peekInferredType();
        MirrorType klass = resolved.unmeta();
        JVMField member = klass.getDeclaredField(name);
        if (member != null) {
            java.util.logging.Logger gensym0_javalogger = log.internal_logger();
            if (gensym0_javalogger.isLoggable(Level.FINEST)) {
                gensym0_javalogger.finest("found declared field future for target: " + target + " name: " + name);
            }
            return (AssignableTypeFuture)((AsyncMember)member).asyncReturnType();
        }
        Object undeclared_future = this.unpinned_field_futures.get(this.unpinned_key(klass, name));
        if (undeclared_future != null) {
            java.util.logging.Logger gensym1_javalogger = log.internal_logger();
            if (gensym1_javalogger.isLoggable(Level.FINEST)) {
                gensym1_javalogger.finest("found undeclared field future for target: " + klass + " name: " + name);
            }
            return (AssignableTypeFuture)undeclared_future;
        }
        java.util.logging.Logger gensym2_javalogger = log.internal_logger();
        if (gensym2_javalogger.isLoggable(Level.FINEST)) {
            gensym2_javalogger.finest("creating undeclared field's future target: " + target + " name: " + name);
        }
        AssignableTypeFuture future = new AssignableTypeFuture(position);
        this.unpinned_field_futures.put(this.unpinned_key(klass, name), future);
        return future;
    }

    @Override
    public AssignableTypeFuture getFieldTypeOrDeclare(TypeFuture target, String name, Position position) {
        MirrorType resolved = (MirrorType)target.peekInferredType();
        MirrorType klass = resolved.unmeta();
        JVMField member = klass.getDeclaredField(name);
        TypeFuture future = member != null ? ((AsyncMember)member).asyncReturnType() : this.createField(klass, name, resolved.isMeta(), position);
        return (AssignableTypeFuture)future;
    }

    public String resolveMethodName(Scope scope, ResolvedType target, String name) {
        return ("initialize".equals(name) ? this.isConstructor(scope) : false) ? "<init>" : (("new".equals(name) ? target.isMeta() : false) ? "<init>" : name);
    }

    public boolean isConstructor(Scope scope) {
        if (scope == null) {
            return false;
        }
        Node context = scope.context();
        if (context == null) {
            return false;
        }
        if (context instanceof ConstructorDefinition) {
            return true;
        }
        return !(context.findAncestor(ConstructorDefinition.class) == null);
    }

    @Override
    public ResolvedType getMetaType(ResolvedType type) {
        MirrorType jvmType;
        return type.isError() ? type : ((jvmType = (MirrorType)type).isMeta() ? jvmType : new MetaType(jvmType));
    }

    @Override
    public TypeFuture getMetaType(TypeFuture type) {
        MirrorTypeSystem$10 mirrorTypeSystem$10 = new MirrorTypeSystem$10();
        mirrorTypeSystem$10.types = this;
        return new DerivedFuture(type, new MirrorTypeSystem$11(mirrorTypeSystem$10));
    }

    @Override
    public AssignableTypeFuture getLocalType(Scope scope, String name, Position position) {
        return ((MirrorScope)scope).getLocalType(name, position);
    }

    @Override
    public List getAbstractMethods(ResolvedType type) {
        return type instanceof MirrorType ? this.methods.gatherAbstractMethods((MirrorType)type) : Collections.emptyList();
    }

    public String calculateName(Scope scope, Node node, String name) {
        String string;
        if (name == null) {
            String outerName = scope.selfType().resolve().name();
            int id = 1;
            if (this.anonymousClasses.containsKey(outerName)) {
                id = (Integer)this.anonymousClasses.get(outerName) + 1;
            }
            this.anonymousClasses.put(outerName, new Integer(id));
            name = outerName + "$" + id;
            if (node != null) {
                ((ClassDefinition)node).name_set(new SimpleString(name));
            }
            string = name;
        } else {
            string = (((scope != null ? scope.package() : null) != null ? !scope.package().isEmpty() : false) ? !name.contains(".") : false) ? scope.package() + "." + name : name;
        }
        return string;
    }

    public MirahMirror findTypeDefinition(TypeFuture future) {
        ResolvedType resolved = future.peekInferredType();
        while (resolved instanceof MirrorProxy) {
            resolved = ((MirrorProxy)resolved).target();
        }
        return resolved instanceof MirahMirror ? (MirahMirror)resolved : null;
    }

    public TypeFuture defineType(Scope scope, Node node, String name, TypeFuture superclass, List interfaces) {
        TypeFuture type_future = this.createType(scope, node, name, superclass, interfaces);
        this.publishType(type_future);
        return type_future;
    }

    @Override
    public TypeFuture createType(Scope scope, Node node, String name, TypeFuture superclass, List interfaces) {
        Position position = node != null ? node.position() : null;
        String fullname = this.calculateName(scope, node, name);
        Type type = Type.getObjectType(fullname.replace('.', '/'));
        TypeFuture existing_future = ((DelegateFuture)this.wrap(type)).type();
        MirahMirror existing_type = this.findTypeDefinition(existing_future);
        if (existing_type != null) {
            boolean bl;
            if (superclass == null) {
                boolean $or$6;
                boolean bl2 = $or$6 = interfaces == null;
                bl = $or$6 ? $or$6 : interfaces.size() == 0;
            } else {
                bl = false;
            }
            if (bl) {
                return existing_future;
            }
        }
        if (superclass == null) {
            superclass = this.object_future;
        }
        TypeFuture[] interfaceArray = new TypeFuture[interfaces.size()];
        interfaces.toArray(interfaceArray);
        int flags = Opcodes.ACC_PUBLIC;
        if (node instanceof InterfaceDeclaration) {
            flags |= Opcodes.ACC_INTERFACE | Opcodes.ACC_ABSTRACT;
        }
        if (existing_type != null) {
            existing_type.setSupertypes(superclass, interfaceArray);
            existing_type.flags_set(flags);
            return existing_future;
        }
        MirahMirror mirror = new MirahMirror(this.context, type, flags, superclass, interfaceArray);
        this.addClassIntrinsic(mirror);
        MirrorFuture future = new MirrorFuture(mirror, position);
        return future;
    }

    @Override
    public void publishType(TypeFuture future) {
        block0: {
            if (!(future instanceof MirrorFuture)) break block0;
            MirrorFuture mirror_future = (MirrorFuture)future;
            this.publishType((MirahMirror)mirror_future.peekInferredType(), mirror_future);
        }
    }

    public void publishType(MirahMirror mirror, MirrorFuture future) {
        this.loader.defineMirror(mirror.getAsmType(), future);
    }

    @Override
    public TypeFuture get(Scope scope, TypeRef typeref) {
        if (typeref instanceof TypeFutureTypeRef) {
            return ((TypeFutureTypeRef)typeref).type_future();
        }
        String name = this.resolveName(scope, typeref.name());
        TypeFuture type = scope == null ? this.loadNamedType(name) : this.loadWithScope(scope, name, typeref.position());
        return typeref.isArray() ? this.getArrayType(type) : type;
    }

    public String resolveName(Scope scope, String name) {
        String $or$7;
        return scope != null ? (($or$7 = (String)scope.imports().get(name)) != null ? $or$7 : name) : name;
    }

    public MirrorType loadMacroType(String name) {
        Context $or$8 = (Context)this.context.get(Context.class);
        Context macro_context = $or$8 != null ? $or$8 : this.context;
        MirrorTypeSystem types = (MirrorTypeSystem)macro_context.get(MirrorTypeSystem.class);
        return (MirrorType)types.loadNamedType(name).resolve();
    }

    public TypeFuture loadNamedType(String name) {
        Object desc = this.primitives.get(name);
        Type type = desc != null ? Type.getType((String)desc) : Type.getObjectType(name.replace('.', '/'));
        return this.loader.loadMirrorAsync(type);
    }

    public TypeFuture loadWithScope(Scope scope, String name, Position position) {
        String packageName = scope.package();
        boolean $or$9 = packageName == null;
        boolean default_package = $or$9 ? $or$9 : packageName.isEmpty();
        LinkedList<TypeFuture> types = new LinkedList<TypeFuture>();
        for (Object p : scope.search_packages()) {
            String fullname = p + "." + name;
            types.add(this.loadNamedType(fullname));
            types.add(null);
        }
        types.addFirst(null);
        if (default_package) {
            types.addFirst(this.loadNamedType(name));
        } else {
            types.addFirst(this.loadNamedType(packageName + "." + name));
            types.addLast(this.loadNamedType(name));
            types.addLast(null);
        }
        PickFirst future = new PickFirst(types, null);
        future.position_set(position);
        future.error_message_set("Cannot find class " + name);
        return future;
    }

    public ResolvedType getResolvedArrayType(ResolvedType componentType) {
        Object object;
        Map $ptemp$10 = this.cached_array_types;
        ResolvedType $ptemp$11 = componentType;
        Object $or$12 = $ptemp$10.get($ptemp$11);
        if ($or$12 != null) {
            object = $or$12;
        } else {
            ArrayType val0 = new ArrayType(this.context, this.cast(componentType));
            $ptemp$10.put($ptemp$11, val0);
            object = val0;
        }
        return (ResolvedType)object;
    }

    @Override
    public ResolvedType getArrayType(ResolvedType componentType) {
        return this.getResolvedArrayType(componentType);
    }

    @Override
    public TypeFuture getArrayType(TypeFuture componentType) {
        MirrorTypeSystem$12 mirrorTypeSystem$12 = new MirrorTypeSystem$12();
        mirrorTypeSystem$12.types = this;
        return new DerivedFuture(componentType, new MirrorTypeSystem$13(mirrorTypeSystem$12));
    }

    @Override
    public void addMacro(ResolvedType klass, Class macro_impl) {
        block0: {
            MirrorType type = ((MirrorType)klass).unmeta();
            MacroMember member = MacroMember.create(macro_impl, type, this.context);
            type.add(member);
            java.util.logging.Logger gensym0 = log.internal_logger();
            if (!gensym0.isLoggable(Level.FINE)) break block0;
            gensym0.fine("Added macro " + member);
        }
    }

    @Override
    public void extendClass(String classname, Class extensions) {
        BaseType type = (BaseType)this.loadNamedType(classname).resolve();
        BytecodeMirrorLoader.extendClass(type, extensions);
    }

    public boolean register_array_extension(Class clazz) {
        return this.array_extensions.add(clazz);
    }

    public Object extendArray(BaseType type) {
        for (Class klass : this.array_extensions) {
            BytecodeMirrorLoader.extendClass(type, klass);
        }
        return null;
    }

    public BaseType addClassIntrinsic(BaseType type) {
        BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
        baseTypeFuture.resolved(type);
        BaseTypeFuture future = baseTypeFuture;
        TypeFuture klass = this.loadNamedType("java.lang.Class");
        ArrayList<BaseTypeFuture> arrayList = new ArrayList<BaseTypeFuture>(1);
        arrayList.add(future);
        JVMType generic_class = (JVMType)this.parameterize(klass, arrayList).resolve();
        BaseType baseType = type;
        baseType.add(new Member(Opcodes.ACC_PUBLIC | Opcodes.ACC_STATIC, type, "class", new ArrayList(0), generic_class, MemberKind.CLASS_LITERAL));
        return baseType;
    }

    public Object addObjectIntrinsics() {
        BytecodeMirrorLoader.extendClass(this.object, MirrorObjectExtensions.class);
        JVMType bool = (JVMType)this.getBooleanType().resolve();
        ResolvedType object_meta = this.getMetaType(this.object_future).resolve();
        ArrayList<Member> arrayList = new ArrayList<Member>(4);
        arrayList.add(new Member(Opcodes.ACC_PUBLIC, this.object, "nil?", new ArrayList(0), bool, MemberKind.IS_NULL));
        ArrayList<ResolvedType> arrayList2 = new ArrayList<ResolvedType>(1);
        arrayList2.add(object_meta);
        arrayList.add(new Member(Opcodes.ACC_PUBLIC, this.object, "kind_of?", arrayList2, bool, MemberKind.INSTANCEOF));
        ArrayList<BaseType> arrayList3 = new ArrayList<BaseType>(1);
        arrayList3.add(this.object);
        arrayList.add(new Member(Opcodes.ACC_PUBLIC, this.object, "===", arrayList3, bool, MemberKind.COMPARISON_OP));
        ArrayList<BaseType> arrayList4 = new ArrayList<BaseType>(1);
        arrayList4.add(this.object);
        arrayList.add(new Member(Opcodes.ACC_PUBLIC, this.object, "!==", arrayList4, bool, MemberKind.COMPARISON_OP));
        ArrayList<Member> methods = arrayList;
        NullType nullType = (NullType)this.getNullType().resolve();
        for (Member m : methods) {
            this.object.add(m);
            nullType.add(m);
        }
        ArrayList<Member> arrayList5 = new ArrayList<Member>(2);
        ArrayList<BaseType> arrayList6 = new ArrayList<BaseType>(1);
        arrayList6.add(this.object);
        arrayList5.add(new Member(Opcodes.ACC_PUBLIC, this.object, "==", arrayList6, bool, MemberKind.COMPARISON_OP));
        ArrayList<BaseType> arrayList7 = new ArrayList<BaseType>(1);
        arrayList7.add(this.object);
        arrayList5.add(new Member(Opcodes.ACC_PUBLIC, this.object, "!=", arrayList7, bool, MemberKind.COMPARISON_OP));
        for (Member m : arrayList5) {
            nullType.add(m);
        }
        return null;
    }

    public TypeFuture wrap(Type type) {
        return this.loader.loadMirrorAsync(type);
    }

    public MirrorType cast(ResolvedType type) {
        return type instanceof MirrorType ? (MirrorType)type : new JvmErrorType(((ErrorType)type).message(), Type.getType("Ljava/lang/Object;"), this.object);
    }

    public MethodFuture createMember(MirrorType target, String name, List arguments, TypeFuture returnType, Position position) {
        new MirrorTypeSystem$14().target = target;
        new MirrorTypeSystem$14().name = name;
        new MirrorTypeSystem$14().arguments = arguments;
        MirrorTypeSystem$14 mirrorTypeSystem$14 = new MirrorTypeSystem$14();
        AssignableTypeFuture returnFuture = new AssignableTypeFuture(position);
        int flags = Opcodes.ACC_PUBLIC;
        MemberKind kind = MemberKind.METHOD;
        mirrorTypeSystem$14.isMeta = mirrorTypeSystem$14.target.isMeta();
        if (mirrorTypeSystem$14.isMeta) {
            mirrorTypeSystem$14.target = mirrorTypeSystem$14.target.unmeta();
            flags |= Opcodes.ACC_STATIC;
            kind = MemberKind.STATIC_METHOD;
        }
        if (mirrorTypeSystem$14.target.isInterface()) {
            flags |= Opcodes.ACC_ABSTRACT;
        }
        if ("initialize".equals(mirrorTypeSystem$14.name)) {
            if (mirrorTypeSystem$14.isMeta) {
                mirrorTypeSystem$14.name = "<clinit>";
                kind = MemberKind.STATIC_INITIALIZER;
            } else {
                mirrorTypeSystem$14.name = "<init>";
                kind = MemberKind.CONSTRUCTOR;
            }
            returnType = this.getVoidType();
        }
        MirahMethod member = new MirahMethod(this.context, position, flags, mirrorTypeSystem$14.target, mirrorTypeSystem$14.name, mirrorTypeSystem$14.arguments, returnType, kind);
        returnFuture = (AssignableTypeFuture)member.asyncReturnType();
        mirrorTypeSystem$14.log = log;
        mirrorTypeSystem$14.me = this;
        returnFuture.onUpdate(new MirrorTypeSystem$15(mirrorTypeSystem$14));
        mirrorTypeSystem$14.target.add(member);
        return new MethodFuture(mirrorTypeSystem$14.name, member.argumentTypes(), returnFuture, false, position);
    }

    public TypeFuture createField(MirrorType target, String name, boolean isStatic, Position position) {
        MemberKind kind;
        new MirrorTypeSystem$16().target = target;
        new MirrorTypeSystem$16().name = name;
        MirrorTypeSystem$16 mirrorTypeSystem$16 = new MirrorTypeSystem$16();
        int flags = Opcodes.ACC_PRIVATE;
        if (isStatic) {
            kind = MemberKind.STATIC_FIELD_ACCESS;
            flags |= Opcodes.ACC_STATIC;
            mirrorTypeSystem$16.access = "static";
        } else {
            kind = MemberKind.FIELD_ACCESS;
            mirrorTypeSystem$16.access = "instance";
        }
        Object undeclared_future = this.unpinned_field_futures.get(this.unpinned_key(mirrorTypeSystem$16.target, mirrorTypeSystem$16.name));
        AssignableTypeFuture future = undeclared_future != null ? (AssignableTypeFuture)undeclared_future : new AssignableTypeFuture(position);
        mirrorTypeSystem$16.log = log;
        future.onUpdate(new MirrorTypeSystem$17(mirrorTypeSystem$16));
        AsyncMember member = new AsyncMember(flags, mirrorTypeSystem$16.target, mirrorTypeSystem$16.name, new ArrayList(0), future, kind);
        mirrorTypeSystem$16.target.declareField(member);
        return future;
    }

    public BaseType initBoxes() {
        this.setBox("Z", "Boolean");
        this.setBox("B", "Byte");
        this.setBox("C", "Character");
        this.setBox("S", "Short");
        this.setBox("I", "Integer");
        this.setBox("J", "Long");
        this.setBox("F", "Float");
        return this.setBox("D", "Double");
    }

    public BaseType setBox(String a, String b) {
        BaseType primitive = (BaseType)this.wrap(Type.getType(a)).resolve();
        BaseType boxed = (BaseType)this.loadNamedType("java.lang." + b).resolve();
        primitive.boxed_set(boxed);
        BaseType baseType = boxed;
        baseType.unboxed_set(primitive);
        return baseType;
    }

    public String format(ResolvedType target, String name, List args) {
        StringBuilder sb = new StringBuilder();
        sb.append(target);
        sb.append(".");
        sb.append(name);
        sb.append("(");
        int i = 0;
        for (Object arg : args) {
            TypeFuture future;
            if (arg instanceof TypeFuture && (future = (TypeFuture)arg).isResolved()) {
                arg = future.resolve();
            }
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arg);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public List unpinned_key(MirrorType resolvedTarget, String name) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(resolvedTarget);
        arrayList.add(name);
        return arrayList;
    }

    public static String classnameFromFilename(String name) {
        String basename = new File(name).getName();
        if (basename.endsWith(".mirah")) {
            basename = basename.substring(0, basename.length() - 6);
        }
        StringBuilder sb = new StringBuilder();
        int gensym1 = 0;
        String[] gensym0 = basename.split("[-_.]+");
        if (gensym1 < gensym0.length) {
            do {
                String s;
                if ((s = gensym0[gensym1]).length() > 0) {
                    sb.append(s.substring(0, 1).toUpperCase());
                }
                if (s.length() <= 1) continue;
                sb.append(s.substring(1, s.length()));
            } while (++gensym1 < gensym0.length);
        }
        sb.append("TopLevel");
        return sb.toString();
    }

    public static void main(String[] args) {
        Logger logger = new MirahLogFormatter(true).install();
        logger.setLevel(Level.ALL);
        MirrorTypeSystem types = new MirrorTypeSystem();
        ResolvedType a = types.getStringType().resolve();
        ResolvedType b = types.getRegexType().resolve();
        ResolvedType c = a.widen(b);
        System.out.println(c);
    }

    public void register_extensions() {
        block1: {
            java.util.logging.Logger gensym0 = log.internal_logger();
            if (gensym0.isLoggable(Level.FINE)) {
                gensym0.fine("register extensions");
            }
            ClassLoader boot_class_loader = MirrorTypeSystem.class.getClassLoader();
            this.register_extensions(boot_class_loader);
            ClassLoader compile_class_loader = (ClassLoader)this.context.get(ClassLoader.class);
            if (compile_class_loader == boot_class_loader) break block1;
            this.register_extensions(compile_class_loader);
        }
    }

    public void register_extensions(ClassLoader class_loader) {
        if (class_loader == null) {
            return;
        }
        ServiceLoader<ExtensionsProvider> services = ServiceLoader.load(ExtensionsProvider.class, class_loader);
        MirrorTypeSystem type_system = this;
        java.util.logging.Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINE)) {
            gensym0.fine("register extensions for services: " + services);
        }
        for (ExtensionsProvider provider : (Iterable)services) {
            provider.register(type_system);
        }
    }

    @Override
    public void macro_registration(Class clazz) {
        String[] gensym2;
        int gensym3;
        Class<?> macro_clazz;
        Class<?> clazz2;
        java.util.logging.Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINE)) {
            gensym0.fine("macro registration for: " + clazz);
        }
        ExtensionsRegistration anno = clazz.getAnnotation(ExtensionsRegistration.class);
        try {
            clazz2 = ((ClassLoader)this.context.get(ClassLoader.class)).loadClass(clazz.getName() + "$Extensions");
        }
        catch (Exception exception) {
            clazz2 = macro_clazz = null;
        }
        if (macro_clazz == null) {
            macro_clazz = clazz;
        }
        MirrorTypeSystem type_system = this;
        java.util.logging.Logger gensym1 = log.internal_logger();
        if (gensym1.isLoggable(Level.FINE)) {
            gensym1.fine("annotation: " + anno);
        }
        if (anno != null && (gensym3 = 0) < (gensym2 = anno.value()).length) {
            do {
                String class_name;
                if ((class_name = gensym2[gensym3]).equals("[]")) {
                    java.util.logging.Logger gensym4 = log.internal_logger();
                    if (gensym4.isLoggable(Level.FINE)) {
                        gensym4.fine("array extension: " + class_name + " " + macro_clazz);
                    }
                    type_system.register_array_extension(macro_clazz);
                    continue;
                }
                java.util.logging.Logger gensym5 = log.internal_logger();
                if (gensym5.isLoggable(Level.FINE)) {
                    gensym5.fine("extend class: " + class_name + " " + macro_clazz);
                }
                type_system.extendClass(class_name, macro_clazz);
            } while (++gensym3 < gensym2.length);
        }
    }

    public MirrorTypeSystem(Context context) {
        this(context, null);
    }

    public MirrorTypeSystem() {
        this(null, null);
    }
}

