/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import org.mirah.jvm.mirrors.MirrorProxy;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.CallType;
import org.mirah.jvm.types.GenericMethod;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.util.Comparisons;

public class ResolvedCall
extends MirrorProxy
implements CallType {
    private JVMMethod member;

    public ResolvedCall(MirrorType target, JVMMethod method) {
        super(ResolvedCall.expressionType(target, method));
        this.member = method;
    }

    public static ResolvedCall create(MirrorType target, JVMMethod method) {
        return new ResolvedCall(target, method);
    }

    public static MirrorType expressionType(MirrorType target, JVMMethod method) {
        MirrorType return_type = method instanceof GenericMethod ? (MirrorType)((GenericMethod)method).genericReturnType() : (MirrorType)method.returnType();
        return "V".equals(return_type.getAsmType().getDescriptor()) ? target : return_type;
    }

    @Override
    public JVMMethod member() {
        return this.member;
    }

    @Override
    public int hashCode() {
        return this.target().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        if (Comparisons.areSame(this, other)) {
            bl = true;
        } else if (other instanceof ResolvedCall) {
            ResolvedCall rc = (ResolvedCall)other;
            bl = this.target().equals(rc.target()) ? this.member.equals(rc.member()) : false;
        } else {
            bl = false;
        }
        return bl;
    }
}

