/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.logging.Level;
import javax.tools.DiagnosticListener;
import mirah.impl.MirahParser;
import mirah.lang.ast.Node;
import org.mirah.jvm.compiler.ReportedException;
import org.mirah.macros.JvmBackend;
import org.mirah.typer.BetterClosureBuilder;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.Logger;
import org.mirah.util.MirahDiagnostic;

public class SafeTyper
extends Typer {
    private DiagnosticListener diagnostics;
    private static Logger log = Logger.getLogger(SafeTyper.class.getName());

    public SafeTyper(Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser) {
        super(types, scopes, jvm_backend, parser);
        this.diagnostics = (DiagnosticListener)context.get(DiagnosticListener.class);
    }

    @Override
    public TypeFuture infer(Node node, boolean expression) {
        TypeFuture typeFuture;
        try {
            typeFuture = super.infer(node, expression);
        }
        catch (Exception ex$1630365845) {
            throw this.betterException(ex$1630365845, node);
        }
        return typeFuture;
    }

    @Override
    public BetterClosureBuilder finish_closures() {
        BetterClosureBuilder betterClosureBuilder;
        try {
            betterClosureBuilder = super.finish_closures();
        }
        catch (Exception ex$654734201) {
            throw this.betterException(ex$654734201);
        }
        return betterClosureBuilder;
    }

    public Throwable betterException(Throwable ex, Node node) {
        Throwable throwable;
        if (ex instanceof ReportedException) {
            throwable = new ReportedException(ex.getCause());
        } else if (ex.getCause() instanceof ReportedException) {
            throwable = ex.getCause();
        } else if (ex.getClass().getName().equals("org.jruby.exceptions.RaiseException")) {
            throwable = ex;
        } else {
            if (log.isLoggable(Level.FINE)) {
                java.util.logging.Logger gensym0 = log.internal_logger();
                Level gensym1 = Level.SEVERE;
                if (gensym0.isLoggable(Level.SEVERE)) {
                    gensym0.log(Level.SEVERE, "Exception in typer for " + node + "\n  " + this.sourceContent(node), ex);
                }
            }
            this.diagnostics.report(MirahDiagnostic.error(node != null ? node.position() : null, "Internal compiler error: " + ex + " " + ex.getMessage() + ". Rerun in verbose mode for stacktrace."));
            throwable = new ReportedException(ex);
        }
        return throwable;
    }

    public SafeTyper(Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend) {
        this(context, types, scopes, jvm_backend, null);
    }
}

