/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mirah.lang.ast.Node;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.BetterScope;
import org.mirah.jvm.mirrors.ImportsAndSearchPackages;
import org.mirah.jvm.mirrors.Locals;
import org.mirah.jvm.mirrors.MirrorScope;
import org.mirah.typer.LocalFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScriptScope
extends BetterScope {
    private ResolvedType binding_type;
    private ImportsAndSearchPackages imports;
    private List cached_search_packages;
    private String package;
    private Map cached_imports;
    private Object cached_package;
    private Scoper scoper;
    private ResolvedType declared_binding_type;
    private Set cached_static_imports;
    private TypeFuture selfType;
    private Locals locals;

    public ScriptScope(Scoper scoper, Node context) {
        super(context);
        this.scoper = scoper;
        this.imports = new ImportsAndSearchPackages();
        this.locals = new Locals();
    }

    @Override
    public LocalFuture getLocalType(String name, Position position) {
        return this.locals.local_type(name, position, (BetterScope)this.parent(), this.shadowed?(name));
    }

    @Override
    public boolean hasLocal(String name, boolean includeParent) {
        boolean $or$1 = this.locals.has_local(name);
        return $or$1 ? $or$1 : ((includeParent ? this.parent() : null) != null ? this.parent().hasLocal(name) : false);
    }

    @Override
    public boolean isCaptured(String name) {
        if (!this.locals.has_local(name)) {
            return false;
        }
        if (this.parent() != null ? this.parent().hasLocal(name) : false) {
            return true;
        }
        boolean gensym5 = false;
        for (BetterScope child : this.children()) {
            if (!child.hasLocal(name, false)) continue;
            gensym5 = true;
            break;
        }
        return gensym5;
    }

    @Override
    public List capturedLocals() {
        ArrayList captured = new ArrayList(this.locals.size());
        for (Object name : this.locals) {
            if (!this.isCaptured((String)name)) continue;
            captured.add(name);
        }
        return captured;
    }

    @Override
    public TypeFuture selfType() {
        return this.selfType;
    }

    @Override
    public void selfType_set(TypeFuture type) {
        this.selfType = type;
    }

    @Override
    public boolean shadowed?(String name) {
        return false;
    }

    @Override
    public void declared_binding_type_set(ResolvedType type) {
        this.declared_binding_type = type;
    }

    @Override
    public ResolvedType declared_binding_type() {
        return this.declared_binding_type;
    }

    @Override
    public ResolvedType binding_type() {
        return this.parent() != null ? this.parent().binding_type() : this.binding_type;
    }

    @Override
    public void binding_type_set(ResolvedType type) {
        if (this.parent() != null) {
            this.parent().binding_type_set(type);
        } else {
            this.binding_type = type;
        }
    }

    @Override
    public MirrorScope outer_scope() {
        boolean $or$2;
        boolean $or$1;
        boolean bl = $or$1 = this.scoper == null;
        boolean bl2 = $or$1 ? $or$1 : ($or$2 = this.context() == null);
        if ($or$2 ? $or$2 : this.context().parent() == null) {
            return null;
        }
        return (MirrorScope)this.scoper.getScope(this.context());
    }

    @Override
    public void flush_imports() {
        this.cached_imports = null;
        this.cached_package = null;
        this.cached_search_packages = null;
        this.cached_static_imports = null;
    }

    @Override
    public Map fetch_imports(Map map) {
        return this.imports.collect_imports(map, this.outer_scope());
    }

    @Override
    public List fetch_packages(List list) {
        return this.imports.collect_search_packages(list, this.outer_scope());
    }

    @Override
    public Set fetch_static_imports(Set set) {
        return this.imports.collect_static_imports(set, this.outer_scope());
    }

    @Override
    public Map imports() {
        return this.cached_imports != null ? this.cached_imports : (this.cached_imports = this.fetch_imports(new HashMap(16)));
    }

    @Override
    public List search_packages() {
        return this.cached_search_packages != null ? this.cached_search_packages : (this.cached_search_packages = this.fetch_packages(new ArrayList(0)));
    }

    @Override
    public Set staticImports() {
        return this.cached_static_imports != null ? this.cached_static_imports : (this.cached_static_imports = this.fetch_static_imports(new HashSet()));
    }

    @Override
    public void add_import(String fullname, String shortname) {
        this.import(fullname, shortname);
    }

    @Override
    public void import(String fullname, String shortname) {
        this.flush();
        this.imports.add(fullname, shortname);
    }

    @Override
    public void staticImport(TypeFuture type) {
        this.flush();
        this.imports.addStaticImport(type);
    }

    @Override
    public String package() {
        return this.package;
    }

    @Override
    public void package_set(String p) {
        this.package = p;
    }
}

