/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mirah.jvm.mirrors.AsyncMirror;
import org.mirah.jvm.mirrors.DeclaredMirrorType;
import org.mirah.jvm.mirrors.JvmErrorType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.generics.TypeInvocation$1;
import org.mirah.jvm.mirrors.generics.TypeInvocation$2;
import org.mirah.typer.ErrorType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Comparisons;
import org.mirah.util.Context;
import org.mirah.util.Logger;

public class TypeInvocation
extends AsyncMirror
implements DeclaredMirrorType {
    private List typeArguments;
    private TypeFuture[] interfaces;
    private static Logger log = Logger.getLogger(TypeInvocation.class.getName());
    private Context context;
    private Map typeVariableMap;
    private MirrorType raw;

    public TypeInvocation(Context context, MirrorType raw, TypeFuture superclass, TypeFuture[] interfaces, List args, Map typeVariableMap) {
        TypeInvocation$1 typeInvocation$1 = new TypeInvocation$1();
        super(context, raw.getAsmType(), raw.flags(), superclass, interfaces);
        this.context = context;
        this.raw = raw;
        this.interfaces = interfaces;
        this.typeArguments = args;
        typeInvocation$1.mirror = this;
        for (TypeFuture a : this.typeArguments) {
            a.onUpdate(new TypeInvocation$2(typeInvocation$1));
        }
        this.typeVariableMap = Collections.unmodifiableMap(new HashMap(typeVariableMap));
    }

    @Override
    public String signature() {
        return ((DeclaredMirrorType)this.raw).signature();
    }

    @Override
    public TypeFuture[] interfaces() {
        return this.interfaces;
    }

    @Override
    public List getTypeArguments() {
        if (this.typeArguments == null) {
            return new ArrayList(0);
        }
        List gensym0 = this.typeArguments;
        ArrayList<JvmErrorType> gensym1 = new ArrayList<JvmErrorType>(gensym0.size());
        for (TypeFuture a : gensym0) {
            ResolvedType resolved = a.resolve();
            gensym1.add((JvmErrorType)(resolved instanceof ErrorType ? new JvmErrorType(this.context, (ErrorType)resolved) : (MirrorType)resolved));
        }
        return gensym1;
    }

    @Override
    public Map getTypeVariableMap() {
        return this.typeVariableMap;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.raw);
        sb.append("<");
        boolean first = true;
        for (Object arg : this.getTypeArguments()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(arg);
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (Comparisons.areSame(this, other)) {
            return true;
        }
        return other instanceof MirrorType ? this.isSameType((MirrorType)other) : false;
    }

    @Override
    public int hashCode() {
        int hash = 23 + 37 * this.getTypeArguments().hashCode();
        return 37 * hash + this.getAsmType().hashCode();
    }

    @Override
    public boolean isSameType(MirrorType other) {
        if (other.getKind() != TypeKind.DECLARED) {
            return false;
        }
        Iterator gensym0 = this.getTypeArguments().iterator();
        Iterator<? extends TypeMirror> gensym1 = ((DeclaredType)((Object)other)).getTypeArguments().iterator();
        while (gensym0.hasNext()) {
            MirrorType a = (MirrorType)gensym0.next();
            MirrorType b = (MirrorType)(gensym1.hasNext() ? gensym1.next() : null);
            if (b == null) {
                return false;
            }
            if (a.isSameType(b)) continue;
            return false;
        }
        return this.getAsmType().equals(other.getAsmType());
    }

    @Override
    public boolean isSupertypeOf(MirrorType other) {
        boolean bl = this.getAsmType().equals(other.getAsmType()) ? other.getKind() == TypeKind.DECLARED : false;
        if (bl) {
            List<? extends TypeMirror> other_args = ((DeclaredType)((Object)other)).getTypeArguments();
            boolean $or$1 = other_args == null;
            if ($or$1 ? $or$1 : other_args.isEmpty()) {
                return true;
            }
            boolean match = true;
            Iterator gensym0 = this.getTypeArguments().iterator();
            Iterator<? extends TypeMirror> gensym1 = other_args.iterator();
            while (gensym0.hasNext()) {
                MirrorType a = (MirrorType)gensym0.next();
                MirrorType b = (MirrorType)(gensym1.hasNext() ? gensym1.next() : null);
                if (b != null ? a.isSupertypeOf(b) : false) continue;
                match = false;
                break;
            }
            return match;
        }
        boolean gensym2 = false;
        for (MirrorType x : other.directSupertypes()) {
            if (!this.isSupertypeOf(x)) continue;
            gensym2 = true;
            break;
        }
        return gensym2;
    }

    @Override
    public List directSupertypes() {
        LinkedList<MirrorType> types = new LinkedList<MirrorType>(super.directSupertypes());
        types.addFirst(this.raw);
        return types;
    }

    @Override
    public TypeMirror erasure() {
        return this.raw;
    }
}

