/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.mmeta;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseArrayList<T> {
    static final int leafPower = 6;
    static final int leafSize = SparseArrayList.twoN(6);
    static final int leafMask = leafSize - 1;
    private int last;
    private Object[][] root;

    private static int rootix(int i) {
        return i >> 6;
    }

    private static int leafix(int i) {
        return i & leafMask;
    }

    private static int twoN(int n) {
        return 1 << (n & 0x1F);
    }

    private static int roundToPower(int n) {
        if (n <= 2) {
            return 1;
        }
        for (int p = 0; p < 32; ++p) {
            if (1 << p < n) continue;
            return p;
        }
        throw new AssertionError((Object)("illegal val: " + n));
    }

    public SparseArrayList() {
        this(1024);
    }

    public SparseArrayList(int cap) {
        this.init(cap);
    }

    private void init(int cap) {
        if (cap <= leafSize) {
            cap = leafSize;
        }
        int power = SparseArrayList.roundToPower(cap);
        int size = SparseArrayList.twoN(power);
        this.root = new Object[SparseArrayList.rootix(size)][];
        this.last = -1;
    }

    private void resize(int cap) {
        if (cap <= leafSize) {
            cap = leafSize;
        }
        int power = SparseArrayList.roundToPower(cap);
        int size = SparseArrayList.twoN(power);
        this.root = (Object[][])Arrays.copyOf(this.root, SparseArrayList.rootix(size));
        if (this.get(this.last) == null) {
            this.findLast();
        }
    }

    private void findLast() {
        for (int ri = this.root.length - 1; ri >= 0; --ri) {
            Object[] leaf = this.root[ri];
            if (leaf == null) continue;
            for (int li = leaf.length - 1; li >= 0; --li) {
                if (leaf[li] == null) continue;
                this.last = leafSize * ri + li;
                return;
            }
            this.root[ri] = null;
        }
        this.last = -1;
    }

    public T get(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (index > this.last) {
            return null;
        }
        Object[] leaf = this.root[SparseArrayList.rootix(index)];
        if (leaf == null) {
            return null;
        }
        return (T)leaf[SparseArrayList.leafix(index)];
    }

    public T set(int index, T value) throws IndexOutOfBoundsException {
        Object[] leaf;
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (index > this.last) {
            if (value == null) {
                return null;
            }
            this.last = index;
        }
        if (SparseArrayList.rootix(index) >= this.root.length) {
            this.resize(index + 1);
        }
        if ((leaf = this.root[SparseArrayList.rootix(index)]) == null) {
            if (value == null) {
                return null;
            }
            leaf = new Object[leafSize];
            this.root[SparseArrayList.rootix((int)index)] = leaf;
        }
        Object old = leaf[SparseArrayList.leafix(index)];
        leaf[SparseArrayList.leafix((int)index)] = value;
        if (value == null && index == this.last) {
            this.findLast();
        }
        return (T)old;
    }

    public boolean add(T value) {
        this.set(this.last + 1, value);
        return true;
    }

    public T del(int index) throws IndexOutOfBoundsException {
        return this.set(this.last, null);
    }

    public int size() {
        return this.last + 1;
    }

    public boolean isEmpty() {
        return this.last < 0;
    }

    public void clear() {
        this.init(-1);
    }
}

