/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import mirah.lang.ast.StringCodeSource;

public class EncodedCodeSource
extends StringCodeSource {
    public EncodedCodeSource(String file_name, InputStream io, String encoding) {
        super(file_name, EncodedCodeSource.readToString(io, encoding));
    }

    public EncodedCodeSource(String file_name, String encoding) {
        this(file_name, new FileInputStream(file_name), encoding);
    }

    public EncodedCodeSource(String file_name) {
        this(file_name, new FileInputStream(file_name), Charset.defaultCharset().name());
    }

    public EncodedCodeSource(String file_name, InputStream io) {
        this(file_name, io, Charset.defaultCharset().name());
    }

    public static String DEFAULT_CHARSET() {
        return "utf-8";
    }

    public static String readToString(InputStream stream, String encoding) {
        int read;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));
        char[] buffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }
}

