/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.tools.DiagnosticListener;
import mirah.impl.MirahParser;
import mirah.lang.ast.CodeSource;
import mirah.lang.ast.Node;
import mirah.lang.ast.Script;
import org.mirah.IsolatedResourceLoader;
import org.mirah.MirahClassLoader;
import org.mirah.jvm.compiler.Backend;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.ExtensionCleanup;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.mirrors.BetterScopeFactory;
import org.mirah.jvm.mirrors.ClassLoaderResourceLoader;
import org.mirah.jvm.mirrors.ClassResourceLoader;
import org.mirah.jvm.mirrors.FilteredResources;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.NegativeFilteredResources;
import org.mirah.jvm.mirrors.ResourceLoader;
import org.mirah.jvm.mirrors.SafeTyper;
import org.mirah.jvm.mirrors.debug.DebugTyper;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.macros.JvmBackend;
import org.mirah.mmeta.SyntaxError;
import org.mirah.tool.CompilationFailure;
import org.mirah.tool.ErrorCollector;
import org.mirah.tool.Mirahc;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.SimpleScoper;
import org.mirah.util.AstChecker;
import org.mirah.util.AstFormatter;
import org.mirah.util.Context;
import org.mirah.util.LazyTypePrinter;
import org.mirah.util.Logger;
import org.mirah.util.SimpleDiagnostics;

public class MirahCompiler
implements JvmBackend {
    private JvmVersion jvm;
    private MirrorTypeSystem types;
    private String macro_destination;
    private SafeTyper typer;
    private static Logger log = Logger.getLogger(Mirahc.class.getName());
    private DebuggerInterface debugger;
    private String destination;
    private Backend macro_backend;
    private MirahClassLoader extension_loader;
    private Context macro_context;
    private Map extension_classes;
    private SimpleDiagnostics diagnostics;
    private MirahParser parser;
    private Context context;
    private SafeTyper macro_typer;
    private SimpleScoper scoper;
    private MirrorTypeSystem macro_types;
    private Backend backend;
    private List asts;

    public MirahCompiler(SimpleDiagnostics diagnostics, JvmVersion jvm, URL[] classpath, URL[] bootclasspath, URL[] macroclasspath, String destination, String macro_destination, DebuggerInterface debugger) {
        Context context;
        this.diagnostics = diagnostics;
        this.jvm = jvm;
        this.destination = destination;
        this.macro_destination = macro_destination;
        this.debugger = debugger;
        this.context = context = new Context();
        context.add(JvmBackend.class, this);
        context.add(DiagnosticListener.class, this.diagnostics);
        context.add(SimpleDiagnostics.class, this.diagnostics);
        context.add(JvmVersion.class, this.jvm);
        context.add(DebuggerInterface.class, debugger);
        this.macro_context = new Context();
        this.macro_context.add(JvmBackend.class, this);
        this.macro_context.add(DiagnosticListener.class, this.diagnostics);
        this.macro_context.add(SimpleDiagnostics.class, this.diagnostics);
        this.macro_context.add(JvmVersion.class, this.jvm);
        this.macro_context.add(DebuggerInterface.class, debugger);
        this.context.add(Context.class, this.macro_context);
        this.createTypeSystems(classpath, bootclasspath, macroclasspath);
        this.scoper = new SimpleScoper(new BetterScopeFactory());
        context.add(Scoper.class, this.scoper);
        this.parser = new MirahParser();
        context.add(MirahParser.class, this.parser);
        this.macro_context.add(Scoper.class, this.scoper);
        this.macro_context.add(MirahParser.class, this.parser);
        this.macro_typer = this.createTyper(debugger, this.macro_context, this.macro_types, this.scoper, this, this.parser);
        this.macro_context.add(Typer.class, this.macro_typer);
        this.typer = this.createTyper(debugger, context, this.types, this.scoper, this, this.parser);
        context.add(Typer.class, this.typer);
        this.typer.macro_compiler_set(this.macro_typer.macro_compiler());
        this.typer.macro_compiler().setMacroLoader(this.typer);
        this.backend = new Backend(context);
        this.macro_backend = new Backend(this.macro_context);
        this.asts = new ArrayList(0);
    }

    public List getParsedNodes() {
        return this.asts;
    }

    public SafeTyper createTyper(DebuggerInterface debugger, Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser) {
        return debugger == null ? new SafeTyper(context, types, scopes, jvm_backend, parser) : new DebugTyper(debugger, context, types, scopes, jvm_backend, parser);
    }

    public Node parse(CodeSource code) {
        Node node;
        try {
            node = (Node)this.parser.parse(code);
        }
        catch (SyntaxError e$1386429503) {
            throw new Exception(code.name() + " failed to parse.", e$1386429503);
        }
        if (node == null) {
            System.out.println(code.name() + " failed to parse.");
        } else {
            this.asts.add(node);
            if (this.debugger != null) {
                this.debugger.parsedNode(node);
            }
        }
        this.failIfErrors();
        return node;
    }

    public MirahCompiler infer() {
        List sorted_asts = this.asts;
        for (Node node : sorted_asts) {
            try {
                AstChecker.maybe_check(node);
                this.typer.infer(node, false);
                AstChecker.maybe_check(node);
                this.logAst(node, this.typer);
            }
            catch (Throwable throwable) {
                this.logAst(node, this.typer);
                throw throwable;
            }
        }
        this.typer.finish_closures();
        for (Node node : sorted_asts) {
            this.processInferenceErrors(node, this.context);
        }
        MirahCompiler mirahCompiler = this;
        mirahCompiler.failIfErrors();
        return mirahCompiler;
    }

    public void processInferenceErrors(Node node, Context context) {
        ErrorCollector errors = new ErrorCollector(context);
        errors.scan(node, null);
    }

    public void logAst(Node node, Typer typer) {
        block0: {
            java.util.logging.Logger gensym0 = log.internal_logger();
            Level gensym1 = Level.FINE;
            if (!gensym0.isLoggable(Level.FINE)) break block0;
            gensym0.log(Level.FINE, "Inferred types:\n{0}", new LazyTypePrinter(typer, node));
        }
    }

    @Override
    public void logExtensionAst(Node ast) {
        block0: {
            java.util.logging.Logger gensym0 = log.internal_logger();
            Level gensym1 = Level.FINE;
            if (!gensym0.isLoggable(Level.FINE)) break block0;
            gensym0.log(Level.FINE, "Inferred types:\n{0}", new AstFormatter(ast));
        }
    }

    public void failIfErrors() {
        if (this.diagnostics.errorCount() > 0) {
            throw new CompilationFailure();
        }
    }

    @Override
    public Class compileAndLoadExtension(Script ast) {
        this.logAst(ast, this.macro_typer);
        this.processInferenceErrors(ast, this.macro_context);
        this.failIfErrors();
        this.macro_backend.clean(ast, null);
        this.processInferenceErrors(ast, this.macro_context);
        this.failIfErrors();
        this.macro_backend.compile(ast, null);
        String class_name = Backend.write_out_file(this.macro_backend, this.extension_classes, this.macro_destination);
        return this.extension_loader.loadClass(class_name);
    }

    public Object compile(BytecodeConsumer generator) {
        for (Script node : this.asts) {
            this.backend.clean(node, null);
            node.accept(new ExtensionCleanup(this.macro_backend, this.extension_classes, this.macro_destination, this.macro_typer), new HashMap());
            this.processInferenceErrors(node, this.context);
        }
        this.failIfErrors();
        for (Script node : this.asts) {
            this.backend.compile(node, null);
        }
        return this.backend.generate(generator);
    }

    public FilteredResources createBootLoader(URL[] bootcp) {
        ResourceLoader bootloader = bootcp != null ? new ClassLoaderResourceLoader(new IsolatedResourceLoader(bootcp)) : new NegativeFilteredResources(new ClassResourceLoader(System.class), Pattern.compile("^/?(mirah/|org/mirah|org/jruby)"));
        return new FilteredResources(new ClassResourceLoader(Mirahc.class), Pattern.compile("^/?org/mirah/jvm/(types/(Flags|Member|Modifiers))|compiler/Cleaned"), bootloader);
    }

    public ClassLoaderResourceLoader createMacroLoader(URL[] macrocp) {
        ClassResourceLoader bootloader = new ClassResourceLoader(System.class);
        ClassLoaderResourceLoader macroloader = new ClassLoaderResourceLoader(new IsolatedResourceLoader(macrocp), new FilteredResources(new ClassResourceLoader(Mirahc.class), Pattern.compile("^/?(mirah/|org/mirah)"), bootloader));
        return macroloader;
    }

    public void createTypeSystems(URL[] classpath, URL[] bootcp, URL[] macrocp) {
        FilteredResources bootloader = this.createBootLoader(bootcp);
        ClassLoaderResourceLoader classloader = new ClassLoaderResourceLoader(new IsolatedResourceLoader(classpath), bootloader);
        if (macrocp == null) {
            macrocp = classpath;
        }
        ClassLoaderResourceLoader macroloader = this.createMacroLoader(macrocp);
        URLClassLoader macro_class_loader = new URLClassLoader(macrocp, MirahCompiler.class.getClassLoader());
        this.context.add(ClassLoader.class, macro_class_loader);
        this.macro_context.add(ClassLoader.class, macro_class_loader);
        this.extension_classes = new HashMap(16);
        URLClassLoader extension_parent = new URLClassLoader(macrocp, Mirahc.class.getClassLoader());
        this.extension_loader = new MirahClassLoader(extension_parent, this.extension_classes);
        this.macro_types = new MirrorTypeSystem(this.macro_context, macroloader);
        this.macro_context.add(TypeSystem.class, this.macro_types);
        this.types = new MirrorTypeSystem(this.context, classloader);
        this.context.add(TypeSystem.class, this.types);
    }

    public MirahCompiler(SimpleDiagnostics diagnostics, JvmVersion jvm, URL[] classpath, URL[] bootclasspath, URL[] macroclasspath, String destination, String macro_destination) {
        this(diagnostics, jvm, classpath, bootclasspath, macroclasspath, destination, macro_destination, null);
    }
}

