/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.Position;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.BlockFuture;
import org.mirah.typer.CallFuture$1;
import org.mirah.typer.CallFuture$2;
import org.mirah.typer.CallFuture$3;
import org.mirah.typer.CallFuture$4;
import org.mirah.typer.CallFuture$5;
import org.mirah.typer.CallFuture$6;
import org.mirah.typer.FuturePrinter;
import org.mirah.typer.InlineCode;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;

public class CallFuture
extends BaseTypeFuture {
    private TypeSystem types;
    private boolean explicitTarget;
    private TypeFuture method;
    private static org.mirah.util.Logger log = org.mirah.util.Logger.getLogger(CallFuture.class.getName());
    private List paramTypes;
    private Scope scope;
    private String name;
    private ResolvedType resolved_target;
    private ArrayList resolved_args;
    private List params;
    private TypeFuture target;

    public static org.mirah.util.Logger log() {
        return log;
    }

    public CallFuture(TypeSystem types, Scope scope, TypeFuture target, boolean explicitTarget, List paramTypes, CallSite call) {
        this(types, scope, target, explicitTarget, call.name().identifier(), paramTypes, CallFuture.getNodes(call), call.position());
    }

    public CallFuture(TypeSystem types, Scope scope, TypeFuture target, boolean explicitTarget, String name, List paramTypes, CallSite call) {
        this(types, scope, target, explicitTarget, name, paramTypes, CallFuture.getNodes(call), call.position());
    }

    public CallFuture(TypeSystem types, Scope scope, TypeFuture target, boolean explicitTarget, String name, List paramTypes, List paramNodes, Position position) {
        block2: {
            super(position);
            this.scope = scope;
            this.types = types;
            this.target = target;
            this.explicitTarget = explicitTarget;
            this.name = name;
            this.paramTypes = paramTypes;
            this.params = paramNodes;
            this.resolved_target = null;
            this.resolved_args = new ArrayList(paramTypes.size());
            int i = 0;
            int gensym0 = paramTypes.size();
            if (i < gensym0) {
                do {
                    this.resolved_args.add(this.paramTypes.get(i) instanceof BlockFuture ? types.getBlockType() : null);
                } while (++i < gensym0);
            }
            if (target == null) break block2;
            this.setupListeners();
        }
    }

    @Override
    public void dump(FuturePrinter out) {
        out.write("resolved: ");
        super.dump(out);
        out.write("target: ");
        out.printFuture(this.target);
        out.writeLine("name: " + this.name);
        for (Object p : this.paramTypes) {
            out.printFuture((TypeFuture)p);
        }
    }

    @Override
    public Map getComponents() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("target", this.target);
        map.put("name", this.name);
        map.put("params", new ArrayList(this.paramTypes));
        return map;
    }

    public static List getNodes(CallSite call) {
        LinkedList l;
        block2: {
            l = new LinkedList();
            if (call.parameters() != null) {
                for (Object p : call.parameters()) {
                    l.add(p);
                }
            }
            if (call.block() == null) break block2;
            l.add(call.block());
        }
        return l;
    }

    public Scope scope() {
        return this.scope;
    }

    public List parameterNodes() {
        return this.params;
    }

    public boolean explicitTarget() {
        return this.explicitTarget;
    }

    public void resolved_target_set(ResolvedType type) {
        this.resolved_target = type;
    }

    public ResolvedType resolved_target() {
        return this.resolved_target;
    }

    public String name() {
        return this.name;
    }

    public ArrayList resolved_parameters() {
        return this.resolved_args;
    }

    public List futures() {
        return this.paramTypes;
    }

    public String dt(TypeFuture type) {
        return type + " (" + ((type != null ? type.isResolved() : false) ? type.resolve().toString() : "unresolved") + ")";
    }

    public Object setupListeners() {
        CallFuture$3 callFuture$3 = new CallFuture$3();
        callFuture$3.call = this;
        Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINER)) {
            gensym0.finer("Adding target listener for " + this.dt(this.target));
        }
        this.target.onUpdate(new CallFuture$4(callFuture$3));
        int i = 0;
        int gensym1 = this.paramTypes.size();
        if (i < gensym1) {
            do {
                TypeFuture arg;
                if ((arg = (TypeFuture)this.paramTypes.get(i)) instanceof BlockFuture) continue;
                this.addParamListener(i, arg);
            } while (++i < gensym1);
        }
        return null;
    }

    @Override
    public ResolvedType resolve() {
        block3: {
            if (this.isResolved()) break block3;
            this.target.resolve();
            int i = 0;
            int gensym0 = this.paramTypes.size();
            if (i < gensym0) {
                do {
                    TypeFuture arg;
                    if ((arg = (TypeFuture)this.paramTypes.get(i)) instanceof BlockFuture) continue;
                    arg.resolve();
                } while (++i < gensym0);
            }
            if (this.method != null) {
                this.method.resolve();
            }
        }
        return super.resolve();
    }

    public void addParamListener(int i, TypeFuture arg) {
        CallFuture$1 callFuture$1 = new CallFuture$1();
        callFuture$1.index = i;
        Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.FINER)) {
            gensym0.finer("Adding param listener " + i + " for " + this.dt(arg));
        }
        callFuture$1.call = this;
        arg.onUpdate(new CallFuture$2(callFuture$1));
    }

    public void resolveArg(int i, TypeFuture arg, ResolvedType type) {
        if (type instanceof InlineCode) {
            Logger gensym0_javalogger = log.internal_logger();
            if (gensym0_javalogger.isLoggable(Level.FINEST)) {
                gensym0_javalogger.finest("Skipped resolving InlineCode arg");
            }
            return;
        }
        this.resolved_args.set(i, type);
        Logger gensym1 = log.internal_logger();
        if (gensym1.isLoggable(Level.FINER)) {
            gensym1.finer("resolved arg " + i + " " + this.dt(arg));
        }
        this.maybeUpdate();
    }

    public void resolveBlocks(MethodType type, ResolvedType error) {
        if (type != null ? type.returnType() instanceof InlineCode : false) {
            return;
        }
        int i = 0;
        int gensym0 = this.paramTypes.size();
        if (i < gensym0) {
            do {
                Object param;
                if (!((param = this.paramTypes.get(i)) instanceof BlockFuture)) continue;
                ResolvedType $or$1 = error;
                ResolvedType block_type = $or$1 != null ? $or$1 : (ResolvedType)type.parameterTypes().get(i);
                ((BlockFuture)param).resolved(block_type);
            } while (++i < gensym0);
        }
    }

    public ResolvedType getArgError() {
        for (ResolvedType arg : this.resolved_args) {
            if (!(arg != null ? arg.isError() : false)) continue;
            return arg;
        }
        return null;
    }

    public void maybeUpdate() {
        block1: {
            CallFuture$5 callFuture$5;
            block2: {
                Level gensym1_levellocal;
                callFuture$5 = new CallFuture$5();
                Logger gensym0_javalogger = log.internal_logger();
                if (gensym0_javalogger.isLoggable(gensym1_levellocal = Level.FINER)) {
                    gensym0_javalogger.log(gensym1_levellocal, "maybeUpdate(name=" + this.name() + ", target=" + this.resolved_target + ", args=" + this.resolved_args + ")");
                }
                if (this.resolved_target == null) break block1;
                if (!this.resolved_target.isError()) break block2;
                this.method = null;
                this.resolved(this.resolved_target);
                this.resolveBlocks(null, this.resolved_target);
                break block1;
            }
            callFuture$5.call = this;
            TypeFuture new_method = this.types.getMethodType(this);
            if (new_method == this.method) break block1;
            this.method = new_method;
            callFuture$5.resolved_target = this.resolved_target;
            callFuture$5.void_type = this.types.getVoidType().resolve();
            this.method.onUpdate(new CallFuture$6(callFuture$5));
        }
    }

    public TypeFuture currentMethodType() {
        return this.method;
    }

    @Override
    public String toString() {
        return "<" + this.getClass().getSimpleName() + ": name=" + this.name + " target=" + this.target + " resolved: " + this.resolved_target + " params=" + this.params + " paramTypes=" + this.paramTypes + " resolved: " + this.resolved_args + ">";
    }
}

