/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.HashMap;
import java.util.Map;
import mirah.lang.ast.Position;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.TypeFuture;

public class FuturePrinter {
    private boolean newline = true;
    private int level = 0;
    private Map cycles;
    private StringBuilder out = new StringBuilder();

    public FuturePrinter() {
        this.cycles = new HashMap(16);
    }

    public void printFuture(TypeFuture future) {
        this.maybeStartLine();
        ++this.level;
        if (future != null) {
            this.write(future.getClass().getSimpleName());
            this.write(" ");
            if (this.cycles.containsKey(future)) {
                this.writeLine(this.cycles.get(future).toString());
            } else {
                int i = this.cycles.size();
                this.cycles.put(future, new Integer(i));
                Position position = future instanceof BaseTypeFuture ? ((BaseTypeFuture)future).position() : null;
                String tail = position != null ? " " + position.source().name() + ":" + position.startLine() : "";
                this.writeLine(i + tail);
                future.dump(this);
            }
        } else {
            this.writeLine("null");
        }
        --this.level;
    }

    public void write(String text) {
        this.maybeStartLine();
        this.out.append(text);
    }

    public void writeLine(String text) {
        this.maybeStartLine();
        this.out.append(text);
        this.out.append("\n");
        this.newline = true;
    }

    public void maybeStartLine() {
        block2: {
            int i;
            if (!this.newline) break block2;
            for (i = 0; i < this.level - 1; ++i) {
                this.out.append("|   ");
            }
            if (i < this.level) {
                this.out.append("|-- ");
            }
            this.newline = false;
        }
    }

    public String toString() {
        return this.out.toString();
    }
}

