/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.Unquote;
import org.mirah.typer.DelegateFuture;
import org.mirah.typer.DerivedFuture;
import org.mirah.typer.InlineCode;
import org.mirah.typer.ProxyNode$1;
import org.mirah.typer.ProxyNode$2;
import org.mirah.typer.ProxyNode$3;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.util.Comparisons;

public class ProxyNode
extends NodeList
implements TypeName,
Identifier {
    private Typer typer;
    private Node original;
    private ArrayList nodes;
    private boolean expression;
    private int defaultChild;
    private DelegateFuture future;
    private Node selectedNode;
    private List futures;
    private Unquote unquote;

    public ProxyNode(Typer typer, Node node) {
        super(node.position());
        this.typer = typer;
        node.parent().replaceChild(node, this);
        node.setParent(this);
        this.original = node;
    }

    @Override
    public Object clone() {
        Node cloned = (Node)this.original.clone();
        this.fireWasCloned(cloned);
        return cloned;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Node get(int i) {
        if (i != 0) {
            throw new NoSuchElementException("No element " + i);
        }
        return this.selectedNode;
    }

    @Override
    public String identifier() {
        if (this.unquote != null) {
        } else {
            this.unquote = new Unquote();
        }
        return this.unquote.identifierNode(this.selectedNode).identifier();
    }

    @Override
    public TypeRef typeref() {
        for (Object n : this.nodes) {
            if (!(n instanceof TypeName)) continue;
            return ((TypeName)n).typeref();
        }
        return null;
    }

    @Override
    public void add(Node node) {
        throw new UnsupportedOperationException("ProxyNode doesn't support add");
    }

    @Override
    public void insert(int i, Node value) {
        throw new UnsupportedOperationException("ProxyNode doesn't support insert");
    }

    @Override
    public Node set(int i, Node value) {
        throw new UnsupportedOperationException("ProxyNode doesn't support set");
    }

    @Override
    public Node remove(int i) {
        throw new UnsupportedOperationException("ProxyNode doesn't support remove");
    }

    @Override
    public void removeChild(Node node) {
        throw new UnsupportedOperationException("ProxyNode doesn't support removeChild");
    }

    public void setChildren(List nodes, int defaultChild) {
        if (defaultChild < 0) {
            defaultChild += nodes.size();
        }
        this.defaultChild = defaultChild;
        int nodeCount = nodes.size();
        ArrayList<Node> newNodes = new ArrayList<Node>(nodeCount);
        this.futures = Collections.emptyList();
        this.future = null;
        int i = 0;
        int gensym0 = nodes.size();
        if (i < gensym0) {
            do {
                Node node = this.childAdded((Node)nodes.get(i));
                newNodes.add(node);
            } while (++i < gensym0);
        }
        this.nodes = newNodes;
        this.selectedNode = (Node)this.nodes.get(this.defaultChild);
    }

    public TypeFuture inferChildren(boolean expression) {
        ProxyNode$1 proxyNode$1 = new ProxyNode$1();
        if (this.future == null) {
            this.expression = expression;
            this.future = new DelegateFuture();
            ArrayList gensym0 = this.nodes;
            ArrayList<TypeFuture> gensym1 = new ArrayList<TypeFuture>(gensym0.size());
            for (Node n : gensym0) {
                gensym1.add(this.typer.infer(n, expression));
            }
            this.futures = gensym1;
            this.selectedNode = (Node)this.nodes.get(this.defaultChild);
            this.future.type_set(new DerivedFuture((TypeFuture)this.futures.get(this.defaultChild), new ProxyNode$2(proxyNode$1)));
            proxyNode$1.proxy = this;
            ProxyNode$3 listener = new ProxyNode$3(proxyNode$1);
            for (TypeFuture f : this.futures) {
                f.onUpdate(listener);
            }
        }
        return this.future;
    }

    public void updateSelection() {
        int i = 0;
        int gensym0 = this.futures.size();
        if (i < gensym0) {
            do {
                ResolvedType resolved;
                TypeFuture f;
                if (!(f = (TypeFuture)this.futures.get(i)).isResolved() || (resolved = f.resolve()).isError()) continue;
                this.selectNode(i, (Node)this.nodes.get(i), f, resolved);
                return;
            } while (++i < gensym0);
        }
        this.selectNode(-1, (Node)this.nodes.get(this.defaultChild), (TypeFuture)this.futures.get(this.defaultChild), null);
    }

    public void selectNode(int index, Node node, TypeFuture future, ResolvedType resolved) {
        if (resolved instanceof InlineCode) {
            this.selectedNode = this.childAdded(this.typer.expandMacro(node, resolved));
            this.future.type_set(this.typer.infer(this.selectedNode, this.expression));
        } else {
            this.selectedNode = node;
            this.future.type_set(future);
        }
    }

    @Override
    public Node replaceChild(Node child, Node newChild) {
        Node clone;
        block2: {
            if (Comparisons.areSame(child, newChild)) {
                return newChild;
            }
            clone = this.childAdded(newChild);
            int i = this.nodes.indexOf(child);
            if (i != -1) {
                this.nodes.set(i, clone);
            }
            child.setParent(null);
            if (!Comparisons.areSame(child, this.selectedNode)) break block2;
            this.selectedNode = clone;
        }
        return clone;
    }

    @Override
    public String toString() {
        return "<org.mirah.typer.ProxyNode: selected:" + this.selectedNode + ">";
    }
}

