/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer.closures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FormalArgument;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Hash;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.LocalAssignment;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Position;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeRefImpl;
import org.mirah.jvm.mirrors.MirrorScope;
import org.mirah.jvm.mirrors.NullType;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.BetterClosureBuilder;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.closures.BindingAdjuster$1;
import org.mirah.typer.closures.BindingAdjuster$2;
import org.mirah.typer.closures.BindingAdjuster$3;

public class BindingAdjuster
extends NodeScanner {
    private TypeFuture binding_type;
    private Map bindingLocalNamesToTypes;
    private ClosureDefinition binding_klass_node;
    private static org.mirah.util.Logger log = org.mirah.util.Logger.getLogger(BindingAdjuster.class.getName());
    private Stack blocks;
    private Map blockToBindings;
    private MirrorScope parent_scope;
    private List captured;
    private BetterClosureBuilder builder;
    private String bindingName;

    public BindingAdjuster(BetterClosureBuilder builder, String bindingName, MirrorScope parent_scope, Map blockToBindings, Map bindingLocalNamesToTypes) {
        this.builder = builder;
        this.blockToBindings = blockToBindings;
        this.bindingLocalNamesToTypes = bindingLocalNamesToTypes;
        this.blocks = new Stack();
        this.parent_scope = parent_scope;
        this.bindingName = bindingName;
    }

    public void adjust(Node node, Block block) {
        block31: {
            Logger gensym7;
            Logger gensym1;
            BindingAdjuster$1 bindingAdjuster$1 = new BindingAdjuster$1();
            this.captured = this.parent_scope.capturedLocals();
            Logger gensym0 = log.internal_logger();
            if (gensym0.isLoggable(Level.FINE)) {
                gensym0.fine("adjusting " + node + "\n" + this.builder.typer().sourceContent(node) + "\nfor block\n" + this.builder.typer().sourceContent(block));
            }
            if ((gensym1 = log.internal_logger()).isLoggable(Level.FINE)) {
                gensym1.fine("captures for " + this.bindingName + ": " + this.captured + " parent scope: " + this.parent_scope);
            }
            if (this.captured.isEmpty()) {
                Logger gensym2 = log.internal_logger();
                if (gensym2.isLoggable(Level.FINE)) {
                    gensym2.fine("no need for binding adjustment here. Nothing captured");
                }
                return;
            }
            if (this.parent_scope.declared_binding_type() != null) {
                Logger gensym3 = log.internal_logger();
                if (gensym3.isLoggable(Level.FINE)) {
                    gensym3.fine("no need for binding adjustment here. already bound to " + this.parent_scope.declared_binding_type());
                }
                return;
            }
            String name = this.builder.temp_name_from_outer_scope(node, "ZBinding");
            Logger gensym4 = log.internal_logger();
            if (gensym4.isLoggable(Level.FINE)) {
                gensym4.fine("building binding " + name + " with captures " + this.captured);
            }
            ClosureDefinition binding_klass = this.builder.build_class(node.position(), null, name);
            List gensym17 = this.captured;
            ArrayList<HashEntry> gensym18 = new ArrayList<HashEntry>(gensym17.size());
            for (String bindingAdjuster$1.cap : gensym17) {
                ResolvedType type = this.parent_scope.getLocalType(bindingAdjuster$1.cap, node.position()).resolve();
                if (type instanceof NullType) {
                    throw new Exception("We have no type for captured variable \"" + bindingAdjuster$1.cap + "\".");
                }
                boolean is_array = JVMTypeUtils.isArray((JVMType)type);
                String variable_type_name = type.name();
                if (is_array) {
                    variable_type_name = variable_type_name.substring(0, variable_type_name.length() - 2);
                }
                TypeRefImpl variable_type_ref = new TypeRefImpl(variable_type_name, is_array, false, node.position());
                gensym18.add(new HashEntry(new SimpleString(bindingAdjuster$1.cap), variable_type_ref));
            }
            ArrayList<HashEntry> entries = gensym18;
            SimpleString simpleString = new SimpleString("attr_accessor");
            ArrayList<Hash> arrayList = new ArrayList<Hash>(1);
            arrayList.add(new Hash(node.position(), entries));
            FunctionalCall attr_def = new FunctionalCall(simpleString, arrayList, null);
            binding_klass.body().insert(0, attr_def);
            Call binding_new_call = new Call(node.position(), new Constant(new SimpleString(name)), new SimpleString("new"), new ArrayList(0), null);
            LocalAssignment assign_binding_dot_new = new LocalAssignment(node.position(), new SimpleString(this.bindingName), binding_new_call);
            Logger gensym5 = log.internal_logger();
            if (gensym5.isLoggable(Level.FINE)) {
                gensym5.fine("inserted binding assign / binding class ");
            }
            this.builder.insert_into_body((NodeList)node, assign_binding_dot_new);
            this.builder.insert_into_body((NodeList)node, binding_klass);
            ResolvedType binding_type = this.builder.infer(binding_klass).resolve();
            if (this.parent_scope.declared_binding_type() != null) {
                throw new Exception("parent_scope had declared_binding_type already " + this.parent_scope);
            }
            this.parent_scope.declared_binding_type_set(binding_type);
            this.bindingLocalNamesToTypes.put(this.bindingName, binding_type);
            this.builder.parent_scope_to_binding_name().put(this.parent_scope, this.bindingName);
            this.binding_type = this.builder.infer(binding_klass);
            this.binding_klass_node = binding_klass;
            this.builder.infer(assign_binding_dot_new);
            Logger gensym6 = log.internal_logger();
            if (gensym6.isLoggable(Level.FINE)) {
                gensym6.fine("binding assignment inference done");
            }
            if ((gensym7 = log.internal_logger()).isLoggable(Level.FINE)) {
                gensym7.fine("replacing references to captures");
            }
            Node mdef = node.findAncestor(new BindingAdjuster$2(bindingAdjuster$1));
            Node block_parent = node.findAncestor(new BindingAdjuster$3(bindingAdjuster$1));
            Arguments arguments = mdef != null ? ((MethodDefinition)mdef).arguments() : (block_parent != null ? ((Block)block_parent).arguments() : null);
            node.accept(this, new Integer(1));
            Logger gensym8 = log.internal_logger();
            if (gensym8.isLoggable(Level.FINE)) {
                gensym8.fine("finished phase one of capture replacement");
            }
            ArrayList<String> arg_names = new ArrayList<String>(0);
            if (arguments != null) {
                if (arguments.required() != null) {
                    for (FormalArgument a : arguments.required()) {
                        arg_names.add(a.name().identifier());
                    }
                }
                if (arguments.optional() != null) {
                    for (FormalArgument a : arguments.optional()) {
                        arg_names.add(a.name().identifier());
                    }
                }
                if (arguments.rest() != null) {
                    arg_names.add(arguments.rest().name().identifier());
                }
                if (arguments.required2() != null) {
                    for (FormalArgument a : arguments.required2()) {
                        arg_names.add(a.name().identifier());
                    }
                }
                if (arguments.block() != null) {
                    arg_names.add(arguments.block().name().identifier());
                }
            } else {
                Node $or$1 = mdef;
                if (($or$1 != null ? $or$1 : block_parent) != null) {
                    Logger gensym12 = log.internal_logger();
                    if (gensym12.isLoggable(Level.FINE)) {
                        gensym12.fine("parent had no arguments: parent " + mdef + " " + block_parent);
                    }
                } else {
                    Logger gensym13 = log.internal_logger();
                    if (gensym13.isLoggable(Level.FINE)) {
                        gensym13.fine("had no parent");
                    }
                }
            }
            Logger gensym14 = log.internal_logger();
            if (gensym14.isLoggable(Level.FINE)) {
                gensym14.fine("adding assignments from args to captures");
            }
            for (String arg : arg_names) {
                if (!this.captured.contains(arg)) continue;
                NodeImpl nodeImpl = this.blockAccessNode(node.position());
                SimpleString simpleString2 = new SimpleString(arg + "_set");
                ArrayList<LocalAccess> arrayList2 = new ArrayList<LocalAccess>(1);
                arrayList2.add(new LocalAccess(node.position(), new SimpleString(arg)));
                Call addition = new Call(nodeImpl, simpleString2, arrayList2, null);
                ((NodeList)node).insert(2, addition);
                this.builder.infer(addition);
            }
            Logger gensym16 = log.internal_logger();
            if (!gensym16.isLoggable(Level.FINE)) break block31;
            gensym16.fine("done replacing references");
        }
    }

    @Override
    public Object visitClassDefinition(ClassDefinition node, Object blah) {
        return null;
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object blah) {
        return this.binding_klass_node != node;
    }

    @Override
    public Object exitClosureDefinition(ClosureDefinition node, Object blah) {
        Object v0 = null;
        return null;
    }

    @Override
    public boolean enterBlock(Block node, Object blah) {
        this.blocks.push(node);
        Map $ptemp$2 = this.blockToBindings;
        Object $ptemp$3 = this.builder.blockCloneMapNewOld().get(this.blocks.peek());
        Object $or$4 = $ptemp$2.get($ptemp$3);
        if ($or$4 == null) {
            $ptemp$2.put($ptemp$3, new HashSet());
        }
        return true;
    }

    @Override
    public Object exitBlock(Block node, Object blah) {
        return this.blocks.pop();
    }

    public Object maybeNoteBlockBinding() {
        for (Block block : this.blocks) {
            ((Collection)this.blockToBindings.get(this.builder.blockCloneMapNewOld().get(block))).add(this.bindingName);
        }
        return null;
    }

    public NodeImpl blockAccessNode(Position position) {
        SimpleString name_node = new SimpleString(this.bindingName);
        return this.blocks.isEmpty() ? new LocalAccess(position, name_node) : new FieldAccess(position, name_node);
    }

    @Override
    public Object exitLocalAssignment(LocalAssignment local, Object blah) {
        Logger gensym1_javalogger;
        String local_name = local.name().identifier();
        if (!this.captured.contains(local_name)) {
            return null;
        }
        Logger gensym0_javalogger = log.internal_logger();
        if (gensym0_javalogger.isLoggable(Level.FINEST)) {
            gensym0_javalogger.finest("enterLocalAssignment: replacing " + local.name().identifier() + " with " + this.bindingName + "." + local.name().identifier() + "=");
        }
        if ((gensym1_javalogger = log.internal_logger()).isLoggable(Level.FINEST)) {
            gensym1_javalogger.finest("  Type: " + this.builder.typer().getInferredType(local));
        }
        this.maybeNoteBlockBinding();
        Node new_value = local.value();
        new_value.setParent(null);
        NodeImpl nodeImpl = this.blockAccessNode(local.position());
        SimpleString simpleString = new SimpleString(local.name().identifier() + "_set");
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        arrayList.add(new_value);
        Call replacement = new Call(nodeImpl, simpleString, arrayList, null);
        this.replaceSelf(local, replacement);
        local.value().setParent(replacement);
        this.builder.typer().learnType(replacement.target(), this.binding_type);
        this.builder.typer().infer(new_value);
        return this.builder.typer().infer(replacement);
    }

    @Override
    public Object exitLocalAccess(LocalAccess local, Object blah) {
        Call replacement;
        block5: {
            Logger gensym4;
            Logger gensym3;
            Logger gensym1_javalogger;
            String local_name = local.name().identifier();
            if (!this.captured.contains(local_name)) {
                return null;
            }
            Logger gensym0_javalogger = log.internal_logger();
            if (gensym0_javalogger.isLoggable(Level.FINEST)) {
                gensym0_javalogger.finest("enterLocalAccess: replacing " + local.name().identifier() + " with " + this.bindingName + "." + local.name().identifier() + "=");
            }
            if ((gensym1_javalogger = log.internal_logger()).isLoggable(Level.FINEST)) {
                gensym1_javalogger.finest("  Type: " + this.builder.typer().getInferredType(local));
            }
            this.maybeNoteBlockBinding();
            replacement = new Call(this.blockAccessNode(local.position()), new SimpleString(local.position(), local.name().identifier()), new ArrayList(0), null);
            this.replaceSelf(local, replacement);
            this.builder.typer().learnType(replacement.target(), this.binding_type);
            Logger gensym2 = log.internal_logger();
            if (gensym2.isLoggable(Level.FINE)) {
                gensym2.fine("does replacement have parent?: " + replacement.parent());
            }
            if (replacement.parent() instanceof NodeList && (gensym3 = log.internal_logger()).isLoggable(Level.FINE)) {
                gensym3.fine("does replacement parent 0th child: " + ((NodeList)replacement.parent()).get(0));
            }
            if (replacement.parent() == null || !(gensym4 = log.internal_logger()).isLoggable(Level.FINE)) break block5;
            gensym4.fine("does replacement have parent?: " + replacement.parent().parent());
        }
        return this.builder.typer().infer(replacement);
    }

    public Node replaceSelf(Node me, Node replacement) {
        return me.parent().replaceChild(me, replacement);
    }
}

