/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer.simple;

import java.io.PrintStream;
import java.io.PrintWriter;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.Call;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.LocalAssignment;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.OptionalArgumentList;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.RequiredArgumentList;
import mirah.lang.ast.Self;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StringConcat;
import mirah.lang.ast.StringEval;
import mirah.lang.ast.StringPieceList;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.Unquote;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.PrintStreamAdapter;

public class TypePrinter2
extends NodeScanner {
    private Object[] args;
    private Typer typer;
    private int indent = 0;
    private int lineLength;
    private PrintWriter out;

    public TypePrinter2(Typer typer) {
        this(typer, System.out);
    }

    public TypePrinter2(Typer typer, PrintWriter writer) {
        this.typer = typer;
        this.args = new Object[1];
        this.args[0] = "";
        this.out = writer;
        this.lineLength = 0;
    }

    public TypePrinter2(Typer typer, PrintStream writer) {
        this(typer, new PrintWriter(new PrintStreamAdapter(writer)));
    }

    public void incIndent() {
        this.indent += 2;
    }

    public void decIndent() {
        block0: {
            this.indent -= 2;
            if (this.indent >= 0) break block0;
            this.indent = 0;
        }
    }

    public void printIndent() {
        block0: {
            this.lineLength += this.indent;
            if (this.indent <= 0) break block0;
            this.out.printf("%" + this.indent + "s", this.args);
        }
    }

    @Override
    public Object exitClassDefinition(ClassDefinition node, Object arg) {
        this.out.print("\n");
        this.decIndent();
        this.printIndent();
        PrintWriter printWriter = this.out;
        printWriter.print("end\n");
        return printWriter;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        this.printClass(node);
        return false;
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object arg) {
        this.printClass(node);
        return false;
    }

    @Override
    public boolean enterConstructorDefinition(ConstructorDefinition node, Object arg) {
        return this.enterMethodDefinition(node, arg);
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        TypeFuture type = this.typer.getInferredType(node);
        if (node.annotations_size() > 0) {
            this.printIndent();
        }
        if (node.annotations_size() > 0) {
            this.out.print("$TODOAnnotations\n");
        }
        this.printIndent();
        this.out.print("def ");
        this.out.print("(self.)");
        this.out.print(node.name().identifier());
        node.arguments().accept(this, arg);
        if (type != null) {
            this.out.print(" # " + type.resolve());
        }
        this.out.println();
        this.incIndent();
        node.body().accept(this, arg);
        this.decIndent();
        this.out.println();
        this.printIndent();
        this.out.print("end\n");
        return false;
    }

    @Override
    public boolean enterRequiredArgumentList(RequiredArgumentList node, Object arg) {
        return true;
    }

    @Override
    public boolean enterRequiredArgument(RequiredArgument node, Object arg) {
        block1: {
            this.printIndent();
            this.out.print(" " + node.name().identifier());
            if (node.type() != null) {
                this.out.print(": " + node.type().typeref());
            }
            this.out.print(", ");
            TypeFuture type = this.typer.getInferredType(node);
            if (type == null) break block1;
            this.out.print(" # " + type.resolve() + "\n");
        }
        return false;
    }

    @Override
    public boolean enterSelf(Self node, Object arg) {
        this.out.print("self");
        return false;
    }

    @Override
    public boolean enterOptionalArgumentList(OptionalArgumentList node, Object arg) {
        block0: {
            if (node == null) break block0;
            this.out.print("<TODO optional args>");
        }
        return false;
    }

    @Override
    public boolean enterFixnum(Fixnum node, Object arg) {
        this.out.print(node.value());
        return false;
    }

    @Override
    public boolean enterCall(Call node, Object arg) {
        block1: {
            node.target().accept(this, arg);
            this.out.print(".");
            this.out.print(node.name().identifier());
            boolean bl = node.parameters() != null ? node.parameters_size() > 0 : false;
            if (bl) {
                this.out.print("(\n");
                this.printIndent();
                node.parameters().accept(this, arg);
                this.out.print("\n");
                this.printIndent();
                this.out.print(")");
            }
            if (node.block() == null) break block1;
            this.out.print(" ");
            node.block().accept(this, arg);
        }
        return false;
    }

    @Override
    public boolean enterArguments(Arguments arguments, Object arg) {
        boolean bl;
        int count = 0;
        if (arguments.required() != null) {
            count += arguments.required().size();
        }
        if (arguments.optional() != null) {
            count += arguments.optional().size();
        }
        if (arguments.required2() != null) {
            count += arguments.required2().size();
        }
        if (arguments.rest() != null) {
            ++count;
        }
        if (count > 0) {
            this.out.print("(\n");
            this.incIndent();
            bl = true;
        } else {
            this.out.print("(");
            bl = false;
        }
        return bl;
    }

    @Override
    public Object exitArguments(Arguments node, Object arg) {
        this.printIndent();
        this.out.print(")");
        this.incIndent();
        return null;
    }

    @Override
    public boolean enterFieldAccess(FieldAccess node, Object arg) {
        this.out.print("@" + node.name().identifier());
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print(" # " + type.resolve());
        }
        this.out.println();
        return false;
    }

    @Override
    public boolean enterFieldAssign(FieldAssign node, Object arg) {
        this.out.print("@" + node.name().identifier() + " =");
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print(" # " + type.resolve());
        }
        this.out.println();
        node.value().accept(this, arg);
        return false;
    }

    @Override
    public boolean enterStringConcat(StringConcat node, Object arg) {
        this.out.print("\"");
        node.strings().accept(this, arg);
        this.out.print("\"");
        return false;
    }

    @Override
    public boolean enterStringEval(StringEval node, Object arg) {
        this.out.print("#{");
        node.value().accept(this, arg);
        this.out.print("}");
        return false;
    }

    @Override
    public boolean enterStringPieceList(StringPieceList node, Object arg) {
        return true;
    }

    @Override
    public Object exitStringPieceList(StringPieceList node, Object arg) {
        return null;
    }

    @Override
    public boolean enterSimpleString(SimpleString node, Object arg) {
        this.out.print(node.identifier());
        return false;
    }

    @Override
    public boolean enterConstant(Constant node, Object arg) {
        this.out.print(node.name().identifier());
        return false;
    }

    @Override
    public boolean enterLocalAccess(LocalAccess node, Object arg) {
        this.out.print(node.name().identifier());
        return false;
    }

    @Override
    public boolean enterLocalAssignment(LocalAssignment node, Object arg) {
        this.out.print(node.name().identifier() + " = ");
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print(" # " + type.resolve());
        }
        this.out.println();
        node.value().accept(this, arg);
        return false;
    }

    public Object printClass(ClassDefinition node) {
        this.printIndent();
        this.out.print("$TODO Annotations\n");
        this.printIndent();
        this.out.print("class " + node.name().identifier());
        if (node.superclass() != null) {
            this.out.print("< " + node.superclass().typeref().name());
        }
        this.out.print("\n");
        this.incIndent();
        if (node.interfaces().size() > 0) {
            for (TypeName iface : node.interfaces()) {
                this.printIndent();
                this.out.print("implements " + iface.typeref().name() + "\n");
            }
        }
        return this.scan(node.body());
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.printIndent();
        this.out.print(node);
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print(" # " + type.resolve());
        }
        this.out.println();
        this.incIndent();
        return true;
    }

    @Override
    public boolean enterBoolean(Boolean node, Object arg) {
        this.out.print(node.value());
        return false;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        this.decIndent();
        return null;
    }

    @Override
    public boolean enterUnquote(Unquote node, Object arg) {
        super.enterUnquote(node, arg);
        if (node.object() != null) {
            if (node.object() instanceof Node) {
                ((Node)node.object()).accept(this, arg);
            } else {
                this.printIndent();
                this.out.print(node.object());
                this.out.println();
            }
        }
        return node.object() == null;
    }

    @Override
    public Object exitUnquote(Unquote node, Object arg) {
        Object v0 = null;
        return null;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }

    @Override
    public Object exitNodeList(NodeList node, Object arg) {
        return null;
    }
}

