/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.util;

import java.util.ArrayDeque;
import java.util.List;
import java.util.logging.Level;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeScanner;
import org.mirah.util.Logger;

public class AstChecker
extends NodeScanner {
    private ArrayDeque stack;
    private static Logger log = Logger.getLogger(AstChecker.class.getName());

    public ArrayDeque stack() {
        return this.stack;
    }

    public void stack_set(ArrayDeque value) {
        this.stack = value;
    }

    public static boolean enabled() {
        return false;
    }

    public AstChecker() {
        this.stack_set(new ArrayDeque());
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        if (!this.stack().isEmpty()) {
            Node parent = (Node)this.stack().getLast();
            if (node.parent() != parent) {
                this.child_parent_mismatch(parent, node, node.parent());
            }
        }
        this.stack().addLast(node);
        return true;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        Object last = this.stack().removeLast();
        if (last != node) {
            throw new Exception("NodeScanner has a bug.");
        }
        boolean bl = false;
        return null;
    }

    public java.util.logging.Logger child_parent_mismatch(Node node, Node nodes_child, Node nodes_childs_parent) {
        java.util.logging.Logger logger;
        java.util.logging.Logger gensym0 = log.internal_logger();
        if (gensym0.isLoggable(Level.WARNING)) {
            java.util.logging.Logger logger2 = gensym0;
            logger = logger2;
            logger2.warning("Child " + nodes_child + " of " + node + " has parent " + nodes_childs_parent);
        } else {
            logger = null;
        }
        return logger;
    }

    public static void maybe_check(Node node) {
        block0: {
            if (!AstChecker.enabled()) break block0;
            node.accept(new AstChecker(), null);
        }
    }

    public static void maybe_check(List list) {
        if (AstChecker.enabled()) {
            for (Node node : list) {
                AstChecker.maybe_check(node);
            }
        }
    }
}

