/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd;

import java.util.HashMap;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.enums.SdTypeMode;

public class SdType {
    public static final String BYTE = "byte";
    public static final String BYTE_ARRAY = "byte_array";
    public static final String BOOLEAN_BASIC = "boolean_basic";
    public static final String BOOLEAN = "Boolean";
    public static final String CHAR_BASIC = "char_basic";
    public static final String CHARACTER = "java_Character";
    public static final String STRING = "String";
    public static final String SHORT_BASIC = "short_basic";
    public static final String SHORT = "Short";
    public static final String INT_BASIC = "int_basic";
    public static final String INTEGER = "Integer";
    public static final String LONG_BASIC = "long_basic";
    public static final String LONG = "Long";
    public static final String FLOAT_BASIC = "float_basic";
    public static final String FLOAT = "Float";
    public static final String DOUBLE_BASIC = "double_basic";
    public static final String DOUBLE = "Double";
    public static final String NUMBER = "Number";
    public static final String DECIMAL = "Decimal";
    public static final String ZONED_DATE_TIME = "ZonedDateTime";
    public static final String GREGORIAN_CALENDAR = "java.util.GregorianCalendar";
    public static final String DATETIME = "DateTime";
    public static final String DATE = "Date";
    public static final String TIME = "Time";
    public static final String TIMESTAMP = "Timestamp";
    public static final String DATE_UTIL = "java.util.Date";
    public static final String CALENDAR = "java.util.Calendar";
    public static final String DATE_SQL = "java.sql.Date";
    public static final String TIME_SQL = "java.sql.Time";
    public static final String TIMESTAMP_SQL = "java.sql.Timestamp";
    public static final String NCHAR = "nchar";
    public static final String NVARCHAR = "nvarchar";
    public static final String VARCHAR2 = "varchar2";
    public static final String MONEY = "money";
    public static final String TEXT = "text";
    public static final String LONGTEXT = "longtext";
    public static final String JSON = "json";
    public static final String JSONB = "jsonb";
    public static final String CHAR = "char";
    public static final String VARCHAR = "varchar";
    public static final String REAL = "real";
    public static final String NUMERIC = "Numeric";
    public static final Map<String, String> CUSTOM_SQL_MAPS;
    public static final Map<String, String> CUSTOM_JAVA_MAPS;
    public static final Map<String, String> COMMON_SQL_MAPS;
    public static final Map<String, String> COMMON_JAVA_MAPS;
    public static final Map<String, String> JAVA_MAPS;
    public static final Map<String, String> MYSQL_MAPS;
    public static final Map<String, String> POSTGRE_SQL_MAPS;
    public static final Map<String, String> DB2_MAPS;
    public static final Map<String, String> ORACLE_MAPS;
    public static final Map<String, String> SQL_SERVER_MAPS;
    public static final Map<String, String> SQLITE_MAPS;

    public static void put(String key, String sqlType, String javaType) {
        CUSTOM_SQL_MAPS.put(key, sqlType);
        CUSTOM_JAVA_MAPS.put(key, javaType);
    }

    public static Map<String, String> getDictionary(SdTypeMode mode) {
        SdUtil.requireNonNull((Object)mode, "The mode connot be null");
        HashMap<String, String> result = new HashMap<String, String>();
        if (mode == SdTypeMode.COMMON) {
            result.putAll(COMMON_JAVA_MAPS);
            result.putAll(COMMON_SQL_MAPS);
            result.putAll(CUSTOM_JAVA_MAPS);
            result.putAll(CUSTOM_SQL_MAPS);
        } else if (mode == SdTypeMode.CUSTOM) {
            result.putAll(CUSTOM_SQL_MAPS);
            result.putAll(CUSTOM_JAVA_MAPS);
        } else if (mode == SdTypeMode.JAVA) {
            result.putAll(COMMON_JAVA_MAPS);
            result.putAll(JAVA_MAPS);
            result.putAll(CUSTOM_JAVA_MAPS);
        } else {
            result.putAll(COMMON_SQL_MAPS);
            switch (mode) {
                case MYSQL: {
                    result.putAll(MYSQL_MAPS);
                    break;
                }
                case POSTGRE_SQL: {
                    result.putAll(POSTGRE_SQL_MAPS);
                    break;
                }
                case DB2: {
                    result.putAll(DB2_MAPS);
                    break;
                }
                case ORACLE: {
                    result.putAll(ORACLE_MAPS);
                    break;
                }
                case SQL_SERVER: {
                    result.putAll(SQL_SERVER_MAPS);
                    break;
                }
                case SQLITE: {
                    result.putAll(SQLITE_MAPS);
                    break;
                }
            }
            result.putAll(CUSTOM_SQL_MAPS);
        }
        return result;
    }

    private static void initCommonSQLMaps() {
        COMMON_SQL_MAPS.put(CHAR, "CHAR");
        COMMON_SQL_MAPS.put(VARCHAR, "VARCHAR");
        COMMON_SQL_MAPS.put(REAL, "REAL");
        COMMON_SQL_MAPS.put(NUMERIC, "NUMERIC");
    }

    private static void initMySQLMaps() {
        MYSQL_MAPS.put(BYTE, "tinyint");
        MYSQL_MAPS.put(BYTE_ARRAY, "blob");
        MYSQL_MAPS.put(BOOLEAN, "boolean");
        MYSQL_MAPS.put(BOOLEAN_BASIC, "boolean");
        MYSQL_MAPS.put(CHAR_BASIC, CHAR);
        MYSQL_MAPS.put(CHARACTER, CHAR);
        MYSQL_MAPS.put(STRING, VARCHAR);
        MYSQL_MAPS.put(SHORT, "smallint");
        MYSQL_MAPS.put(SHORT_BASIC, "smallint");
        MYSQL_MAPS.put(INT_BASIC, "int");
        MYSQL_MAPS.put(INTEGER, "int");
        MYSQL_MAPS.put(LONG, "bigint");
        MYSQL_MAPS.put(LONG_BASIC, "BIGINT");
        MYSQL_MAPS.put(FLOAT, "float");
        MYSQL_MAPS.put(FLOAT_BASIC, "float");
        MYSQL_MAPS.put(DOUBLE, "double");
        MYSQL_MAPS.put(DOUBLE_BASIC, "double");
        MYSQL_MAPS.put(NUMBER, "numeric");
        MYSQL_MAPS.put(MONEY, "decimal");
        MYSQL_MAPS.put(DECIMAL, "decimal");
        MYSQL_MAPS.put(NCHAR, CHAR);
        MYSQL_MAPS.put(NVARCHAR, VARCHAR);
        MYSQL_MAPS.put(VARCHAR2, VARCHAR);
        MYSQL_MAPS.put(TEXT, TEXT);
        MYSQL_MAPS.put(LONGTEXT, LONGTEXT);
        MYSQL_MAPS.put(JSON, JSON);
        MYSQL_MAPS.put(JSONB, JSON);
        MYSQL_MAPS.put(ZONED_DATE_TIME, "timestamp");
        MYSQL_MAPS.put(GREGORIAN_CALENDAR, "timestamp");
        MYSQL_MAPS.put(DATETIME, "datetime");
        MYSQL_MAPS.put(DATE, "date");
        MYSQL_MAPS.put(CALENDAR, "date");
        MYSQL_MAPS.put(DATE_SQL, "date");
        MYSQL_MAPS.put(DATE_UTIL, "date");
        MYSQL_MAPS.put(TIME, "time");
        MYSQL_MAPS.put(TIME_SQL, "time");
        MYSQL_MAPS.put(TIMESTAMP, "timestamp");
        MYSQL_MAPS.put(TIMESTAMP_SQL, "timestamp");
    }

    private static void initPostgreSQLMaps() {
        POSTGRE_SQL_MAPS.put(BYTE, "smallint");
        POSTGRE_SQL_MAPS.put(BYTE_ARRAY, "bytea");
        POSTGRE_SQL_MAPS.put(BOOLEAN, "boolean");
        POSTGRE_SQL_MAPS.put(BOOLEAN_BASIC, "boolean");
        POSTGRE_SQL_MAPS.put(CHAR_BASIC, CHAR);
        POSTGRE_SQL_MAPS.put(CHARACTER, CHAR);
        POSTGRE_SQL_MAPS.put(STRING, VARCHAR);
        POSTGRE_SQL_MAPS.put(SHORT, "smallint");
        POSTGRE_SQL_MAPS.put(SHORT_BASIC, "smallint");
        POSTGRE_SQL_MAPS.put(INT_BASIC, "integer");
        POSTGRE_SQL_MAPS.put(INTEGER, "integer");
        POSTGRE_SQL_MAPS.put(LONG, "bigint");
        POSTGRE_SQL_MAPS.put(LONG_BASIC, "bigint");
        POSTGRE_SQL_MAPS.put(FLOAT, REAL);
        POSTGRE_SQL_MAPS.put(FLOAT_BASIC, REAL);
        POSTGRE_SQL_MAPS.put(DOUBLE, "double precision");
        POSTGRE_SQL_MAPS.put(DOUBLE_BASIC, "double precision");
        POSTGRE_SQL_MAPS.put(NUMBER, "numeric");
        POSTGRE_SQL_MAPS.put(MONEY, MONEY);
        POSTGRE_SQL_MAPS.put(DECIMAL, "decimal ");
        POSTGRE_SQL_MAPS.put(NCHAR, CHAR);
        POSTGRE_SQL_MAPS.put(NVARCHAR, VARCHAR);
        POSTGRE_SQL_MAPS.put(VARCHAR2, VARCHAR);
        POSTGRE_SQL_MAPS.put(TEXT, TEXT);
        POSTGRE_SQL_MAPS.put(LONGTEXT, TEXT);
        POSTGRE_SQL_MAPS.put(JSON, JSON);
        POSTGRE_SQL_MAPS.put(JSONB, JSONB);
        POSTGRE_SQL_MAPS.put(ZONED_DATE_TIME, "timestamp with time zone");
        POSTGRE_SQL_MAPS.put(GREGORIAN_CALENDAR, "timestamp with time zone");
        POSTGRE_SQL_MAPS.put(DATETIME, "timestamp");
        POSTGRE_SQL_MAPS.put(DATE, "date");
        POSTGRE_SQL_MAPS.put(CALENDAR, "date");
        POSTGRE_SQL_MAPS.put(DATE_SQL, "date");
        POSTGRE_SQL_MAPS.put(DATE_UTIL, "date");
        POSTGRE_SQL_MAPS.put(TIME, "time");
        POSTGRE_SQL_MAPS.put(TIME_SQL, "time");
        POSTGRE_SQL_MAPS.put(TIMESTAMP, "timestamp");
        POSTGRE_SQL_MAPS.put(TIMESTAMP_SQL, "timestamp");
    }

    private static void initDB2Maps() {
        DB2_MAPS.put(BYTE, "SMALLINT");
        DB2_MAPS.put(BYTE_ARRAY, "BLOB");
        DB2_MAPS.put(BOOLEAN, "CHAR");
        DB2_MAPS.put(BOOLEAN_BASIC, "CHAR");
        DB2_MAPS.put(CHAR_BASIC, "CHAR");
        DB2_MAPS.put(CHARACTER, "CHAR");
        DB2_MAPS.put(STRING, "VARCHAR");
        DB2_MAPS.put(SHORT, "SMALLINT");
        DB2_MAPS.put(SHORT_BASIC, "SMALLINT");
        DB2_MAPS.put(INT_BASIC, "INTEGER");
        DB2_MAPS.put(INTEGER, "INTEGER");
        DB2_MAPS.put(LONG, "BIGINT");
        DB2_MAPS.put(LONG_BASIC, "BIGINT");
        DB2_MAPS.put(FLOAT, "REAL");
        DB2_MAPS.put(FLOAT_BASIC, "REAL");
        DB2_MAPS.put(DOUBLE, "DOUBLE");
        DB2_MAPS.put(DOUBLE_BASIC, "DOUBLE");
        DB2_MAPS.put(NUMBER, "DECIMAL");
        DB2_MAPS.put(MONEY, "DECIMAL");
        DB2_MAPS.put(DECIMAL, "DECIMAL");
        DB2_MAPS.put(NCHAR, "CHAR");
        DB2_MAPS.put(NVARCHAR, "VARCHAR");
        DB2_MAPS.put(VARCHAR2, "VARCHAR");
        DB2_MAPS.put(TEXT, "CLOB");
        DB2_MAPS.put(LONGTEXT, "CLOB");
        DB2_MAPS.put(JSON, "CLOB");
        DB2_MAPS.put(JSONB, "CLOB");
        DB2_MAPS.put(ZONED_DATE_TIME, "TIMESTAMP");
        DB2_MAPS.put(GREGORIAN_CALENDAR, "TIMESTAMP");
        DB2_MAPS.put(DATETIME, "TIMESTAMP");
        DB2_MAPS.put(DATE, "DATE");
        DB2_MAPS.put(CALENDAR, "DATE");
        DB2_MAPS.put(DATE_SQL, "DATE");
        DB2_MAPS.put(DATE_UTIL, "DATE");
        DB2_MAPS.put(TIME, "TIME");
        DB2_MAPS.put(TIME_SQL, "TIME");
        DB2_MAPS.put(TIMESTAMP, "TIMESTAMP");
        DB2_MAPS.put(TIMESTAMP_SQL, "TIMESTAMP");
    }

    private static void initOracleMaps() {
        ORACLE_MAPS.put(BYTE, "blob");
        ORACLE_MAPS.put(BYTE_ARRAY, "blob");
        ORACLE_MAPS.put(BOOLEAN, CHAR);
        ORACLE_MAPS.put(BOOLEAN_BASIC, CHAR);
        ORACLE_MAPS.put(CHAR_BASIC, CHAR);
        ORACLE_MAPS.put(CHARACTER, CHAR);
        ORACLE_MAPS.put(STRING, VARCHAR2);
        ORACLE_MAPS.put(SHORT, "number");
        ORACLE_MAPS.put(SHORT_BASIC, "number");
        ORACLE_MAPS.put(INT_BASIC, "integer");
        ORACLE_MAPS.put(INTEGER, "integer");
        ORACLE_MAPS.put(LONG, "number");
        ORACLE_MAPS.put(LONG_BASIC, "number");
        ORACLE_MAPS.put(FLOAT, "number");
        ORACLE_MAPS.put(FLOAT_BASIC, "number");
        ORACLE_MAPS.put(DOUBLE, "number");
        ORACLE_MAPS.put(DOUBLE_BASIC, "number");
        ORACLE_MAPS.put(NUMBER, "number");
        ORACLE_MAPS.put(MONEY, "number");
        ORACLE_MAPS.put(DECIMAL, "decimal");
        ORACLE_MAPS.put(NCHAR, CHAR);
        ORACLE_MAPS.put(NVARCHAR, VARCHAR2);
        ORACLE_MAPS.put(VARCHAR2, VARCHAR2);
        ORACLE_MAPS.put(TEXT, "clob");
        ORACLE_MAPS.put(LONGTEXT, "clob");
        ORACLE_MAPS.put(JSON, "clob");
        ORACLE_MAPS.put(JSONB, "clob");
        ORACLE_MAPS.put(ZONED_DATE_TIME, "timestamp");
        ORACLE_MAPS.put(GREGORIAN_CALENDAR, "timestamp");
        ORACLE_MAPS.put(DATETIME, "timestamp");
        ORACLE_MAPS.put(DATE, "date");
        ORACLE_MAPS.put(CALENDAR, "date");
        ORACLE_MAPS.put(DATE_SQL, "date");
        ORACLE_MAPS.put(DATE_UTIL, "timestamp");
        ORACLE_MAPS.put(TIME, "timestamp");
        ORACLE_MAPS.put(TIME_SQL, "timestamp");
        ORACLE_MAPS.put(TIMESTAMP, "timestamp");
        ORACLE_MAPS.put(TIMESTAMP_SQL, "timestamp");
    }

    private static void initSqlServerMaps() {
        SQL_SERVER_MAPS.put(BYTE, "TINYINT");
        SQL_SERVER_MAPS.put(BYTE_ARRAY, "IMAGE");
        SQL_SERVER_MAPS.put(BOOLEAN, "BIT");
        SQL_SERVER_MAPS.put(BOOLEAN_BASIC, "BIT");
        SQL_SERVER_MAPS.put(CHAR_BASIC, "NCHAR");
        SQL_SERVER_MAPS.put(CHARACTER, "NCHAR");
        SQL_SERVER_MAPS.put(STRING, "VARCHAR");
        SQL_SERVER_MAPS.put(SHORT, "SMALLINT");
        SQL_SERVER_MAPS.put(SHORT_BASIC, "SMALLINT");
        SQL_SERVER_MAPS.put(INT_BASIC, "INT");
        SQL_SERVER_MAPS.put(INTEGER, "INT");
        SQL_SERVER_MAPS.put(LONG, "BIGINT");
        SQL_SERVER_MAPS.put(LONG_BASIC, "BIGINT");
        SQL_SERVER_MAPS.put(FLOAT, "FLOAT");
        SQL_SERVER_MAPS.put(FLOAT_BASIC, "FLOAT");
        SQL_SERVER_MAPS.put(DOUBLE, "FLOAT");
        SQL_SERVER_MAPS.put(DOUBLE_BASIC, "FLOAT");
        SQL_SERVER_MAPS.put(NUMBER, "NUMERIC");
        SQL_SERVER_MAPS.put(MONEY, "DECIMAL");
        SQL_SERVER_MAPS.put(DECIMAL, "DECIMAL");
        SQL_SERVER_MAPS.put(NCHAR, "CHAR");
        SQL_SERVER_MAPS.put(NVARCHAR, "VARCHAR");
        SQL_SERVER_MAPS.put(VARCHAR2, "VARCHAR");
        SQL_SERVER_MAPS.put(TEXT, "TEXT");
        SQL_SERVER_MAPS.put(LONGTEXT, "TEXT");
        SQL_SERVER_MAPS.put(JSON, "TEXT");
        SQL_SERVER_MAPS.put(JSONB, "TEXT");
        SQL_SERVER_MAPS.put(ZONED_DATE_TIME, "DATETIMEOFFSET");
        SQL_SERVER_MAPS.put(GREGORIAN_CALENDAR, "TIMESTAMP");
        SQL_SERVER_MAPS.put(DATETIME, "DATETIME");
        SQL_SERVER_MAPS.put(DATE, "DATE");
        SQL_SERVER_MAPS.put(CALENDAR, "DATE");
        SQL_SERVER_MAPS.put(DATE_SQL, "DATE");
        SQL_SERVER_MAPS.put(DATE_UTIL, "DATE");
        SQL_SERVER_MAPS.put(TIME, "TIME");
        SQL_SERVER_MAPS.put(TIME_SQL, "TIME");
        SQL_SERVER_MAPS.put(TIMESTAMP, "TIMESTAMP");
        SQL_SERVER_MAPS.put(TIMESTAMP_SQL, "TIMESTAMP");
    }

    private static void initSqliteMaps() {
        SQLITE_MAPS.put(BYTE, "TINYINT");
        SQLITE_MAPS.put(BYTE_ARRAY, "BLOB");
        SQLITE_MAPS.put(BOOLEAN, "BOOLEAN");
        SQLITE_MAPS.put(BOOLEAN_BASIC, "BOOLEAN");
        SQLITE_MAPS.put(CHAR_BASIC, "NCHAR");
        SQLITE_MAPS.put(CHARACTER, "NCHAR");
        SQLITE_MAPS.put(STRING, "NVARCHAR");
        SQLITE_MAPS.put(SHORT, "SMALLINT");
        SQLITE_MAPS.put(SHORT_BASIC, "SMALLINT");
        SQLITE_MAPS.put(INT_BASIC, "INTEGER");
        SQLITE_MAPS.put(INTEGER, "INTEGER");
        SQLITE_MAPS.put(LONG, "BIGINT");
        SQLITE_MAPS.put(LONG_BASIC, "BIGINT");
        SQLITE_MAPS.put(FLOAT, "FLOAT");
        SQLITE_MAPS.put(FLOAT_BASIC, "FLOAT");
        SQLITE_MAPS.put(DOUBLE, "DOUBLE");
        SQLITE_MAPS.put(DOUBLE_BASIC, "DOUBLE");
        SQLITE_MAPS.put(NUMBER, "NUMERIC");
        SQLITE_MAPS.put(MONEY, "DECIMAL");
        SQLITE_MAPS.put(DECIMAL, "DECIMAL");
        SQLITE_MAPS.put(NCHAR, "NCHAR");
        SQLITE_MAPS.put(NVARCHAR, "NVARCHAR");
        SQLITE_MAPS.put(VARCHAR2, "VARCHAR2");
        SQLITE_MAPS.put(TEXT, "TEXT");
        SQLITE_MAPS.put(LONGTEXT, "TEXT");
        SQLITE_MAPS.put(JSON, "TEXT");
        SQLITE_MAPS.put(JSONB, "TEXT");
        SQLITE_MAPS.put(ZONED_DATE_TIME, "TIMESTAMP");
        SQLITE_MAPS.put(GREGORIAN_CALENDAR, "TIMESTAMP");
        SQLITE_MAPS.put(DATETIME, "DATETIME");
        SQLITE_MAPS.put(DATE, "DATE");
        SQLITE_MAPS.put(CALENDAR, "DATE");
        SQLITE_MAPS.put(DATE_SQL, "DATE");
        SQLITE_MAPS.put(DATE_UTIL, "DATE");
        SQLITE_MAPS.put(TIME, "TIME");
        SQLITE_MAPS.put(TIME_SQL, "TIME");
        SQLITE_MAPS.put(TIMESTAMP, "TIMESTAMP");
        SQLITE_MAPS.put(TIMESTAMP_SQL, "TIMESTAMP");
    }

    private static void initJavaMap() {
        JAVA_MAPS.put(BYTE, BYTE);
        JAVA_MAPS.put(BYTE_ARRAY, "byte[]");
        JAVA_MAPS.put(BOOLEAN_BASIC, "boolean");
        JAVA_MAPS.put(BOOLEAN, BOOLEAN);
        JAVA_MAPS.put(CHAR_BASIC, CHAR);
        JAVA_MAPS.put(CHARACTER, "Character");
        JAVA_MAPS.put(STRING, STRING);
        JAVA_MAPS.put(SHORT_BASIC, "short");
        JAVA_MAPS.put(SHORT, SHORT);
        JAVA_MAPS.put(INT_BASIC, "int");
        JAVA_MAPS.put(INTEGER, INTEGER);
        JAVA_MAPS.put(LONG_BASIC, "long");
        JAVA_MAPS.put(LONG, LONG);
        JAVA_MAPS.put(FLOAT_BASIC, "float");
        JAVA_MAPS.put(FLOAT, FLOAT);
        JAVA_MAPS.put(REAL, NUMBER);
        JAVA_MAPS.put(DOUBLE_BASIC, "double");
        JAVA_MAPS.put(DOUBLE, DOUBLE);
        JAVA_MAPS.put(NUMERIC, NUMBER);
        JAVA_MAPS.put(DECIMAL, "java.math.BigDecimal");
        JAVA_MAPS.put(NUMBER, NUMBER);
        JAVA_MAPS.put(MONEY, "java.math.BigDecimal");
        JAVA_MAPS.put(DATETIME, "java.time.LocalDateTime");
        JAVA_MAPS.put(DATE_UTIL, DATE_UTIL);
        JAVA_MAPS.put(DATE_SQL, DATE_SQL);
        JAVA_MAPS.put(DATE, "java.time.LocalDate");
        JAVA_MAPS.put(CALENDAR, CALENDAR);
        JAVA_MAPS.put(TIME, "java.time.LocalTime");
        JAVA_MAPS.put(TIME_SQL, TIME_SQL);
        JAVA_MAPS.put(TIMESTAMP, "java.time.Instant");
        JAVA_MAPS.put(TIMESTAMP_SQL, TIMESTAMP_SQL);
        JAVA_MAPS.put(ZONED_DATE_TIME, "java.time.ZonedDateTime");
        JAVA_MAPS.put(GREGORIAN_CALENDAR, GREGORIAN_CALENDAR);
        JAVA_MAPS.put(CHAR, STRING);
        JAVA_MAPS.put(VARCHAR, STRING);
        JAVA_MAPS.put(NCHAR, STRING);
        JAVA_MAPS.put(NVARCHAR, STRING);
        JAVA_MAPS.put(VARCHAR2, STRING);
        JAVA_MAPS.put(TEXT, STRING);
        JAVA_MAPS.put(LONGTEXT, STRING);
        JAVA_MAPS.put(JSON, STRING);
        JAVA_MAPS.put(JSONB, STRING);
    }

    private static void initJdbcToJavaMaps() {
        JAVA_MAPS.put("NULL", "null");
        JAVA_MAPS.put("JAVA_OBJECT", "Object");
        JAVA_MAPS.put("BOOL", BOOLEAN);
        JAVA_MAPS.put("BOOLEAN", BOOLEAN);
        JAVA_MAPS.put("BIT", BOOLEAN);
        JAVA_MAPS.put("TINYINT", BYTE);
        JAVA_MAPS.put("SMALLINT", SHORT);
        JAVA_MAPS.put("INT2", SHORT);
        JAVA_MAPS.put("SMALLSERIAL", SHORT);
        JAVA_MAPS.put("SERIAL2", SHORT);
        JAVA_MAPS.put("INT", INTEGER);
        JAVA_MAPS.put("INT4", INTEGER);
        JAVA_MAPS.put("INTEGER", INTEGER);
        JAVA_MAPS.put("SERIAL", INTEGER);
        JAVA_MAPS.put("SERIAL4", INTEGER);
        JAVA_MAPS.put("BIGINT", LONG);
        JAVA_MAPS.put("INT8", LONG);
        JAVA_MAPS.put("SERIAL8", LONG);
        JAVA_MAPS.put("BIGSERIAL", LONG);
        JAVA_MAPS.put("DECIMAL", NUMBER);
        JAVA_MAPS.put("REAL", NUMBER);
        JAVA_MAPS.put("FLOAT", FLOAT);
        JAVA_MAPS.put("DOUBLE", DOUBLE);
        JAVA_MAPS.put("NUMERIC", "java.math.BigDecimal");
        JAVA_MAPS.put("MONEY", "java.math.BigDecimal");
        JAVA_MAPS.put("CHAR", STRING);
        JAVA_MAPS.put("NCHAR", STRING);
        JAVA_MAPS.put("VARCHAR", STRING);
        JAVA_MAPS.put("NVARCHAR", STRING);
        JAVA_MAPS.put("VARCHAR2", STRING);
        JAVA_MAPS.put("LONGVARCHAR", STRING);
        JAVA_MAPS.put("CLOB", STRING);
        JAVA_MAPS.put("TEXT", STRING);
        JAVA_MAPS.put("TINYTEXT", STRING);
        JAVA_MAPS.put("MEDIUMTEXT", STRING);
        JAVA_MAPS.put("LONGTEXT", STRING);
        JAVA_MAPS.put("CHARACTER", STRING);
        JAVA_MAPS.put("CHARACTER VARYING", STRING);
        JAVA_MAPS.put("GRAPHIC", STRING);
        JAVA_MAPS.put("VARGRAPHIC", STRING);
        JAVA_MAPS.put("JSON", STRING);
        JAVA_MAPS.put("JSONB", STRING);
        JAVA_MAPS.put("XML", STRING);
        JAVA_MAPS.put("SQLXML", STRING);
        JAVA_MAPS.put("SET", STRING);
        JAVA_MAPS.put("ENUM", STRING);
        JAVA_MAPS.put("BINARY", "byte[]");
        JAVA_MAPS.put("VARBINARY", "byte[]");
        JAVA_MAPS.put("LONGVARBINARY", "byte[]");
        JAVA_MAPS.put("BLOB", "byte[]");
        JAVA_MAPS.put("DATETIME", "java.time.LocalDateTime");
        JAVA_MAPS.put("DATE", "java.time.LocalDate");
        JAVA_MAPS.put("TIME", "java.time.LocalTime");
        JAVA_MAPS.put("TIMESTAMP", "java.time.Instant");
        JAVA_MAPS.put("TIME_WITH_TIMEZONE", "java.time.ZonedDateTime");
        JAVA_MAPS.put("OTHER", "Object");
    }

    static {
        JAVA_MAPS = new HashMap<String, String>();
        COMMON_SQL_MAPS = new HashMap<String, String>();
        COMMON_JAVA_MAPS = new HashMap<String, String>();
        MYSQL_MAPS = new HashMap<String, String>();
        POSTGRE_SQL_MAPS = new HashMap<String, String>();
        DB2_MAPS = new HashMap<String, String>();
        ORACLE_MAPS = new HashMap<String, String>();
        SQL_SERVER_MAPS = new HashMap<String, String>();
        SQLITE_MAPS = new HashMap<String, String>();
        CUSTOM_SQL_MAPS = new HashMap<String, String>();
        CUSTOM_JAVA_MAPS = new HashMap<String, String>();
        SdType.initJavaMap();
        SdType.initJdbcToJavaMaps();
        SdType.initCommonSQLMaps();
        SdType.initMySQLMaps();
        SdType.initPostgreSQLMaps();
        SdType.initDB2Maps();
        SdType.initOracleMaps();
        SdType.initSqlServerMaps();
        SdType.initSqliteMaps();
    }
}

