/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SdUtil {
    public static final String DEFAULT_PARTICIPLE_FLAG = "\u2665\u2665\u2665";
    public static final List<String> DEFAULT_PARTICIPLE_EXCLUDES = null;
    public static final List<String> DEFAULT_PARTICIPLE_TO_JOIN = SdUtil.asList(" ", "-", "_");

    public static String getUserDir() {
        return System.getProperty("user.dir") + "/";
    }

    public static String toHyphenCase(String str) {
        String underScore = SdUtil.splitJoin(str, DEFAULT_PARTICIPLE_FLAG);
        String[] split = underScore.split(DEFAULT_PARTICIPLE_FLAG);
        StringBuilder sb = new StringBuilder(split[0]);
        for (int i = 1; i < split.length; ++i) {
            sb.append("-" + split[i]);
        }
        return sb.toString().replaceAll("-+", "-");
    }

    public static String toHyphenCaseUpper(String str) {
        return SdUtil.toHyphenCase(str).toUpperCase();
    }

    public static String toUnderScoreCase(String str) {
        String underScore = SdUtil.splitJoin(str, DEFAULT_PARTICIPLE_FLAG);
        String[] split = underScore.split(DEFAULT_PARTICIPLE_FLAG);
        StringBuilder sb = new StringBuilder(split[0]);
        for (int i = 1; i < split.length; ++i) {
            sb.append("_" + split[i]);
        }
        return sb.toString().replaceAll("_+", "_");
    }

    public static String toUnderScoreCaseUpper(String str) {
        return SdUtil.toUnderScoreCase(str).toUpperCase();
    }

    public static String toPascalCase(String str) {
        String underScore = SdUtil.splitJoin(str, DEFAULT_PARTICIPLE_FLAG);
        String[] split = underScore.split(DEFAULT_PARTICIPLE_FLAG);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            sb.append(SdUtil.firstToUpperCase(split[i]));
        }
        return sb.toString();
    }

    public static String toCamelCase(String str) {
        String underScore = SdUtil.splitJoin(str, DEFAULT_PARTICIPLE_FLAG);
        String[] split = underScore.split(DEFAULT_PARTICIPLE_FLAG);
        StringBuilder sb = new StringBuilder(split[0]);
        for (int i = 1; i < split.length; ++i) {
            sb.append(SdUtil.firstToUpperCase(split[i]));
        }
        return sb.toString();
    }

    public static String firstToUpperCase(String str) {
        char[] s;
        if (str != null && str.length() > 0 && (s = str.toCharArray())[0] >= 'a' && s[0] <= 'z') {
            s[0] = (char)(s[0] - 32);
            return String.valueOf(s);
        }
        return str;
    }

    public static String firstToLowerCase(String str) {
        char[] s;
        if (str != null && str.length() > 0 && (s = str.toCharArray())[0] >= 'A' && s[0] <= 'Z') {
            s[0] = (char)(s[0] + 32);
            return String.valueOf(s);
        }
        return str;
    }

    public static String join(String separator, Object ... str) {
        if (str == null) {
            return null;
        }
        return SdUtil.join(Arrays.asList(str), separator);
    }

    public static String join(Collection<?> collection, String separator) {
        if (collection == null) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Object start = iterator.next();
        result.append((Object)(start == null ? "" : start));
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result.append(separator == null ? "" : separator);
            result.append((Object)(next == null ? "" : next));
        }
        return result.toString();
    }

    public static String splitJoin(String str, String join) {
        return SdUtil.splitJoin(str, join, DEFAULT_PARTICIPLE_EXCLUDES, DEFAULT_PARTICIPLE_TO_JOIN);
    }

    public static String splitJoin(String str, String join, List<String> excludes, List<String> replaceToJoin) {
        if (excludes != null) {
            for (String r : excludes) {
                str = str.replace(r, "");
            }
        }
        if (replaceToJoin != null) {
            for (String r : replaceToJoin) {
                str = str.replace(r, join);
            }
        }
        str = str.replaceAll(join + "+", join);
        ArrayList<String> splits = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            char c1;
            StringBuilder word = new StringBuilder();
            char c = str.charAt(i);
            word.append(c);
            ++i;
            if (SdUtil.isLetters(c)) {
                while (i < str.length() && SdUtil.isLetters(c1 = str.charAt(i)) && SdUtil.isLower(c) == SdUtil.isLower(c1)) {
                    word.append(c1);
                    ++i;
                }
            } else {
                while (i < str.length() && !SdUtil.isLetters(c1 = str.charAt(i))) {
                    word.append(c1);
                    ++i;
                }
            }
            splits.add(word.toString());
        }
        ArrayList<String> items = new ArrayList<String>();
        int i2 = 0;
        while (i2 < splits.size()) {
            if (((String)splits.get(i2)).length() == 1) {
                if (SdUtil.isNumber((String)splits.get(i2))) {
                    if (items.size() <= 0) continue;
                    String last = (String)items.get(items.size() - 1);
                    items.remove(items.size() - 1);
                    items.add(last + (String)splits.get(i2));
                    if (++i2 != splits.size()) continue;
                    break;
                }
                StringBuilder sb = new StringBuilder((String)splits.get(i2));
                if (++i2 < splits.size()) {
                    sb.append((String)splits.get(i2));
                    ++i2;
                }
                items.add(sb.toString());
                continue;
            }
            items.add((String)splits.get(i2));
            ++i2;
        }
        return SdUtil.magre(join, items).toLowerCase().replaceAll(join + "+", join);
    }

    public static boolean isLetters(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= 'a' && c <= 'z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isNumber(String str) {
        for (char c : str.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean indexOf(String regex, String ... str) {
        if (str == null) {
            return false;
        }
        for (String temp : str) {
            if (temp.indexOf(regex) != -1) continue;
            return false;
        }
        return true;
    }

    public static String magre(String separator, String ... str) {
        StringBuilder result = null;
        for (String temp : str) {
            if (result == null) {
                result = new StringBuilder(temp);
            }
            result.append(separator + temp);
        }
        return result == null ? null : result.toString();
    }

    public static String magre(String separator, List<String> items) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String temp : items) {
            if (!first) {
                result.append(separator);
            }
            result.append(temp);
            if (!first) continue;
            first = false;
        }
        return result.toString();
    }

    public static String replace(String str, List<String[]> rep) {
        for (String[] item : rep) {
            if (item[1] == null) {
                item[1] = "";
            }
            str = str.replace(item[0], item[1]);
        }
        return str;
    }

    public static String[] asStrArray(String ... str) {
        return str;
    }

    public static <T> List<T> asList(T ... t) {
        return Arrays.asList(t);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String ... str) {
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != null && !"".equals(str[i].trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object obj) {
        return obj == null;
    }

    public static boolean isNullOrEmpty(Object ... obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isNullOrEmpty(List<T> ... list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != null && !list[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void requireNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public static void requireNonNull(Object obj, String msg) {
        if (obj == null) {
            throw new NullPointerException(msg == null ? "null" : msg);
        }
    }

    public static void requireNonEmpty(Object obj) {
        if (SdUtil.isNullOrEmpty(obj)) {
            throw new NullPointerException();
        }
    }

    public static void requireNonEmpty(Object obj, String msg) {
        if (SdUtil.isNullOrEmpty(obj)) {
            throw new NullPointerException(msg == null ? "null" : msg);
        }
    }

    public static String readFileToString(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        byte[] bytes = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(bytes);
        ((InputStream)inputStream).close();
        return new String(bytes);
    }
}

