/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl.dbutil;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.mirrentools.sd.ScrewDriverDbUtil;
import org.mirrentools.sd.models.db.query.SdTable;
import org.mirrentools.sd.models.db.query.SdTableAttribute;
import org.mirrentools.sd.models.db.query.SdTableColumnAttribute;
import org.mirrentools.sd.models.db.query.SdTableIndexKeyAttribute;
import org.mirrentools.sd.models.db.query.SdTablePortedKeysAttribute;
import org.mirrentools.sd.models.db.query.SdTablePrimaryKeyAttribute;
import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;
import org.mirrentools.sd.models.db.update.SdAbstractTableContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public abstract class SdAbstractDbUtil
extends ScrewDriverDbUtil {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private SdDatabaseOptions config;

    public SdAbstractDbUtil(SdDatabaseOptions config) {
        this.config = config;
    }

    public SdDatabaseOptions getBaseUrlConfig() {
        String[] split = this.getConfig().getUrl().split("\\?");
        String prefix = split[0].substring(0, split[0].lastIndexOf("/") + 1);
        StringBuilder url = new StringBuilder();
        url.append(prefix);
        if (split.length > 1) {
            url.append("?");
            url.append(split[1]);
        }
        SdDatabaseOptions options = new SdDatabaseOptions(this.getConfig().getDriverClass(), url.toString());
        options.setUser(this.getConfig().getUser());
        options.setPassword(this.getConfig().getPassword());
        return options;
    }

    @Override
    public Connection getConnection() throws Exception {
        return this.getConnection(this.config);
    }

    @Override
    public Connection getConnection(SdDatabaseOptions config) throws Exception {
        DriverManager.setLoginTimeout(config.getLoginTimeout());
        Class.forName(config.getDriverClass());
        return DriverManager.getConnection(config.getUrl(), config.getUser(), config.getPassword());
    }

    @Override
    public boolean createDatabase(SdAbstractDatabaseContent content) throws Exception {
        return this.createDatabase(this.getConfig(), content);
    }

    @Override
    public boolean createDatabase(SdDatabaseOptions config, SdAbstractDatabaseContent content) throws Exception {
        int result = 0;
        Connection connection = this.getConnection(config);
        try {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + content.createSQL());
            this.LOG.info(String.format("\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93: %s...", content.getDatabaseName()));
            result = connection.createStatement().executeUpdate(content.createSQL());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return result == 1;
    }

    @Override
    public boolean updateDatabase(SdAbstractDatabaseContent content) throws Exception {
        return this.updateDatabase(this.getConfig(), content);
    }

    @Override
    public boolean updateDatabase(SdDatabaseOptions config, SdAbstractDatabaseContent content) throws Exception {
        int result = 0;
        Connection connection = this.getConnection(config);
        try {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + content.updateSQL());
            result = connection.createStatement().executeUpdate(content.updateSQL());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return result == 1;
    }

    @Override
    public boolean createTable(SdAbstractTableContent content) throws Exception {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + content.createSQL());
            statement = connection.createStatement();
            for (String sql : content.createSQL()) {
                statement.execute(sql);
            }
            this.LOG.info(String.format("Create table-->%s Successful", content.getTableName()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean updateTable(SdAbstractTableContent content) throws Exception {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + content.updateSQL());
            statement = connection.createStatement();
            List<String> list = content.updateSQL();
            for (int i = 0; i < list.size(); ++i) {
                statement.execute(list.get(i));
            }
            this.LOG.info(String.format("Update table-->%s Successful", content.getTableName()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean deleteTable(SdAbstractTableContent content) throws Exception {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + content.deleteSQL());
            statement = connection.createStatement();
            statement.execute(content.deleteSQL());
            this.LOG.info(String.format("Delete table-->%s Successful", content.getTableName()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean existDatabase(String dbName) throws Exception {
        return this.existDatabase(this.getConfig(), dbName);
    }

    @Override
    public boolean existTable(String tableName) throws Exception {
        Connection connection = this.getConnection();
        ResultSet query = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            query = md.getTables(catalog, null, tableName, new String[]{"TABLE"});
            boolean bl = query.next();
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (query != null) {
                query.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public SdTable getSdTable(String tableName) throws Exception {
        return this.getSdTable(tableName, true, true);
    }

    @Override
    public SdTable getSdTable(String tableName, boolean unique, boolean approximate) throws Exception {
        SdTable result = new SdTable();
        result.setInfo(this.getTableAttribute(tableName));
        result.setColumns(this.getTableColumnsAttribute(tableName));
        result.setPrimaryKey(this.getTablePrimaryKeyAttribute(tableName));
        result.setIndexKeys(this.getTableIndexKeysAttribute(tableName, unique, approximate));
        result.setForeignKeys(this.getTableImportedKeysAttribute(tableName));
        return result;
    }

    @Override
    public List<String> getTableNames() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Connection connection = this.getConnection();
        ResultSet rs = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW"};
            rs = md.getTables(null, null, null, types);
            while (rs.next()) {
                result.add(rs.getString(3));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SdTableAttribute getTableAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            String[] types = new String[]{"TABLE", "VIEW"};
            rs = md.getTables(catalog, null, tableName, types);
            SdTableAttribute result = null;
            if (rs.next()) {
                result = new SdTableAttribute();
                this.converterTableAttribute(rs, result);
            }
            SdTableAttribute sdTableAttribute = result;
            return sdTableAttribute;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTableColumnAttribute> getTableColumnsAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getColumns(catalog, null, tableName, null);
            LinkedHashMap<String, SdTableColumnAttribute> columnMap = new LinkedHashMap<String, SdTableColumnAttribute>();
            while (rs.next()) {
                SdTableColumnAttribute attr = new SdTableColumnAttribute();
                this.converterColumnsAttribute(rs, attr);
                columnMap.put(rs.getString("COLUMN_NAME"), attr);
            }
            if (columnMap.size() == 0) {
                throw new NullPointerException("\u4ece\u8868\u4e2d\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25!\u83b7\u53d6\u4e0d\u5230\u4efb\u4f55\u5b57\u6bb5!");
            }
            ArrayList<SdTableColumnAttribute> result = new ArrayList<SdTableColumnAttribute>(columnMap.values());
            Collections.sort(result);
            ArrayList<SdTableColumnAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SdTablePrimaryKeyAttribute getTablePrimaryKeyAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getPrimaryKeys(catalog, null, tableName);
            SdTablePrimaryKeyAttribute result = null;
            if (rs.next()) {
                result = new SdTablePrimaryKeyAttribute();
                this.converterPrimaryKeyAttribute(rs, result);
            }
            SdTablePrimaryKeyAttribute sdTablePrimaryKeyAttribute = result;
            return sdTablePrimaryKeyAttribute;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTableIndexKeyAttribute> getTableIndexKeysAttribute(String tableName, boolean unique, boolean approximate) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getIndexInfo(catalog, null, tableName, unique, approximate);
            ArrayList<SdTableIndexKeyAttribute> result = new ArrayList<SdTableIndexKeyAttribute>();
            while (rs.next()) {
                SdTableIndexKeyAttribute attr = new SdTableIndexKeyAttribute();
                this.converterIndexKeysAttribute(rs, attr);
                result.add(attr);
            }
            ArrayList<SdTableIndexKeyAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTablePortedKeysAttribute> getTableExportedKeysAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getExportedKeys(catalog, null, tableName);
            ArrayList<SdTablePortedKeysAttribute> result = new ArrayList<SdTablePortedKeysAttribute>();
            while (rs.next()) {
                SdTablePortedKeysAttribute attr = new SdTablePortedKeysAttribute();
                this.converterPortedKeysAttribute(rs, attr);
                result.add(attr);
            }
            ArrayList<SdTablePortedKeysAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTablePortedKeysAttribute> getTableImportedKeysAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getImportedKeys(catalog, null, tableName);
            ArrayList<SdTablePortedKeysAttribute> result = new ArrayList<SdTablePortedKeysAttribute>();
            while (rs.next()) {
                SdTablePortedKeysAttribute attr = new SdTablePortedKeysAttribute();
                this.converterPortedKeysAttribute(rs, attr);
                result.add(attr);
            }
            ArrayList<SdTablePortedKeysAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void converterTableAttribute(ResultSet rs, SdTableAttribute result) throws SQLException {
        result.setTableName(rs.getString("TABLE_NAME"));
        result.setRemarks(rs.getString("REMARKS"));
        try {
            result.setTableCat(rs.getString("TABLE_CAT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTableSchem(rs.getString("TABLE_SCHEM"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTableType(rs.getString("TABLE_TYPE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTypeCat(rs.getString("TYPE_CAT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTypeSchem(rs.getString("TYPE_SCHEM"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setTypeName(rs.getString("TYPE_NAME"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setSelfReferencingColName(rs.getString("SELF_REFERENCING_COL_NAME"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            result.setRefGeneration(rs.getString("REF_GENERATION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void converterColumnsAttribute(ResultSet rs, SdTableColumnAttribute result) throws SQLException {
        result.setTableCat(rs.getString(1));
        result.setTableSchem(rs.getString(2));
        result.setTableName(rs.getString(3));
        result.setColumnName(rs.getString(4));
        result.setDataType(rs.getInt(5));
        result.setTypeName(rs.getString(6));
        result.setColumnSize(rs.getInt(7));
        result.setDecimalDigits(rs.getInt(9));
        result.setNumPrecRadix(rs.getInt(10));
        result.setNullable(rs.getInt(11));
        result.setRemarks(rs.getString(12));
        result.setColumnDef(rs.getString(13));
        result.setCharOctetLength(rs.getInt(16));
        result.setOrdinalPosition(rs.getInt(17));
        result.setIsNullable(rs.getString(18));
        result.setScopeCatalog(rs.getString(19));
        result.setScopeSchema(rs.getString(20));
        result.setScopeTable(rs.getString(21));
        try {
            result.setSourceDataType(rs.getShort(22));
        }
        catch (Exception e) {
            try {
                result.setSourceDataType(new Short(rs.getString(22)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        result.setAutoincrement(rs.getString(23));
        result.setGeneratedcolumn(rs.getString(24));
    }

    public void converterPrimaryKeyAttribute(ResultSet rs, SdTablePrimaryKeyAttribute result) throws SQLException {
        result.setTableCat(rs.getString(1));
        result.setTableSchem(rs.getString(2));
        result.setTableName(rs.getString(3));
        result.setColumnName(rs.getString(4));
        result.setKeySeq(rs.getString(5));
        result.setPkName(rs.getString(6));
    }

    public void converterIndexKeysAttribute(ResultSet rs, SdTableIndexKeyAttribute result) throws SQLException {
        result.setTableCat(rs.getString(1));
        result.setTableSchem(rs.getString(2));
        result.setTableName(rs.getString(3));
        result.setNonUnique(rs.getBoolean(4));
        result.setIndexQualifier(rs.getString(5));
        result.setIndexName(rs.getString(6));
        result.setType(rs.getShort(7));
        result.setOrdinalPosition(rs.getShort(8));
        result.setColumnName(rs.getString(9));
        result.setAscOrDesc(rs.getString(10));
        result.setCardinality(rs.getInt(11));
        result.setPages(rs.getInt(12));
        result.setFilterCondition(rs.getString(13));
    }

    public void converterPortedKeysAttribute(ResultSet rs, SdTablePortedKeysAttribute result) throws SQLException {
        result.setPktableCat(rs.getString(1));
        result.setPktableSchem(rs.getString(2));
        result.setPktableName(rs.getString(3));
        result.setPkcolumnName(rs.getString(4));
        result.setFktableCat(rs.getString(5));
        result.setFktableSchem(rs.getString(6));
        result.setFktableName(rs.getString(7));
        result.setFkcolumnName(rs.getString(8));
        result.setKeySeq(rs.getShort(9));
        result.setUpdateRule(rs.getShort(10));
        result.setDeleteRule(rs.getShort(11));
        result.setFkName(rs.getString(12));
        result.setPkName(rs.getString(13));
        result.setDeferrability(rs.getShort(14));
    }

    public SdDatabaseOptions getConfig() {
        return this.config;
    }

    public SdAbstractDbUtil setConfig(SdDatabaseOptions config) {
        this.config = config;
        return this;
    }
}

