/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdColumn;
import org.mirrentools.sd.models.SdRelationalContent;

public class SdClassContent {
    private String tableName;
    private String alias;
    private String lowerName;
    private String upperName;
    private String pascalName;
    private String camelName;
    private String hyphenName;
    private String underScoreName;
    private String remark;
    private Set<String> imports;
    private Set<String> annotations;
    private List<SdColumn> fields;
    private List<SdColumn> primaryField;
    private List<SdColumn> foreignField;
    private List<SdColumn> indexField;
    private List<SdColumn> otherField;
    private List<SdColumn> cantNullField;
    private List<SdColumn> additionalField;
    private List<SdRelationalContent> relationals;
    private Map<String, Object> extensions;

    public String getTableName() {
        return this.tableName;
    }

    public SdClassContent setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public SdClassContent setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public SdClassContent setLowerName(String lowerName) {
        this.lowerName = lowerName;
        return this;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public SdClassContent setUpperName(String upperName) {
        this.upperName = upperName;
        return this;
    }

    public String getPascalName() {
        return this.pascalName;
    }

    public SdClassContent setPascalName(String pascalName) {
        this.pascalName = pascalName;
        return this;
    }

    public String getCamelName() {
        return this.camelName;
    }

    public SdClassContent setCamelName(String camelName) {
        this.camelName = camelName;
        return this;
    }

    public String getHyphenName() {
        return this.hyphenName;
    }

    public SdClassContent setHyphenName(String hyphenName) {
        this.hyphenName = hyphenName;
        return this;
    }

    public String getUnderScoreName() {
        return this.underScoreName;
    }

    public SdClassContent setUnderScoreName(String underScoreName) {
        this.underScoreName = underScoreName;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public SdClassContent setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public SdClassContent addImports(String imports) {
        if (this.getImports() == null) {
            this.setImports(new LinkedHashSet<String>());
        }
        this.getImports().add(imports);
        return this;
    }

    public SdClassContent setImports(Set<String> imports) {
        this.imports = imports;
        return this;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public SdClassContent addAnnotation(String annotation) {
        if (this.getAnnotations() == null) {
            this.setAnnotations(new LinkedHashSet<String>());
        }
        this.annotations.add(annotation);
        return this;
    }

    public SdClassContent setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public List<SdColumn> getFields() {
        return this.fields;
    }

    public SdClassContent addField(SdColumn field) {
        if (this.getFields() == null) {
            this.setFields(new ArrayList<SdColumn>());
        }
        this.getFields().add(field);
        return this;
    }

    public SdClassContent setFields(List<SdColumn> fields) {
        this.fields = fields;
        return this;
    }

    public List<SdColumn> getPrimaryField() {
        return this.primaryField;
    }

    public SdClassContent addPrimaryField(SdColumn field) {
        if (this.getPrimaryField() == null) {
            this.setPrimaryField(new ArrayList<SdColumn>());
        }
        this.getPrimaryField().add(field);
        return this;
    }

    public SdClassContent setPrimaryField(List<SdColumn> primaryField) {
        this.primaryField = primaryField;
        return this;
    }

    public List<SdColumn> getForeignField() {
        return this.foreignField;
    }

    public SdClassContent addForeignField(SdColumn foreignField) {
        if (this.getForeignField() == null) {
            this.setForeignField(new ArrayList<SdColumn>());
        }
        this.getForeignField().add(foreignField);
        return this;
    }

    public SdClassContent setForeignField(List<SdColumn> foreignField) {
        this.foreignField = foreignField;
        return this;
    }

    public List<SdColumn> getIndexField() {
        return this.indexField;
    }

    public SdClassContent addIndexField(SdColumn field) {
        if (this.getIndexField() == null) {
            this.setIndexField(new ArrayList<SdColumn>());
        }
        this.getIndexField().add(field);
        return this;
    }

    public SdClassContent setIndexField(List<SdColumn> indexField) {
        this.indexField = indexField;
        return this;
    }

    public List<SdColumn> getOtherField() {
        return this.otherField;
    }

    public SdClassContent addOtherField(SdColumn field) {
        if (this.getOtherField() == null) {
            this.setOtherField(new ArrayList<SdColumn>());
        }
        this.getOtherField().add(field);
        return this;
    }

    public SdClassContent setOtherField(List<SdColumn> otherField) {
        this.otherField = otherField;
        return this;
    }

    public List<SdColumn> getCantNullField() {
        return this.cantNullField;
    }

    public SdClassContent addCantNullField(SdColumn field) {
        if (this.getCantNullField() == null) {
            this.setCantNullField(new ArrayList<SdColumn>());
        }
        this.getCantNullField().add(field);
        return this;
    }

    public SdClassContent setCantNullField(List<SdColumn> cantNullField) {
        this.cantNullField = cantNullField;
        return this;
    }

    public List<SdColumn> getAdditionalField() {
        return this.additionalField;
    }

    public SdClassContent addAdditionalField(SdColumn additionalField) {
        if (this.getAdditionalField() == null) {
            this.setAdditionalField(new ArrayList<SdColumn>());
        }
        this.getAdditionalField().add(additionalField);
        return this;
    }

    public SdClassContent setAdditionalField(List<SdColumn> additionalField) {
        this.additionalField = additionalField;
        return this;
    }

    public List<SdRelationalContent> getRelationals() {
        return this.relationals;
    }

    public SdClassContent addRelational(SdRelationalContent relational) {
        if (this.getRelationals() == null) {
            this.setRelationals(new ArrayList<SdRelationalContent>());
        }
        this.getRelationals().add(relational);
        return this;
    }

    public SdClassContent setRelationals(List<SdRelationalContent> relationals) {
        this.relationals = relationals;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdClassContent addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdClassContent setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SdClassContent: \n");
        sb.append("tableName=" + this.tableName + "\n");
        sb.append("alias=" + this.alias + "\n");
        sb.append("lowerName=" + this.lowerName + "\n");
        sb.append("upperName=" + this.upperName + "\n");
        sb.append("pascalName=" + this.pascalName + "\n");
        sb.append("camelName=" + this.camelName + "\n");
        sb.append("hyphenName=" + this.hyphenName + "\n");
        sb.append("underScoreName=" + this.underScoreName + "\n");
        sb.append("remark=" + this.remark + "\n");
        if (this.imports != null) {
            sb.append("*********************imports*************************\n");
            for (String impt : this.imports) {
                sb.append("\u2523\u2501" + impt + "\n");
            }
        } else {
            sb.append("imports: " + this.imports + "\n");
        }
        if (this.annotations != null) {
            sb.append("*********************annotations*************************\n");
            for (String anno : this.annotations) {
                sb.append("\u2523\u2501" + anno + "\n");
            }
        } else {
            sb.append("annotations: " + this.annotations + "\n");
        }
        if (this.fields != null) {
            sb.append("*********************fields*************************\n");
            for (SdColumn f : this.fields) {
                sb.append(f);
            }
        } else {
            sb.append("fields: " + this.fields + "\n");
        }
        if (this.primaryField != null) {
            sb.append("********************primaryField**************************\n");
            for (SdColumn f : this.primaryField) {
                sb.append(f);
            }
        } else {
            sb.append("primaryField: " + this.primaryField + "\n");
        }
        if (this.foreignField != null) {
            sb.append("*******************foreignField***************************\n");
            for (SdColumn f : this.foreignField) {
                sb.append(f);
            }
        } else {
            sb.append("foreignField: " + this.foreignField + "\n");
        }
        if (this.indexField != null) {
            sb.append("*******************indexField***************************\n");
            for (SdColumn f : this.indexField) {
                sb.append(f);
            }
        } else {
            sb.append("indexField: " + this.indexField + "\n");
        }
        if (this.otherField != null) {
            sb.append("*******************otherField***************************\n");
            for (SdColumn f : this.otherField) {
                sb.append(f);
            }
        } else {
            sb.append("otherField: " + this.otherField + "\n");
        }
        if (this.cantNullField != null) {
            sb.append("*******************cantNullField***************************\n");
            for (SdColumn f : this.cantNullField) {
                sb.append(f);
            }
        } else {
            sb.append("cantNullField: " + this.cantNullField + "\n");
        }
        if (this.relationals != null) {
            sb.append("*******************relationals***************************\n");
            for (SdRelationalContent r : this.relationals) {
                sb.append(r);
            }
        } else {
            sb.append("relationals: " + this.relationals + "\n");
        }
        sb.append("extensions: " + this.extensions + "\n");
        return sb.toString();
    }
}

