/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update;

import org.mirrentools.sd.models.db.update.SdAbstractSequenceContent;

public class SdBasicSequenceContent
extends SdAbstractSequenceContent {
    @Override
    public String createSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" CREATE SEQUENCE IF NOT EXISTS " + this.getName());
        if (this.getDataType() != null) {
            sb.append(" AS " + this.getDataType());
        }
        if (this.getIncrementBy() != null) {
            sb.append(" INCREMENT BY " + this.getIncrementBy());
        }
        if (this.getMinValue() != null) {
            sb.append(" MINVALUE " + this.getMinValue());
        }
        if (this.getMaxValue() != null) {
            sb.append(" MAXVALUE " + this.getMaxValue());
        }
        if (this.getStart() != null) {
            sb.append(" START WITH " + this.getStart());
        }
        if (this.getCache() != null) {
            sb.append(" CACHE " + this.getCache());
        }
        if (this.getCycle() != null && this.getCycle().booleanValue()) {
            sb.append(" CYCLE ");
        }
        if (this.getOwnedBy() != null) {
            sb.append(" OWNED BY " + this.getOwnedBy());
        }
        return sb.toString();
    }

    @Override
    public String updateSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER SEQUENCE " + this.getName());
        if (this.getDataType() != null) {
            sb.append(" AS " + this.getDataType());
        }
        if (this.getIncrementBy() != null) {
            sb.append(" INCREMENT BY " + this.getIncrementBy());
        }
        if (this.getMinValue() != null) {
            sb.append(" MINVALUE " + this.getMinValue());
        }
        if (this.getMaxValue() != null) {
            sb.append(" MAXVALUE " + this.getMaxValue());
        }
        if (this.getStart() != null) {
            sb.append(" START WITH " + this.getStart());
        }
        if (this.getRestart() != null) {
            sb.append(" RESTART WITH " + this.getRestart());
        }
        if (this.getCache() != null) {
            sb.append("  CACHE " + this.getCache());
        }
        if (this.getCycle() != null && this.getCycle().booleanValue()) {
            sb.append(" CYCLE ");
        }
        if (this.getOwnedBy() != null) {
            sb.append(" OWNED BY " + this.getOwnedBy());
        }
        return sb.toString();
    }

    @Override
    public String deleteSQL() {
        return String.format("DROP SEQUENCE IF EXISTS %s", this.getName());
    }
}

