/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update.impl.oracle;

import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;

public class SdDatabaseContentByOracle
extends SdAbstractDatabaseContent {
    private String newDatabaseName;
    private String userName;
    private String template;
    private String encoding;
    private String collate;
    private String ctype;
    private String tablespaceName;
    private String allowconn;
    private String connlimit;
    private String istemplate;

    public SdDatabaseContentByOracle(String databaseName) {
        super(databaseName);
    }

    @Override
    public String createSQL() {
        StringBuilder sb = new StringBuilder("CREATE DATABASE ");
        sb.append(this.getDatabaseName());
        if (this.getUserName() != null) {
            sb.append(" OWNER = " + this.getUserName());
        }
        if (this.getTemplate() != null) {
            sb.append(" TEMPLATE = " + this.getTemplate());
        }
        if (this.getEncoding() != null) {
            sb.append(" ENCODING = " + this.getEncoding());
        }
        if (this.getCollate() != null) {
            sb.append(" LC_COLLATE = " + this.getCollate());
        }
        if (this.getCtype() != null) {
            sb.append(" LC_CTYPE = " + this.getCtype());
        }
        if (this.getTablespaceName() != null) {
            sb.append(" TABLESPACE = " + this.getTablespaceName());
        }
        if (this.getAllowconn() != null) {
            sb.append(" ALLOW_CONNECTIONS = " + this.getAllowconn());
        }
        if (this.getConnlimit() != null) {
            sb.append(" CONNECTION LIMIT = " + this.getConnlimit());
        }
        if (this.getIstemplate() != null) {
            sb.append(" IS_TEMPLATE = " + this.getIstemplate());
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public String updateSQL() throws UnsupportedOperationException {
        StringBuilder sb = new StringBuilder(" ALTER DATABASE ");
        sb.append(this.getDatabaseName());
        if (this.getAllowconn() != null) {
            sb.append(" ALLOW_CONNECTIONS = " + this.getAllowconn());
        }
        if (this.getConnlimit() != null) {
            sb.append(" CONNECTION LIMIT = " + this.getConnlimit());
        }
        if (this.getIstemplate() != null) {
            sb.append(" IS_TEMPLATE = " + this.getIstemplate());
        }
        if (this.getAllowconn() != null && this.getConnlimit() != null && this.getIstemplate() != null) {
            sb.append(";");
        }
        if (this.getNewDatabaseName() != null) {
            sb.append(" ALTER DATABASE ");
            sb.append(this.getDatabaseName());
            sb.append(" RENAME TO ");
            sb.append(this.getNewDatabaseName());
            sb.append(";");
        }
        if (this.getUserName() != null) {
            sb.append(" ALTER DATABASE ");
            sb.append(this.getDatabaseName());
            sb.append(" OWNER TO ");
            sb.append(this.getUserName());
            sb.append(";");
        }
        if (this.getTablespaceName() != null) {
            sb.append(" ALTER DATABASE ");
            sb.append(this.getDatabaseName());
            sb.append(" SET TABLESPACE ");
            sb.append(this.getTablespaceName());
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public String deleteSQL() {
        return "DROP DATABASE " + this.getDatabaseName();
    }

    public String getNewDatabaseName() {
        return this.newDatabaseName;
    }

    public SdDatabaseContentByOracle setNewDatabaseName(String newDatabaseName) {
        this.newDatabaseName = newDatabaseName;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public SdDatabaseContentByOracle setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public SdDatabaseContentByOracle setTemplate(String template) {
        this.template = template;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public SdDatabaseContentByOracle setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getCollate() {
        return this.collate;
    }

    public SdDatabaseContentByOracle setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public SdDatabaseContentByOracle setTablespaceName(String tablespaceName) {
        this.tablespaceName = tablespaceName;
        return this;
    }

    public String getCtype() {
        return this.ctype;
    }

    public SdDatabaseContentByOracle setCtype(String ctype) {
        this.ctype = ctype;
        return this;
    }

    public String getAllowconn() {
        return this.allowconn;
    }

    public SdDatabaseContentByOracle setAllowconn(String allowconn) {
        this.allowconn = allowconn;
        return this;
    }

    public String getConnlimit() {
        return this.connlimit;
    }

    public SdDatabaseContentByOracle setConnlimit(String connlimit) {
        this.connlimit = connlimit;
        return this;
    }

    public String getIstemplate() {
        return this.istemplate;
    }

    public SdDatabaseContentByOracle setIstemplate(String istemplate) {
        this.istemplate = istemplate;
        return this;
    }
}

