/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update.impl.postgresql;

import java.util.ArrayList;
import java.util.List;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.db.update.SdAbstractColumnContent;
import org.mirrentools.sd.models.db.update.SdAbstractIndexKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractSequenceContent;
import org.mirrentools.sd.models.db.update.SdBasicTableContent;

public class SdTableContentByPostgreSQL
extends SdBasicTableContent {
    public static final String DEFAULT_SCHEMAS = "public";
    private String collate;

    public SdTableContentByPostgreSQL() {
        super.setSchema(DEFAULT_SCHEMAS);
    }

    public SdTableContentByPostgreSQL(String schemas) {
        super.setSchema(schemas);
    }

    @Override
    public List<String> createSQL() {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        result.add(super.createSQL().get(0).replace("UNSIGNED", ""));
        if (!SdUtil.isNullOrEmpty(this.getRemark())) {
            result.add(this.createTableComment());
        }
        for (i = 0; i < this.getColums().size(); ++i) {
            if (SdUtil.isNullOrEmpty(this.getColums().get(i).getRemark())) continue;
            result.add(this.createColumnComment(this.getColums().get(i)));
        }
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            for (i = 0; i < this.getIndexKeys().size(); ++i) {
                this.generateIndex(true, this.getIndexKeys().get(i), result);
            }
        }
        if (this.getSequences() != null && !this.getSequences().isEmpty()) {
            for (SdAbstractSequenceContent sequence : this.getSequences()) {
                result.add(sequence.createSQL());
            }
        }
        return result;
    }

    @Override
    public List<String> updateSQL() {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        result.add(super.updateSQL().get(0).replace("UNSIGNED", ""));
        if (!SdUtil.isNullOrEmpty(this.getRemark())) {
            result.add(this.createTableComment());
        }
        for (i = 0; i < this.getColums().size(); ++i) {
            if (SdUtil.isNullOrEmpty(this.getColums().get(i).getRemark())) continue;
            result.add(this.createColumnComment(this.getColums().get(i)));
        }
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            for (i = 0; i < this.getIndexKeys().size(); ++i) {
                result.add(String.format(" DROP INDEX IF EXISTS %s.%s;", this.getSchema(), this.getIndexKeys().get(i).getName()));
                this.generateIndex(false, this.getIndexKeys().get(i), result);
            }
        }
        if (this.getSequences() != null && !this.getSequences().isEmpty()) {
            for (SdAbstractSequenceContent sequence : this.getSequences()) {
                result.add(sequence.updateSQL());
            }
        }
        return result;
    }

    @Override
    public String deleteSQL() {
        return String.format(" DROP TABLE '%s'.'%s';", this.getSchema(), this.getTableName());
    }

    public String createTableComment() {
        return String.format(" COMMENT ON TABLE %s.%s IS '%s';\n", this.getSchema(), this.getTableName(), this.getRemark());
    }

    public String createColumnComment(SdAbstractColumnContent column) {
        return String.format(" COMMENT ON COLUMN %s.%s.%s IS '%s';\n", this.getSchema(), this.getTableName(), column.getName(), column.getRemark());
    }

    public void generateIndex(boolean mode, SdAbstractIndexKeyContent index, List<String> result) {
        StringBuilder sb = new StringBuilder();
        if (mode) {
            sb.append(" CREATE ");
        } else {
            sb.append(" ALTER ");
        }
        if (index.isUnique()) {
            sb.append(" UNIQUE ");
        }
        sb.append(" INDEX ");
        if (index.isConcurrently()) {
            sb.append(" CONCURRENTLY ");
        }
        sb.append(String.format(" %s ON %s.%s USING %s ", index.getName(), this.getSchema(), this.getTableName(), index.getType()));
        sb.append(" (");
        for (int i = 0; i < index.getColumns().size(); ++i) {
            sb.append("\"" + index.getColumns().get(i) + "\"");
            if (i == index.getColumns().size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        if (this.converterExtensions() != null) {
            sb.append(" " + this.converterExtensions());
        }
        sb.append(";\n");
        result.add(sb.toString());
        if (!SdUtil.isNullOrEmpty(index.getRemark())) {
            result.add(String.format(" COMMENT ON INDEX %s.%s IS '%s';\n", this.getSchema(), index.getName(), index.getRemark()));
        }
    }

    @Override
    public String getCollate() {
        return this.collate;
    }

    @Override
    public SdTableContentByPostgreSQL setCollate(String collate) {
        this.collate = collate;
        return this;
    }
}

