/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update.impl.sqlite;

import java.util.ArrayList;
import java.util.List;
import org.mirrentools.sd.models.db.update.SdAbstractColumnContent;
import org.mirrentools.sd.models.db.update.SdBasicTableContent;

public class SdTableContentBySqlite
extends SdBasicTableContent {
    @Override
    public List<String> createSQL() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE TABLE %s %s(", this.isIfNotExist() ? " IF NOT EXIST " : "", this.getTableName()));
        if (this.getPrimaryKey() != null && this.getPrimaryKey().getColumns() != null && this.getPrimaryKey().getColumns().size() > 1) {
            for (i = 0; i < this.getColums().size(); ++i) {
                sb.append(this.getColums().get(i).createSQL());
                if (i == this.getColums().size() - 1) continue;
                sb.append(",");
            }
            if (this.getPrimaryKey() != null && this.getPrimaryKey().getColumns() != null && !this.getPrimaryKey().getColumns().isEmpty()) {
                sb.append(",");
                sb.append(this.getPrimaryKey().createSQL());
            }
        } else {
            for (i = 0; i < this.getColums().size(); ++i) {
                sb.append(this.getColumnSQL(this.getColums().get(i)));
                if (i == this.getColums().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getForeignKeys() != null && !this.getForeignKeys().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getForeignKeys().size(); ++i) {
                sb.append(this.getForeignKeys().get(i).createSQL());
                if (i == this.getForeignKeys().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getConstraints().size(); ++i) {
                sb.append(this.getConstraints().get(i).createSQL());
                if (i == this.getConstraints().size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append(");\n");
        ArrayList<String> result = new ArrayList<String>();
        result.add(sb.toString());
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            for (int i2 = 0; i2 < this.getIndexKeys().size(); ++i2) {
                result.add(this.getIndexKeys().get(i2).createSQL());
            }
        }
        return result;
    }

    @Override
    public List<String> updateSQL() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("ALTER TABLE %s(", this.getTableName()));
        if (this.getPrimaryKey() != null && this.getPrimaryKey().getColumns() != null && this.getPrimaryKey().getColumns().size() > 1) {
            for (i = 0; i < this.getColums().size(); ++i) {
                sb.append(this.getColums().get(i).createSQL());
                if (i == this.getColums().size() - 1) continue;
                sb.append(",");
            }
            if (this.getPrimaryKey() != null && this.getPrimaryKey().getColumns() != null && !this.getPrimaryKey().getColumns().isEmpty()) {
                sb.append(",");
                sb.append(this.getPrimaryKey().createSQL());
            }
        } else {
            for (i = 0; i < this.getColums().size(); ++i) {
                sb.append(this.getColumnSQL(this.getColums().get(i)));
                if (i == this.getColums().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getForeignKeys() != null && !this.getForeignKeys().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getForeignKeys().size(); ++i) {
                sb.append(this.getForeignKeys().get(i).createSQL());
                if (i == this.getForeignKeys().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getConstraints().size(); ++i) {
                sb.append(this.getConstraints().get(i).createSQL());
                if (i == this.getConstraints().size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append(");\n");
        ArrayList<String> result = new ArrayList<String>();
        result.add(sb.toString());
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            for (int i2 = 0; i2 < this.getIndexKeys().size(); ++i2) {
                result.add(this.getIndexKeys().get(i2).createSQL());
            }
        }
        return result;
    }

    private String getColumnSQL(SdAbstractColumnContent col) {
        StringBuilder sb = new StringBuilder();
        sb.append(col.getName());
        sb.append(" " + col.getType());
        if (col.getLength() != null) {
            sb.append("(" + col.getLength() + ") ");
        }
        if (col.isPrimary()) {
            sb.append(" PRIMARY KEY ");
        }
        if (col.isAutoIncrement() && "INTEGER".equalsIgnoreCase(col.getType())) {
            sb.append(" AUTOINCREMENT ");
        }
        if (col.isNotNull()) {
            sb.append(" NOT NULL ");
        }
        if (col.getDefault() != null) {
            if (col.getDefault() instanceof Number) {
                sb.append(" DEFAULT " + col.getDefault());
            } else {
                sb.append(" DEFAULT '" + col.getDefault() + "'");
            }
        }
        if (this.converterExtensions() != null) {
            sb.append(" " + this.converterExtensions());
        }
        return sb.toString();
    }
}

