/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update.impl.sqlserver;

import java.util.List;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.db.update.SdAbstractColumnContent;
import org.mirrentools.sd.models.db.update.SdBasicTableContent;

public class SdTableContentBySqlServer
extends SdBasicTableContent {
    @Override
    public List<String> createSQL() {
        List<String> result = super.createSQL();
        if (!SdUtil.isNullOrEmpty(this.getRemark())) {
            result.add(this.getTableRemarks());
        }
        for (int i = 0; i < this.getColums().size(); ++i) {
            SdAbstractColumnContent col = this.getColums().get(i);
            if (SdUtil.isNullOrEmpty(col.getRemark())) continue;
            result.add(this.getColomnRemarks(col.getName(), col.getRemark()));
        }
        return result;
    }

    @Override
    public String deleteSQL() {
        return " DROP TABLE " + this.getTableName() + ";";
    }

    private String getTableRemarks() {
        StringBuilder result = new StringBuilder();
        result.append(" EXEC sp_addextendedproperty ");
        result.append(String.format("@name = N'MS_Description', @value = '%s',", this.getRemark()));
        result.append(String.format("@level0type = N'Schema', @level0name = '%s',", this.getSchema() == null ? "dbo" : this.getSchema()));
        result.append(String.format("@level1type = N'Table', @level1name = '%s';", this.getTableName()));
        return result.toString();
    }

    private String getColomnRemarks(String colName, String remark) {
        StringBuilder result = new StringBuilder();
        result.append(" EXEC sp_addextendedproperty ");
        result.append(String.format("@name = N'MS_Description', @value = '%s',", remark));
        result.append(String.format("@level0type = N'Schema', @level0name = '%s',", this.getSchema() == null ? "dbo" : this.getSchema()));
        result.append(String.format("@level1type = N'Table', @level1name = '%s',", this.getTableName()));
        result.append(String.format("@level2type = N'Column', @level2name = '%s';", colName));
        return result.toString();
    }
}

