/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.options;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;

public class SdDatabaseOptions {
    public static final int DEFAULT_LOGIN_TIMEOUTS_SECONDS = 60;
    private int loginTimeout = 60;
    private String driverClass;
    private String url;
    private String user;
    private String password;
    private String schema;
    private Map<String, Object> extensions;

    public SdDatabaseOptions(String driverClass, String url) {
        this.driverClass = driverClass;
        this.url = url;
    }

    public SdDatabaseOptions(String driverClass, String url, String user, String password) {
        this.driverClass = driverClass;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public SdDatabaseOptions(int loginTimeout, String driverClass, String url, String user, String password) {
        this.loginTimeout = loginTimeout;
        this.driverClass = driverClass;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public SdDatabaseOptions setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
        return this;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public SdDatabaseOptions setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public SdDatabaseOptions setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public SdDatabaseOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SdDatabaseOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SdDatabaseOptions setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdDatabaseOptions addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.extensions.put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdDatabaseOptions setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SdDatabaseOptions:\n");
        result.append("  \u2523\u2501loginTimeout= " + this.getLoginTimeout() + "\n");
        result.append("  \u2523\u2501driverClass= " + this.getDriverClass() + "\n");
        result.append("  \u2523\u2501url= " + this.getUrl() + "\n");
        result.append("  \u2523\u2501schema= " + this.getSchema() + "\n");
        result.append("  \u2523\u2501user= " + this.getUser() + "\n");
        result.append("  \u2523\u2501password= " + this.getPassword() + "\n");
        result.append("  \u2517\u2501extensions= " + this.getExtensions());
        return result.toString();
    }
}

