package org.mirrentools.sd.constant;

/**
 * SQL相关的常量
 * 
 * @author <a href="http://mirrentools.org">Mirren</a>
 *
 */
public interface SQL {
	/** 数据类型 java_object */
	public final static String JAVA_OBJECT = "JAVA_OBJECT";
	/** 数据类型 null */
	public final static String NULL = "NULL";

	/** 数据类型 bool */
	public final static String BOOL = "BOOL";
	/** 数据类型 boolean */
	public final static String BOOLEAN = "BOOLEAN";

	/** 数据类型 bit */
	public final static String BIT = "BIT";
	/** 数据类型 tinyint */
	public final static String TINYINT = "TINYINT";
	/** 数据类型 SMALLINT */
	public final static String SMALLINT = "SMALLINT";
	/** 数据类型 int2 */
	public final static String INT2 = "INT2";
	/** 数据类型 int */
	public final static String INT = "INT";
	/** 数据类型 integer */
	public final static String INTEGER = "INTEGER";
	/** 数据类型 int4 */
	public final static String INT4 = "INT4";
	/** 数据类型 bigint */
	public final static String BIGINT = "BIGINT";
	/** 数据类型 int8 */
	public final static String INT8 = "INT8";
	/** 数据类型 float */
	public final static String FLOAT = "FLOAT";
	/** 数据类型 real */
	public final static String REAL = "REAL";
	/** 数据类型 double */
	public final static String DOUBLE = "DOUBLE";
	/** 数据类型 numeric */
	public final static String NUMERIC = "NUMERIC";
	/** 数据类型 decimal */
	public final static String DECIMAL = "DECIMAL";
	/** 数据类型 money */
	public final static String MONEY = "MONEY";

	/** 数据类型 smallserial 自动增长的2字节整数 */
	public final static String SMALLSERIAL = "SMALLSERIAL";
	/** 数据类型 serial2 自动增长的2字节整数 */
	public final static String SERIAL2 = "SERIAL2";
	/** 数据类型 serial 自动增长的4字节整数 */
	public final static String SERIAL = "SERIAL";
	/** 数据类型 serial4 自动增长的4字节整数 */
	public final static String SERIAL4 = "SERIAL4";
	/** 数据类型 bigserial 自动增长的8字节整数 */
	public final static String BIGSERIAL = "BIGSERIAL";
	/** 数据类型 serial8 自动增长的8字节整数 */
	public final static String SERIAL8 = "SERIAL8";

	/** 数据类型 char */
	public final static String CHAR = "CHAR";
	/** 数据类型 varchar */
	public final static String VARCHAR = "VARCHAR";
	/** 数据类型 varchar2 */
	public final static String VARCHAR2 = "VARCHAR2";
	/** 数据类型 longvarchar */
	public final static String LONGVARCHAR = "LONGVARCHAR";
	/** 数据类型 clob */
	public final static String CLOB = "CLOB";
	/** 数据类型 text */
	public final static String TEXT = "TEXT";
	/** 数据类型 tinytext */
	public final static String TINYTEXT = "TINYTEXT";
	/** 数据类型 mediumtext */
	public final static String MEDIUMTEXT = "MEDIUMTEXT";
	/** 数据类型 longtext */
	public final static String LONGTEXT = "LONGTEXT";

	/** 数据类型 nchar */
	public final static String NCHAR = "NCHAR";
	/** 数据类型 nvarchar */
	public final static String NVARCHAR = "NVARCHAR";
	/** 数据类型 longnvarchar */
	public final static String LONGNVARCHAR = "LONGNVARCHAR";
	/** 数据类型 nclob */
	public final static String NCLOB = "NCLOB";

	/** 数据类型 character */
	public final static String CHARACTER = "CHARACTER";
	/** 数据类型 CHARACTER VARYING */
	public final static String CHARACTER_VARYING = "CHARACTER VARYING";
	/** 数据类型 graphic */
	public final static String GRAPHIC = "GRAPHIC";
	/** 数据类型 vargraphic */
	public final static String VARGRAPHIC = "VARGRAPHIC";

	/** 数据类型 datetime */
	public final static String DATETIME = "DATETIME";
	/** 数据类型 date */
	public final static String DATE = "DATE";
	/** 数据类型 time */
	public final static String TIME = "TIME";
	/** 数据类型 timestamp */
	public final static String TIMESTAMP = "TIMESTAMP";
	/** 数据类型 time_with_timezone */
	public final static String TIME_WITH_TIMEZONE = "TIME_WITH_TIMEZONE";
	/** 数据类型 timestamp_with_timezone */
	public final static String TIMESTAMP_WITH_TIMEZONE = "TIMESTAMP_WITH_TIMEZONE";

	/** 数据类型 binary */
	public final static String BINARY = "BINARY";
	/** 数据类型 varbinary */
	public final static String VARBINARY = "VARBINARY";
	/** 数据类型 longvarbinary */
	public final static String LONGVARBINARY = "LONGVARBINARY";
	/** 数据类型 blob */
	public final static String BLOB = "BLOB";

	/** 数据类型 json */
	public final static String JSON = "JSON";
	/** 数据类型 jsonb */
	public final static String JSONB = "JSONB";
	/** 数据类型 xml */
	public final static String XML = "XML";
	/** 数据类型 sqlxml */
	public final static String SQLXML = "SQLXML";
	/** 数据类型 set */
	public final static String SET = "SET";
	/** 数据类型 enum */
	public final static String ENUM = "ENUM";

	/** 数据类型 ref */
	public final static String REF = "REF";
	/** 数据类型 datalink */
	public final static String DATALINK = "DATALINK";
	/** 数据类型 rowid */
	public final static String ROWID = "ROWID";
	/** 数据类型 ref_cursor */
	public final static String REF_CURSOR = "REF_CURSOR";
	/** 数据类型 other */
	public final static String OTHER = "OTHER";

}
