/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl;

import org.mirrentools.sd.ScrewDriver;
import org.mirrentools.sd.ScrewDriverCode;
import org.mirrentools.sd.ScrewDriverSQL;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.impl.ScrewDriverCodeImpl;
import org.mirrentools.sd.impl.ScrewDriverSqlImpl;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdDatabase;
import org.mirrentools.sd.options.ScrewDriverOptions;

public class ScrewDriverImpl
extends ScrewDriver {
    private ScrewDriverCode codeUtil;
    private ScrewDriverSQL sqlUtil;

    public ScrewDriverImpl(ScrewDriverOptions options) {
        SdUtil.requireNonNull(options, "The ScrewDriverOptions cannot be null , you can new ScrewDriverOptions");
        this.codeUtil = new ScrewDriverCodeImpl(options);
        this.sqlUtil = new ScrewDriverSqlImpl(options);
    }

    @Override
    public boolean createCode(SdBean bean) {
        return this.codeUtil.execute(bean);
    }

    @Override
    public boolean createCode(SdClassContent classContent) {
        return this.codeUtil.execute(classContent);
    }

    @Override
    public boolean createDatabase(SdDatabase database) {
        return this.sqlUtil.createDatabase(database);
    }

    @Override
    public boolean createTable(SdBean bean) {
        return this.sqlUtil.createTable(bean);
    }

    @Override
    public SdClassContent readTable(String tableName) {
        return this.sqlUtil.readTable(tableName);
    }

    @Override
    public boolean updateTable(SdBean bean) {
        return this.sqlUtil.alterTable(bean);
    }

    @Override
    public boolean deleteTable(SdBean bean) {
        return this.sqlUtil.deleteTable(bean);
    }
}

