/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdTableContentConverter;
import org.mirrentools.sd.converter.SdTypeConverter;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdColumn;
import org.mirrentools.sd.models.SdSequence;
import org.mirrentools.sd.models.db.update.SdAbstractColumnContent;
import org.mirrentools.sd.models.db.update.SdAbstractConstraintContent;
import org.mirrentools.sd.models.db.update.SdAbstractForeignKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractIndexKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractPrimaryKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractSequenceContent;
import org.mirrentools.sd.models.db.update.SdAbstractTableContent;

public abstract class SdAbstractTableContentConverter
implements SdTableContentConverter {
    private String engine;
    private String characterSet;
    private String collate;
    private String schemas;
    private SdTypeConverter typeConverter;
    private Map<String, Object> extensions;

    public SdAbstractTableContentConverter(SdTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public abstract SdAbstractTableContent newTableContent(SdBean var1);

    public abstract SdAbstractColumnContent newColumnContent(SdColumn var1);

    public abstract SdAbstractPrimaryKeyContent newPrimaryKeyContent(SdColumn var1);

    public abstract SdAbstractIndexKeyContent newIndexKeyContent(SdColumn var1);

    public abstract SdAbstractForeignKeyContent newForeignKeyContent(SdColumn var1);

    public abstract SdAbstractConstraintContent newConstraintContent(SdColumn var1);

    public abstract SdAbstractSequenceContent newSequenceContent(SdSequence var1);

    @Override
    public SdAbstractTableContent converter(SdBean bean) {
        ArrayList<SdColumn> foreigns;
        ArrayList<SdColumn> indexs;
        ArrayList<SdColumn> primarys;
        ArrayList<SdColumn> columns;
        SdAbstractTableContent result = this.newTableContent(bean);
        if (result.getTableName() == null) {
            result.setTableName(SdUtil.toUnderScoreCase(bean.getName()));
        }
        if (result.getRemark() == null) {
            result.setRemark(bean.getRemark());
        }
        if (result.getSchema() == null) {
            result.setSchema(bean.getSchema());
        }
        if (result.getOwner() == null) {
            result.setOwner(bean.getOwner());
        }
        if (result.getTablespace() == null) {
            result.setTablespace(bean.getTablespace());
        }
        if (result.getIndexspace() == null) {
            result.setIndexspace(bean.getIndexspace());
        }
        if (result.getCompressable() == null) {
            result.setCompressable(bean.isCompressable());
        }
        if (bean.getColumns() != null) {
            columns = new ArrayList<SdColumn>();
            primarys = new ArrayList<SdColumn>();
            indexs = new ArrayList<SdColumn>();
            foreigns = new ArrayList<SdColumn>();
            for (SdColumn col : bean.getColumns()) {
                columns.add(col);
                if (col.isPrimary()) {
                    primarys.add(col);
                }
                if (col.isIndex()) {
                    indexs.add(col);
                }
                if (!col.isForeignKey()) continue;
                foreigns.add(col);
            }
        } else {
            throw new ScrewDriverException("SdBean \u4e2d getColumns() \u4e3a null \u5982\u679c\u521b\u5efa\u8868\u6ca1\u6709\u5217\u5c5e\u6027\u6ca1\u6709\u4efb\u4f55\u610f\u4e49");
        }
        this.converterColumns(columns, result);
        this.converterPrimaryKey(primarys, result);
        this.converterIndexKey(indexs, result);
        this.converterForeignKey(foreigns, result);
        this.converterConstraintContent(columns, result);
        this.converterSequenceContent(bean.getSequences(), result);
        this.converterExtensions(bean, result);
        return result;
    }

    public void converterColumns(List<SdColumn> columns, SdAbstractTableContent result) {
        for (SdColumn col : columns) {
            SdAbstractColumnContent column = this.newColumnContent(col);
            column.setName(col.getName());
            column.setRemark(col.getRemark());
            column.setType(this.getTypeConverter().converter(col.getType()));
            if (col.getLength() != null) {
                if (col.getPrecision() != null) {
                    column.setLength(col.getLength() + "," + col.getPrecision());
                } else {
                    column.setLength(Integer.toString(col.getLength()));
                }
            }
            column.setDefault(col.getDefaults());
            column.setPrimary(col.isPrimary());
            column.setNotNull(!col.isNullable());
            column.setAutoIncrement(col.isAutoIncrement());
            column.setIdentity(col.isIdentity());
            column.setIdentitySeed(col.getIdentitySeed());
            column.setIdentitySeed(col.getIdentitySeed());
            column.setUnsigned(col.isUnsigned());
            column.setExtensions(col.getExtensions());
            result.addColum(column);
        }
    }

    public void converterPrimaryKey(List<SdColumn> columns, SdAbstractTableContent result) {
        if (!columns.isEmpty()) {
            SdAbstractPrimaryKeyContent primary = null;
            for (int i = 0; i < columns.size(); ++i) {
                SdColumn col = columns.get(i);
                if (primary == null) {
                    primary = this.newPrimaryKeyContent(col);
                }
                if (primary.getName() != null && col.getPrimaryName() != null) {
                    if (!col.getPrimaryName().equals(primary.getName())) {
                        throw new ScrewDriverException("\u4e00\u5f20\u8868\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u952e\u5c5e\u6027");
                    }
                    primary.setName(col.getPrimaryName());
                }
                primary.addColumn(col.getName());
                if (col.getExtensions() == null) continue;
                for (Map.Entry<String, Object> ext : col.getExtensions().entrySet()) {
                    primary.addExtension(ext.getKey(), ext.getValue());
                }
            }
            result.setPrimaryKey(primary);
        }
    }

    public void converterIndexKey(List<SdColumn> columns, SdAbstractTableContent result) {
        if (!columns.isEmpty()) {
            LinkedHashMap<String, SdAbstractIndexKeyContent> indexs = new LinkedHashMap<String, SdAbstractIndexKeyContent>();
            for (int i = 0; i < columns.size(); ++i) {
                SdColumn col = columns.get(i);
                SdAbstractIndexKeyContent indexContent = (SdAbstractIndexKeyContent)indexs.get(col.getIndexName());
                if (indexContent == null) {
                    indexContent = this.newIndexKeyContent(col);
                    indexContent.setUnique(col.isUnique());
                    indexContent.setConcurrently(col.isConcurrently());
                    indexContent.setName(col.getIndexName());
                    indexContent.setType(col.getIndexType());
                    indexContent.setRemark(col.getIndexRemark());
                    indexContent.addColumn(col.getName());
                    indexContent.setSchema(result.getSchema());
                    indexContent.setTable(result.getTableName());
                    indexs.put(col.getIndexName(), indexContent);
                } else {
                    if (indexContent.getType() != null && col.getIndexType() != null) {
                        if (!indexContent.getType().equals(col.getIndexType())) {
                            throw new ScrewDriverException("\u5b58\u5728\u4e86\u4e24\u4e2a\u76f8\u540c\u7d22\u5f15\u540d\u5b57,\u4e0d\u540c\u7d22\u5f15\u7c7b\u578b\u7684\u5c5e\u6027");
                        }
                    } else {
                        indexContent.setType(col.getIndexType());
                    }
                    indexContent.setRemark(col.getIndexRemark());
                    indexContent.addColumn(col.getName());
                }
                if (col.getExtensions() == null) continue;
                for (Map.Entry<String, Object> ext : col.getExtensions().entrySet()) {
                    indexContent.addExtension(ext.getKey(), ext.getValue());
                }
            }
            for (Map.Entry entry : indexs.entrySet()) {
                result.addIndexKey((SdAbstractIndexKeyContent)entry.getValue());
            }
        }
    }

    public void converterForeignKey(List<SdColumn> columns, SdAbstractTableContent result) {
        if (!columns.isEmpty()) {
            LinkedHashMap<String, SdAbstractForeignKeyContent> foreigns = new LinkedHashMap<String, SdAbstractForeignKeyContent>();
            for (int i = 0; i < columns.size(); ++i) {
                SdColumn col = columns.get(i);
                if (col.getForeignReferencesTable() == null) {
                    throw new ScrewDriverException("\u5916\u952e\u5f15\u7528\u90a3\u4e2a\u8868\u7684\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                }
                SdAbstractForeignKeyContent foreign = (SdAbstractForeignKeyContent)foreigns.get(col.getForeignConstraint());
                if (foreign == null) {
                    foreign = this.newForeignKeyContent(col);
                    foreign.setConstraint(col.getForeignConstraint());
                    foreign.setReferencesDB(col.getForeignReferencesDB());
                    foreign.setReferencesTable(col.getForeignReferencesTable());
                    foreign.addReferencesColumn(col.getForeignReferencesColumn());
                    foreign.addForeignKey(col.getName());
                    foreigns.put(col.getForeignConstraint(), foreign);
                } else {
                    if (col.getForeignConstraint().equals(foreign.getConstraint()) && !col.getForeignReferencesTable().equals(foreign.getReferencesTable())) {
                        throw new ScrewDriverException("\u5b58\u5728\u4e86\u4e24\u4e2a\u76f8\u540c\u7684\u5916\u952e\u7ea6\u675f\u540d,\u4f46\u662f\u5f15\u7528\u7684\u8868\u540d\u4e0d\u60f3\u540c");
                    }
                    foreign.addForeignKey(col.getName());
                }
                if (col.getExtensions() == null) continue;
                for (Map.Entry<String, Object> ext : col.getExtensions().entrySet()) {
                    col.addExtension(ext.getKey(), ext.getValue());
                }
            }
            for (Map.Entry entry : foreigns.entrySet()) {
                result.addForeignKey((SdAbstractForeignKeyContent)entry.getValue());
            }
        }
    }

    public void converterConstraintContent(List<SdColumn> columns, SdAbstractTableContent result) {
        if (!columns.isEmpty()) {
            for (int i = 0; i < columns.size(); ++i) {
                SdColumn col = columns.get(i);
                if (col.getConstraintType() == null || col.getConstraintType() == null) continue;
                SdAbstractConstraintContent constraint = null;
                if (constraint == null) {
                    constraint = this.newConstraintContent(col);
                }
                constraint.setType(col.getConstraintType());
                constraint.setName(col.getConstraintName());
                constraint.setExp(col.getConstraintExp());
                if (col.getExtensions() != null) {
                    for (Map.Entry<String, Object> ext : col.getExtensions().entrySet()) {
                        constraint.addExtension(ext.getKey(), ext.getValue());
                    }
                }
                result.addConstraint(constraint);
            }
        }
    }

    public void converterSequenceContent(List<SdSequence> sequences, SdAbstractTableContent result) {
        if (sequences != null && !sequences.isEmpty()) {
            for (SdSequence seq : sequences) {
                if (seq.getName() == null) continue;
                SdAbstractSequenceContent content = this.newSequenceContent(seq);
                if (content == null) {
                    return;
                }
                content.setName(seq.getName());
                content.setDataType(seq.getDataType());
                content.setMinValue(seq.getMinValue());
                content.setMaxValue(seq.getMaxValue());
                content.setIncrementBy(seq.getIncrementBy());
                content.setStart(seq.getStart());
                content.setRestart(seq.getRestart());
                content.setCache(seq.getCache());
                content.setCycle(seq.getCycle());
                content.setOwnedBy(seq.getOwnedBy());
                content.setExtensions(seq.getExtensions());
                result.addSequence(content);
            }
        }
    }

    public void converterExtensions(SdBean bean, SdAbstractTableContent result) {
        result.setExtensions(bean.getExtensions());
    }

    @Override
    public String getEngine() {
        return this.engine;
    }

    @Override
    public SdTableContentConverter setEngine(String engine) {
        this.engine = engine;
        return this;
    }

    @Override
    public String getCharacterSet() {
        return this.characterSet;
    }

    @Override
    public SdTableContentConverter setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    @Override
    public String getCollate() {
        return this.collate;
    }

    @Override
    public SdTableContentConverter setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    @Override
    public String getSchemas() {
        return this.schemas;
    }

    @Override
    public SdTableContentConverter setSchemas(String schemas) {
        this.schemas = schemas;
        return this;
    }

    @Override
    public SdTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public SdTableContentConverter setTypeConverter(SdTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        return this;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public Object getExtension(String key) {
        if (this.getExtensions() == null) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    @Override
    public SdTableContentConverter putExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    @Override
    public SdTableContentConverter setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }
}

