/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.mirrentools.sd.ScrewDriverDbUtil;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.ScrewDriverSQL;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdDatabaseContentConverter;
import org.mirrentools.sd.converter.SdTableContentConverter;
import org.mirrentools.sd.converter.SdTableToClassConverter;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdDatabase;
import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;
import org.mirrentools.sd.models.db.update.SdAbstractTableContent;
import org.mirrentools.sd.options.ScrewDriverOptions;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class ScrewDriverSqlImpl
implements ScrewDriverSQL {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private SdDatabaseOptions databaseOptions;
    private ScrewDriverDbUtil dbUtil;
    private SdTableContentConverter converter;
    private SdTableToClassConverter classConverter;
    private SdDatabaseContentConverter databaseConverter;
    private Map<String, Object> extensions;

    public ScrewDriverSqlImpl(ScrewDriverOptions options) {
        this.databaseOptions = options.getDatabaseOptions();
        this.dbUtil = options.getDbUtil();
        this.converter = options.getTableConverter();
        this.classConverter = options.getClassConverter();
        this.databaseConverter = options.getDatabaseConverter();
        this.extensions = options.getExtensions();
    }

    @Override
    public boolean createDatabase(SdDatabase database) {
        SdUtil.requireNonNull(this.databaseConverter, "This database does not support database creation or SdDatabaseContentConverter options is null");
        SdAbstractDatabaseContent dbContent = this.databaseConverter.converter(database);
        if (dbContent != null) {
            try {
                return this.dbUtil.createDatabase(dbContent);
            }
            catch (Exception e) {
                throw new ScrewDriverException(e);
            }
        }
        return false;
    }

    @Override
    public boolean createTable(SdBean bean) {
        try {
            SdAbstractTableContent content = this.converter.converter(bean);
            return this.dbUtil.createTable(content);
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
    }

    @Override
    public SdClassContent readTable(String tableName) {
        SdUtil.requireNonNull(this.classConverter, "This SdTableToClassConverter options is null");
        try {
            return this.classConverter.converter(this.dbUtil.getSdTable(tableName));
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
    }

    @Override
    public boolean alterTable(SdBean bean) {
        try {
            SdAbstractTableContent content = this.converter.converter(bean);
            return this.dbUtil.updateTable(content);
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
    }

    @Override
    public boolean deleteTable(SdBean bean) {
        try {
            SdAbstractTableContent content = this.converter.converter(bean);
            return this.dbUtil.deleteTable(content);
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
    }

    @Override
    public SdDatabaseOptions getDatabaseOptions() {
        return this.databaseOptions;
    }

    @Override
    public ScrewDriverSqlImpl setDatabaseOptions(SdDatabaseOptions dbOptions) {
        this.databaseOptions = dbOptions;
        return this;
    }

    @Override
    public ScrewDriverDbUtil getDbUtil() {
        return this.dbUtil;
    }

    @Override
    public ScrewDriverSqlImpl setDbUtil(ScrewDriverDbUtil dbUtil) {
        this.dbUtil = dbUtil;
        return this;
    }

    @Override
    public SdTableContentConverter getConverter() {
        return this.converter;
    }

    @Override
    public ScrewDriverSqlImpl setConverter(SdTableContentConverter converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public ScrewDriverSqlImpl addExtension(String key, Object value) {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        if (this.getExtensions() == null) {
            this.setExtensions((Map)new LinkedHashMap());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    @Override
    public Map<String, Object> getExtensions() {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        return this.extensions;
    }

    @Override
    public ScrewDriverSqlImpl setExtensions(Map<String, Object> extensions) {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        return "ScrewDriverSqlImpl [databaseOptions=" + this.databaseOptions + ", dbUtil=" + this.dbUtil + ", converter=" + this.converter + ", extensions=" + this.extensions + "]";
    }
}

