/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl.dbutil;

import java.io.File;
import java.sql.Connection;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.impl.dbutil.SdAbstractDbUtil;
import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class SdDbUtilSqliteImpl
extends SdAbstractDbUtil {
    public SdDbUtilSqliteImpl(SdDatabaseOptions options) {
        super(options);
    }

    @Override
    public boolean existDatabase(String dbName) throws Exception {
        return this.existDatabase(this.getBaseUrlConfig(), dbName);
    }

    @Override
    public boolean existDatabase(SdDatabaseOptions config, String dbName) throws Exception {
        int index = config.getUrl().indexOf(":", config.getUrl().indexOf(":") + 1) + 1;
        String name = dbName.trim().endsWith(".db") ? dbName.trim() : dbName + ".db";
        String url = config.getUrl().substring(index) + name;
        return new File(url).exists();
    }

    @Override
    public boolean createDatabase(SdAbstractDatabaseContent content) throws Exception {
        return this.createDatabase(this.getBaseUrlConfig(), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createDatabase(SdDatabaseOptions config, SdAbstractDatabaseContent content) throws Exception {
        boolean urlHasDb = config.getUrl().trim().endsWith(".db");
        if (!urlHasDb) {
            if (!config.getUrl().trim().endsWith("/")) {
                config.setUrl(config.getUrl().trim() + "/");
            }
            config.setUrl(config.getUrl().trim() + content.getDatabaseName() + ".db");
        }
        Connection connection = null;
        try {
            connection = this.getConnection(config);
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public boolean updateDatabase(SdDatabaseOptions config, SdAbstractDatabaseContent content) throws Exception {
        throw new ScrewDriverException("The SQLite DB in ScrewDriver does not support update,you can modify it through the SQLite client ");
    }
}

