/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.options;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mirrentools.sd.ScrewDriverDbUtil;
import org.mirrentools.sd.ScrewDriverTemplateEngine;
import org.mirrentools.sd.SdType;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdBasicClassConverter;
import org.mirrentools.sd.converter.SdBasicTypeConverter;
import org.mirrentools.sd.converter.SdClassConverter;
import org.mirrentools.sd.converter.SdDatabaseContentConverter;
import org.mirrentools.sd.converter.SdTableContentConverter;
import org.mirrentools.sd.converter.SdTableToClassConverter;
import org.mirrentools.sd.converter.SdTemplateContentConverter;
import org.mirrentools.sd.converter.impl.SdTemplateContentConverterDefaultImpl;
import org.mirrentools.sd.enums.SdTypeMode;
import org.mirrentools.sd.impl.ScrewDriverTemplateFreeMarkerImpl;
import org.mirrentools.sd.options.SdDatabaseOptions;
import org.mirrentools.sd.options.def.ScrewDriverDB2Options;
import org.mirrentools.sd.options.def.ScrewDriverMySqlOptions;
import org.mirrentools.sd.options.def.ScrewDriverOracleOptions;
import org.mirrentools.sd.options.def.ScrewDriverPostgreSqlOptions;
import org.mirrentools.sd.options.def.ScrewDriverSqlServerOptions;
import org.mirrentools.sd.options.def.ScrewDriverSqliteOptions;

public class ScrewDriverOptions {
    private SdDatabaseOptions databaseOptions;
    private String outputPath = SdUtil.getUserDir();
    private String codeFormat = "UTF-8";
    private SdClassConverter beanConverter = new SdBasicClassConverter(new SdBasicTypeConverter("Object", SdType.getDictionary(SdTypeMode.JAVA)));
    private SdTemplateContentConverter templateContentConverter = new SdTemplateContentConverterDefaultImpl();
    private ScrewDriverTemplateEngine templateEngine = new ScrewDriverTemplateFreeMarkerImpl();
    private ScrewDriverDbUtil dbUtil;
    private SdTableContentConverter tableConverter;
    private SdTableToClassConverter classConverter;
    private SdDatabaseContentConverter databaseConverter;
    private Map<String, Object> extensions;

    public ScrewDriverOptions() {
    }

    public ScrewDriverOptions(ScrewDriverOptions options) {
        this.wrap(options);
    }

    public ScrewDriverOptions(SdDatabaseOptions databaseOptions) {
        this.init(databaseOptions);
    }

    private void init(SdDatabaseOptions databaseOptions) {
        String groupId = databaseOptions.getDriverClass();
        if (groupId.contains("mysql")) {
            this.wrap(new ScrewDriverMySqlOptions(databaseOptions));
        } else if (groupId.contains("postgresql")) {
            this.wrap(new ScrewDriverPostgreSqlOptions(databaseOptions));
        } else if (groupId.contains("db2")) {
            this.wrap(new ScrewDriverDB2Options(databaseOptions));
        } else if (groupId.contains("oracle")) {
            this.wrap(new ScrewDriverOracleOptions(databaseOptions));
        } else if (groupId.contains("sqlserver")) {
            this.wrap(new ScrewDriverSqlServerOptions(databaseOptions));
        } else if (groupId.contains("sqlite")) {
            this.wrap(new ScrewDriverSqliteOptions(databaseOptions));
        }
    }

    public void wrap(ScrewDriverOptions options) {
        this.setDatabaseOptions(options.getDatabaseOptions());
        this.setOutputPath(options.getOutputPath());
        this.setCodeFormat(options.getCodeFormat());
        this.setExtensions(options.getExtensions());
        this.setBeanConverter(options.getBeanConverter());
        this.setTableConverter(options.getTableConverter());
        this.setClassConverter(options.getClassConverter());
        this.setDatabaseConverter(options.getDatabaseConverter());
        this.setTemplateContentConverter(options.getTemplateContentConverter());
        this.setTemplateEngine(options.getTemplateEngine());
        this.setDbUtil(options.getDbUtil());
    }

    public SdDatabaseOptions getDatabaseOptions() {
        return this.databaseOptions;
    }

    public ScrewDriverOptions setDatabaseOptions(SdDatabaseOptions databaseOptions) {
        this.databaseOptions = databaseOptions;
        return this;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public ScrewDriverOptions setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    public String getCodeFormat() {
        return this.codeFormat;
    }

    public ScrewDriverOptions setCodeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
        return this;
    }

    public SdClassConverter getBeanConverter() {
        return this.beanConverter;
    }

    public ScrewDriverOptions setBeanConverter(SdClassConverter beanConverter) {
        this.beanConverter = beanConverter;
        return this;
    }

    public SdTemplateContentConverter getTemplateContentConverter() {
        return this.templateContentConverter;
    }

    public ScrewDriverOptions setTemplateContentConverter(SdTemplateContentConverter templateContentConverter) {
        this.templateContentConverter = templateContentConverter;
        return this;
    }

    public ScrewDriverTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public ScrewDriverOptions setTemplateEngine(ScrewDriverTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public ScrewDriverDbUtil getDbUtil() {
        return this.dbUtil;
    }

    public ScrewDriverOptions setDbUtil(ScrewDriverDbUtil dbUtil) {
        this.dbUtil = dbUtil;
        return this;
    }

    public SdTableContentConverter getTableConverter() {
        return this.tableConverter;
    }

    public ScrewDriverOptions setTableConverter(SdTableContentConverter tableConverter) {
        this.tableConverter = tableConverter;
        return this;
    }

    public SdTableToClassConverter getClassConverter() {
        return this.classConverter;
    }

    public ScrewDriverOptions setClassConverter(SdTableToClassConverter classConverter) {
        this.classConverter = classConverter;
        return this;
    }

    public SdDatabaseContentConverter getDatabaseConverter() {
        return this.databaseConverter;
    }

    public ScrewDriverOptions setDatabaseConverter(SdDatabaseContentConverter databaseConverter) {
        this.databaseConverter = databaseConverter;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public ScrewDriverOptions addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.extensions.put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public ScrewDriverOptions setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ScrewDriverOptions:\n");
        result.append("  \u2523\u2501databaseOptions= " + this.getDatabaseOptions() + "\n");
        result.append("  \u2523\u2501outputPath= " + this.getOutputPath() + "\n");
        result.append("  \u2523\u2501codeFormat= " + this.getCodeFormat() + "\n");
        result.append("  \u2523\u2501beanConverter= " + (this.getBeanConverter() == null ? "null" : this.getBeanConverter().getClass().getName()) + "\n");
        result.append("  \u2523\u2501templateContentConverter= " + (this.getTemplateContentConverter() == null ? "null" : this.getTemplateContentConverter().getClass().getName()) + "\n");
        result.append("  \u2523\u2501templateEngine= " + (this.getTemplateEngine() == null ? "null" : this.getTemplateEngine().getClass().getName()) + "\n");
        result.append("  \u2523\u2501dbUtil= " + (this.getDbUtil() == null ? "null" : this.getDbUtil().getClass().getName()) + "\n");
        result.append("  \u2523\u2501tableConverter= " + (this.getTableConverter() == null ? "null" : this.getTableConverter().getClass().getName()) + "\n");
        result.append("  \u2523\u2501databaseConverter= " + (this.getDatabaseConverter() == null ? "null" : this.getDatabaseConverter().getClass().getName()) + "\n");
        result.append("  \u2517\u2501extensions= " + this.getExtensions());
        return result.toString();
    }
}

