/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.common.SdIoUtil;
import org.mirrentools.sd.common.SdUtil;

public class SdTemplatePathUtil {
    private static final Logger LOG = Logger.getLogger(SdTemplatePathUtil.class.getName());
    private static final String DEFAULT_PATH = "SdTemplates/";

    public static String getPath(String path) {
        if (SdUtil.isNullOrEmpty(path)) {
            return SdTemplatePathUtil.getPath();
        }
        if (new File(path).exists()) {
            return path;
        }
        String userdir = SdUtil.getUserDir() + path;
        if (new File(userdir).exists()) {
            return userdir;
        }
        String userdirTemplates = SdUtil.getUserDir() + DEFAULT_PATH + path;
        File file = new File(userdirTemplates);
        if (!file.exists()) {
            boolean res = file.mkdirs();
            LOG.info("create " + userdirTemplates + " -->" + res);
        }
        return userdirTemplates;
    }

    public static String getPath() {
        URL url = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_PATH);
        if (new File(url.getFile()).exists()) {
            return url.getFile();
        }
        if (new File(DEFAULT_PATH).exists()) {
            return DEFAULT_PATH;
        }
        String userdir = SdUtil.getUserDir() + DEFAULT_PATH;
        File file = new File(userdir);
        if (!file.exists()) {
            boolean res = file.mkdirs();
            LOG.info("create " + userdir + " -->" + res);
        }
        return userdir;
    }

    public static File getFile(String fileName) {
        return SdTemplatePathUtil.getFile(null, fileName);
    }

    public static File getFile(String path, String fileName) {
        File file;
        SdUtil.requireNonNull(fileName, "\u6a21\u677f\u6587\u4ef6\u7684\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        String dir = SdTemplatePathUtil.getPath(path);
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if ((file = new File(dir + fileName)).exists()) {
            return file;
        }
        File file1 = new File(dir + DEFAULT_PATH + fileName);
        if (file1.exists()) {
            return file1;
        }
        InputStream inputStream = null;
        if (path == null) {
            path = "";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        try {
            String jarPath = SdTemplatePathUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            URL url = new URL("jar:file:" + jarPath + "!/" + path + fileName);
            LOG.info(String.format("Find template from %s", url));
            inputStream = url.openStream();
            LOG.info(String.format("Copy template \nfrom: %s \nto: %s", url.toString(), file.toString()));
        }
        catch (IOException e) {
            try {
                String jarPath = SdTemplatePathUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                URL url = new URL("jar:file:" + jarPath + "!/" + DEFAULT_PATH + path + fileName);
                LOG.info(String.format("Find template from %s", url));
                inputStream = url.openStream();
                LOG.info(String.format("Copy template \nfrom: %s \nto: %s", url.toString(), file.toString()));
            }
            catch (IOException e1) {
                try {
                    String jarPath = SdTemplatePathUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                    URL url = new URL("jar:file:" + jarPath + "!/" + DEFAULT_PATH + fileName);
                    LOG.info(String.format("Find template from %s", url));
                    inputStream = url.openStream();
                    LOG.info(String.format("Copy template \nfrom: %s \nto: %s", url.toString(), file.toString()));
                }
                catch (IOException e2) {
                    throw new ScrewDriverException(String.format("Template %s was not found", fileName));
                }
            }
        }
        FileOutputStream outputStream = null;
        try {
            boolean newFile;
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!(newFile = file.createNewFile())) {
                return null;
            }
            outputStream = new FileOutputStream(file);
            SdIoUtil.writeAndClose(inputStream, outputStream);
            return file;
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
    }
}

