/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.converter.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdTemplateContentConverter;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdTemplate;
import org.mirrentools.sd.models.SdTemplateAttribute;
import org.mirrentools.sd.models.SdTemplateContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class SdTemplateContentConverterDefaultImpl
implements SdTemplateContentConverter {
    @Override
    public Map<String, SdTemplateContent> converter(SdClassContent bean, SdDatabaseOptions databaseOptions, Map<String, SdTemplate> templates) {
        LinkedHashMap<String, SdTemplateContent> result = new LinkedHashMap<String, SdTemplateContent>();
        for (Map.Entry<String, SdTemplate> entry : templates.entrySet()) {
            SdTemplateContent content = new SdTemplateContent();
            this.converterInfo(bean, databaseOptions, entry.getValue(), content);
            this.converterAttribute(bean, databaseOptions, entry.getValue(), content);
            this.converterExtensions(bean, databaseOptions, entry.getValue(), content);
            result.put(entry.getKey(), content);
        }
        return result;
    }

    public void converterInfo(SdClassContent bean, SdDatabaseOptions databaseOptions, SdTemplate template, SdTemplateContent result) {
        result.setPath(template.getPath());
        result.setFile(template.getFile());
        result.setOverride(template.isOverride());
        result.setSourceFolder(template.getSourceFolder());
        result.setPackageName(template.getPackageName());
        result.setClassName(template.getClassName());
        result.setLowerName(template.getClassName().toLowerCase());
        result.setUpperName(template.getClassName().toUpperCase());
        result.setCamelName(SdUtil.toCamelCase(template.getClassName()));
        result.setHyphenName(SdUtil.toHyphenCase(template.getClassName()));
        result.setUnderScoreName(SdUtil.toUnderScoreCase(template.getClassName()));
        result.setSuffix(template.getSuffix());
    }

    public void converterAttribute(SdClassContent bean, SdDatabaseOptions databaseOptions, SdTemplate template, SdTemplateContent result) {
        if (template.getAttributes() != null) {
            for (SdTemplateAttribute attribute : template.getAttributes()) {
                this.replaceTemplateAttributePlaceholder(template, databaseOptions, attribute);
                result.putAttr(attribute);
            }
        }
    }

    public void converterExtensions(SdClassContent bean, SdDatabaseOptions databaseOptions, SdTemplate template, SdTemplateContent result) {
        result.setExtensions(template.getExtensions());
    }

    public void replaceTemplateAttributePlaceholder(SdTemplate template, SdDatabaseOptions databaseOptions, SdTemplateAttribute attribute) {
        String value;
        String lowerCase = template.getClassName().toLowerCase();
        String upperCase = template.getClassName().toUpperCase();
        String pascalCase = SdUtil.toPascalCase(template.getClassName());
        String camelCase = SdUtil.toCamelCase(template.getClassName());
        String hyphenCase = SdUtil.toHyphenCase(template.getClassName());
        String scoreCase = SdUtil.toUnderScoreCase(template.getClassName());
        if (attribute.getValue() != null) {
            value = attribute.getValue().replace("{lo}", lowerCase).replace("{up}", upperCase).replace("{c}", camelCase).replace("{p}", pascalCase).replace("{u}", scoreCase).replace("{h}", hyphenCase);
            attribute.setValue(value);
        }
        if (attribute.getDescribe() != null) {
            value = attribute.getDescribe().replace("{lo}", lowerCase).replace("{up}", upperCase).replace("{c}", camelCase).replace("{p}", pascalCase).replace("{u}", scoreCase).replace("{h}", hyphenCase);
            attribute.setDescribe(value);
        }
    }
}

