/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl.dbutil;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mirrentools.sd.impl.dbutil.SdAbstractDbUtil;
import org.mirrentools.sd.models.db.query.SdTableAttribute;
import org.mirrentools.sd.models.db.query.SdTableIndexKeyAttribute;
import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class SdDbUtilMySqlImpl
extends SdAbstractDbUtil {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    public SdDbUtilMySqlImpl(SdDatabaseOptions options) {
        super(options);
    }

    @Override
    public boolean existDatabase(String dbName) throws Exception {
        return this.existDatabase(this.getBaseUrlConfig(), dbName);
    }

    @Override
    public boolean existDatabase(SdDatabaseOptions config, String dbName) throws Exception {
        int result = 0;
        Connection connection = this.getConnection(config);
        ResultSet query = null;
        String sql = String.format("SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name='%s'", dbName);
        try {
            query = connection.createStatement().executeQuery(sql);
            if (query.next()) {
                result = query.getInt(1);
            }
        }
        catch (Exception e) {
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + sql);
            throw e;
        }
        finally {
            if (query != null) {
                query.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return result == 1;
    }

    @Override
    public boolean createDatabase(SdAbstractDatabaseContent content) throws Exception {
        return super.createDatabase(this.getBaseUrlConfig(), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SdTableAttribute getTableAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            String[] types = new String[]{"TABLE", "VIEW"};
            rs = md.getTables(catalog, null, tableName, types);
            SdTableAttribute result = null;
            if (rs.next()) {
                result = new SdTableAttribute();
                this.converterTableAttribute(rs, result);
                ResultSet comment = connection.createStatement().executeQuery(String.format("SELECT TABLE_NAME,TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_NAME='%s'", tableName));
                if (comment.next()) {
                    result.setRemarks(comment.getString(2));
                    try {
                        comment.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            SdTableAttribute sdTableAttribute = result;
            return sdTableAttribute;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTableIndexKeyAttribute> getTableIndexKeysAttribute(String tableName, boolean unique, boolean approximate) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            rs = connection.createStatement().executeQuery("SHOW INDEX FROM " + tableName);
            ArrayList<SdTableIndexKeyAttribute> result = new ArrayList<SdTableIndexKeyAttribute>();
            while (rs.next()) {
                SdTableIndexKeyAttribute attr = new SdTableIndexKeyAttribute();
                attr.setTableName(rs.getString("Table"));
                attr.setColumnName(rs.getString("Column_name"));
                attr.setNonUnique(rs.getInt("Non_unique") == 1);
                attr.setIndexName(rs.getString("Key_name"));
                attr.setAscOrDesc(rs.getString("Collation"));
                attr.setCardinality(rs.getInt("Cardinality"));
                attr.setIndexRemarks(rs.getString("Index_comment"));
                result.add(attr);
            }
            ArrayList<SdTableIndexKeyAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public SdDbUtilMySqlImpl setConfig(SdDatabaseOptions config) {
        super.setConfig(config);
        return this;
    }
}

