/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl.dbutil;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.mirrentools.sd.impl.dbutil.SdAbstractDbUtil;
import org.mirrentools.sd.models.db.query.SdTableAttribute;
import org.mirrentools.sd.models.db.query.SdTableColumnAttribute;
import org.mirrentools.sd.models.db.query.SdTableIndexKeyAttribute;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class SdDbUtilSqlServerImpl
extends SdAbstractDbUtil {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    public SdDbUtilSqlServerImpl(SdDatabaseOptions options) {
        super(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existDatabase(SdDatabaseOptions config, String dbName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection(config);
            String sql = String.format("select count(*) from sys.databases where name='%s'", dbName);
            this.LOG.info("\u6267\u884cSQL\u8bed\u53e5:\n" + sql);
            ResultSet res = connection.createStatement().executeQuery(sql);
            res.next();
            int result = res.getInt(1);
            try {
                res.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean bl = result == 1;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTableNames() throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            String sql = "select name from sysobjects  where xtype='u' or xtype='v' ";
            rs = connection.createStatement().executeQuery(sql);
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("name"));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SdTableAttribute getTableAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            String[] types = new String[]{"TABLE", "VIEW"};
            rs = md.getTables(catalog, null, tableName, types);
            SdTableAttribute result = null;
            if (rs.next()) {
                result = new SdTableAttribute();
                this.converterTableAttribute(rs, result);
                ResultSet comment = connection.createStatement().executeQuery(String.format("select t.name,cast(m.value as varchar) remarks from sys.tables t inner join  sys.extended_properties m on(t.object_id=m.major_id) where m.minor_id=0 and t.name = '%s'", tableName));
                if (comment.next()) {
                    result.setRemarks(comment.getString("remarks"));
                    try {
                        comment.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            SdTableAttribute sdTableAttribute = result;
            return sdTableAttribute;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTableColumnAttribute> getTableColumnsAttribute(String tableName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            String catalog = connection.getCatalog() == null ? null : connection.getCatalog();
            rs = md.getColumns(catalog, null, tableName, null);
            LinkedHashMap<String, SdTableColumnAttribute> columnMap = new LinkedHashMap<String, SdTableColumnAttribute>();
            while (rs.next()) {
                SdTableColumnAttribute attr = new SdTableColumnAttribute();
                this.converterColumnsAttribute(rs, attr);
                columnMap.put(rs.getString("COLUMN_NAME"), attr);
            }
            if (columnMap.size() == 0) {
                throw new NullPointerException("\u4ece\u8868\u4e2d\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25!\u83b7\u53d6\u4e0d\u5230\u4efb\u4f55\u5b57\u6bb5!");
            }
            String sql = "select c.name,cast(r.value as varchar) remarks from sys.tables t inner join sys.columns c on t.object_id=c.object_id inner join sys.extended_properties r on (c.column_id=r.minor_id and  r.major_id=t.object_id )where t.name='" + tableName + "'";
            ResultSet query = connection.createStatement().executeQuery(sql);
            while (query.next()) {
                String name = query.getString("name");
                ((SdTableColumnAttribute)columnMap.get(name)).setRemarks(query.getString("remarks"));
            }
            try {
                query.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList<SdTableColumnAttribute> result = new ArrayList<SdTableColumnAttribute>(columnMap.values());
            Collections.sort(result);
            ArrayList<SdTableColumnAttribute> arrayList = result;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SdTableIndexKeyAttribute> getTableIndexKeysAttribute(String tableName, boolean unique, boolean approximate) throws Exception {
        List<SdTableIndexKeyAttribute> items = super.getTableIndexKeysAttribute(tableName, unique, approximate);
        if (items != null && !items.isEmpty()) {
            Connection connection = null;
            try {
                connection = this.getConnection();
                ArrayList<SdTableIndexKeyAttribute> result = new ArrayList<SdTableIndexKeyAttribute>();
                for (SdTableIndexKeyAttribute index : items) {
                    String indexName = index.getIndexName();
                    if (indexName == null) continue;
                    String sql = String.format("select index_id,is_unique,is_primary_key from sys.indexes where name='%s'", indexName);
                    ResultSet query = connection.createStatement().executeQuery(sql);
                    if (!query.next()) continue;
                    if (query.getInt("is_primary_key") == 1) {
                        try {
                            query.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    index.setNonUnique(query.getInt("is_unique") == 0);
                    index.setOrdinalPosition(query.getShort("index_id"));
                    result.add(index);
                    try {
                        query.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<SdTableIndexKeyAttribute> arrayList = result;
                return arrayList;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return new ArrayList<SdTableIndexKeyAttribute>();
    }
}

