/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdColumn;
import org.mirrentools.sd.models.SdRelational;
import org.mirrentools.sd.models.SdSequence;

public class SdBean {
    private Set<String> imports;
    private Set<String> annotations;
    private String name;
    private String alias;
    private String remark;
    private String schema;
    private String owner;
    private String tablespace;
    private String indexspace;
    private Boolean compressable;
    private List<SdColumn> columns;
    private List<SdColumn> additionalColumns;
    private List<SdRelational> relationals;
    private List<SdSequence> sequences;
    private Map<String, Object> extensions;

    public Set<String> getImports() {
        return this.imports;
    }

    public SdBean addImport(String imports) {
        if (this.getImports() == null) {
            this.imports = new LinkedHashSet<String>();
        }
        this.imports.add(imports);
        return this;
    }

    public SdBean setImports(Set<String> imports) {
        this.imports = imports;
        return this;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public SdBean addAnnotation(String annotation) {
        if (this.getAnnotations() == null) {
            this.setAnnotations(new LinkedHashSet<String>());
        }
        this.annotations.add(annotation);
        return this;
    }

    public SdBean setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SdBean setName(String name) {
        this.name = name;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public SdBean setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public SdBean setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SdBean setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public SdBean setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public SdBean setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public String getIndexspace() {
        return this.indexspace;
    }

    public SdBean setIndexspace(String indexspace) {
        this.indexspace = indexspace;
        return this;
    }

    public Boolean isCompressable() {
        return this.compressable;
    }

    public SdBean setCompressable(Boolean compressable) {
        this.compressable = compressable;
        return this;
    }

    public List<SdColumn> getColumns() {
        return this.columns;
    }

    public SdBean addColumn(SdColumn column) {
        SdUtil.requireNonNull(column);
        if (this.getColumns() == null) {
            this.setColumns(new ArrayList<SdColumn>());
        }
        this.getColumns().add(column);
        return this;
    }

    public SdBean addColumn(SdColumn ... columns) {
        SdUtil.requireNonNull(columns);
        if (this.getColumns() == null) {
            this.setColumns(new ArrayList<SdColumn>());
        }
        this.getColumns().addAll(Arrays.asList(columns));
        return this;
    }

    public SdBean setColumns(List<SdColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<SdColumn> getAdditionalColumns() {
        return this.additionalColumns;
    }

    public SdBean addAdditionalColumn(SdColumn additionalColumn) {
        if (this.getAdditionalColumns() == null) {
            this.setAdditionalColumns(new ArrayList<SdColumn>());
        }
        this.getAdditionalColumns().add(additionalColumn);
        return this;
    }

    public SdBean addAdditionalColumn(SdColumn ... additionalColumn) {
        SdUtil.requireNonNull(additionalColumn);
        if (this.getAdditionalColumns() == null) {
            this.setAdditionalColumns(new ArrayList<SdColumn>());
        }
        this.getAdditionalColumns().addAll(Arrays.asList(additionalColumn));
        return this;
    }

    public SdBean setAdditionalColumns(List<SdColumn> additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    public SdBean addRelational(SdRelational relational) {
        if (SdUtil.isNullOrEmpty((Object)relational)) {
            return this;
        }
        if (this.relationals == null) {
            this.relationals = new ArrayList<SdRelational>();
        }
        this.relationals.add(relational);
        return this;
    }

    public List<SdRelational> getRelationals() {
        return this.relationals;
    }

    public SdBean setRelationals(List<SdRelational> relationals) {
        this.relationals = relationals;
        return this;
    }

    public List<SdSequence> getSequences() {
        return this.sequences;
    }

    public SdBean addSequence(SdSequence sequence) {
        if (this.getSequences() == null) {
            this.setSequences(new ArrayList<SdSequence>());
        }
        this.getSequences().add(sequence);
        return this;
    }

    public SdBean setSequences(List<SdSequence> sequences) {
        this.sequences = sequences;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdBean addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.extensions.put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdBean setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SdBean: \n");
        sb.append("  \u2523\u2501imports = " + this.imports + "\n");
        sb.append("  \u2523\u2501annotations = " + this.annotations + "\n");
        sb.append("  \u2523\u2501name = " + this.name + "\n");
        sb.append("  \u2523\u2501alias = " + this.alias + "\n");
        sb.append("  \u2523\u2501remark = " + this.remark + "\n");
        sb.append("  \u2523\u2501owner = " + this.owner + "\n");
        sb.append("  \u2523\u2501schema = " + this.schema + "\n");
        sb.append("  \u2523\u2501tablespace = " + this.tablespace + "\n");
        sb.append("  \u2523\u2501indexspace = " + this.indexspace + "\n");
        sb.append("  \u2523\u2501compressable = " + this.compressable + "\n");
        sb.append("  \u2523\u2501columns = " + this.columns + "\n");
        sb.append("  \u2523\u2501additionalColumns = " + this.additionalColumns + "\n");
        sb.append("  \u2523\u2501relationals = " + this.relationals + "\n");
        sb.append("  \u2523\u2501sequences = " + this.sequences + "\n");
        sb.append("  \u2517\u2501extensions = " + this.extensions + "\n");
        return sb.toString();
    }
}

