/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;

public abstract class SdAbstractDatabaseContent {
    private String databaseName;
    private Map<String, Object> extensions;

    public SdAbstractDatabaseContent(String databaseName) {
        SdUtil.requireNonEmpty(databaseName, "\u6570\u636e\u5e93\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.databaseName = databaseName;
    }

    public abstract String createSQL();

    public abstract String updateSQL() throws UnsupportedOperationException;

    public abstract String deleteSQL();

    public String converterExtensions() {
        return null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SdAbstractDatabaseContent setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Object getExtension(String key) {
        return this.getExtensions().get(key);
    }

    public SdAbstractDatabaseContent addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    public SdAbstractDatabaseContent setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        return "AbstractDatabaseContent [databaseName=" + this.databaseName + ", extensions=" + this.extensions + "]";
    }
}

