package org.mirrentools.sd.options.def;

import org.mirrentools.sd.converter.impl.SdTemplateContentConverterDefaultImpl;
import org.mirrentools.sd.converter.impl.mysql.SdClassConverterMySqlImpl;
import org.mirrentools.sd.converter.impl.mysql.SdDatabaseConverterMySqlImpl;
import org.mirrentools.sd.converter.impl.mysql.SdTableContentConverterMySqlImpl;
import org.mirrentools.sd.converter.impl.mysql.SdTableToClassConverterMySqlImpl;
import org.mirrentools.sd.impl.ScrewDriverTemplateFreeMarkerImpl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilMySqlImpl;
import org.mirrentools.sd.options.ScrewDriverOptions;
import org.mirrentools.sd.options.SdDatabaseOptions;

/**
 * MySQL版配置
 * 
 * @author <a href="http://mirrentools.org">Mirren</a>
 *
 */
public class ScrewDriverMySqlOptions extends ScrewDriverOptions {
	/**
	 * 初始化一个MySQL版的ScrewDriver配置,用于仅生成SQL
	 * 
	 * @param databaseOptions 数据库连接信息
	 */
	public ScrewDriverMySqlOptions(SdDatabaseOptions databaseOptions) {
		init(databaseOptions);

	}

	/**
	 * @param databaseOptions 数据库连接信息
	 */
	private void init(SdDatabaseOptions databaseOptions) {
		super.setDatabaseOptions(databaseOptions);
		super.setTemplateContentConverter(new SdTemplateContentConverterDefaultImpl());
		super.setTemplateEngine(new ScrewDriverTemplateFreeMarkerImpl());

		super.setBeanConverter(new SdClassConverterMySqlImpl());

		super.setTableConverter(new SdTableContentConverterMySqlImpl());
		super.setClassConverter(new SdTableToClassConverterMySqlImpl());
		super.setDatabaseConverter(new SdDatabaseConverterMySqlImpl());

		super.setDbUtil(new SdDbUtilMySqlImpl(databaseOptions));
	}
}
