/*
 * Decompiled with CFR 0.152.
 */
package org.mk300.maven.plugin.drools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieContainer;

public class PkgBuilderMojo
extends AbstractMojo {
    private static String pomTemplete = "<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd'><modelVersion>4.0.0</modelVersion><groupId>tmp</groupId><artifactId>tmp</artifactId><version>1</version></project>";
    private String ruleBaseDir;
    private File targetDir;
    private String pkgFileName;
    private String encoding;
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("ruleBaseDir=" + this.ruleBaseDir));
        ClassLoader cl = this.createProjectClassLoader();
        ClassLoader orgCl = Thread.currentThread().getContextClassLoader();
        FileOutputStream fos = null;
        try {
            Thread.currentThread().setContextClassLoader(cl);
            File outputFile = new File(this.targetDir, this.pkgFileName);
            Collection<KiePackage> pkgs = this.createKiePackage();
            this.logKBase(pkgs);
            fos = new FileOutputStream(outputFile);
            DroolsStreamUtils.streamOut((OutputStream)fos, pkgs);
            fos.flush();
            this.getLog().info((CharSequence)("Output to " + outputFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("hogeee", (Exception)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            Thread.currentThread().setContextClassLoader(orgCl);
        }
    }

    private Collection<KiePackage> createKiePackage() throws MojoExecutionException {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        File ruleBaseDirFile = new File(this.ruleBaseDir);
        this.writeAllRule(kfs, ruleBaseDirFile);
        kfs.writePomXML(pomTemplete);
        KieBuilder kieBuilder = kieServices.newKieBuilder(kfs).buildAll();
        if (kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING}).size() > 0) {
            this.getLog().warn((CharSequence)("kieBuilder warn!: " + kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})));
        }
        if (kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size() > 0) {
            this.getLog().error((CharSequence)("kieBuilder error!: " + kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})));
            throw new MojoExecutionException("ERROR");
        }
        ReleaseId releaseId = kieServices.newReleaseId("tmp", "tmp", "1");
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        kieServices.getRepository().removeKieModule(releaseId);
        return kieContainer.getKieBase().getKiePackages();
    }

    private void writeAllRule(KieFileSystem kfs, File file) {
        if (!file.exists() || file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.writeAllRule(kfs, subFile);
            }
            return;
        }
        if (file.canRead()) {
            KieServices kieServices = KieServices.Factory.get();
            String fullPath = file.getAbsolutePath();
            if (File.separator.equals("\\")) {
                fullPath = fullPath.replaceAll("\\\\", "/");
            }
            this.getLog().info((CharSequence)("Adding rule file=" + fullPath));
            String actualEncoding = this.encoding;
            if (actualEncoding == null) {
                actualEncoding = "UTF-8";
            }
            kfs.write("src/main/resources/" + fullPath, kieServices.getResources().newFileSystemResource(fullPath, actualEncoding));
        }
    }

    private void logKBase(Collection<KiePackage> packages) {
        this.getLog().info((CharSequence)"Builded packages=[");
        if (packages == null || packages.isEmpty()) {
            this.getLog().info((CharSequence)"+pkg = <empty>");
            return;
        }
        for (KiePackage pkg : packages) {
            this.getLog().info((CharSequence)(" +pkg = " + pkg));
            Collection rules = pkg.getRules();
            if (rules.isEmpty()) {
                this.getLog().info((CharSequence)" --rule = <empty>");
                continue;
            }
            for (Rule rule : rules) {
                this.getLog().info((CharSequence)(" --rule = " + rule.getName()));
            }
        }
        this.getLog().info((CharSequence)"]");
    }

    private ClassLoader createProjectClassLoader() throws MojoExecutionException {
        List projectClasspathElements = null;
        try {
            projectClasspathElements = this.mavenProject.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            new MojoExecutionException("Dependency resolution failed", (Exception)((Object)e));
        }
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        for (String element : projectClasspathElements) {
            File elementFile = new File(element);
            try {
                URL url = elementFile.toURI().toURL();
                projectClasspathList.add(url);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
            }
        }
        ClassLoader pluginClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader mavenClassLoader = pluginClassLoader.getParent();
        URLClassLoader projectClassLoader = new URLClassLoader(projectClasspathList.toArray(new URL[projectClasspathList.size()]), mavenClassLoader);
        return projectClassLoader;
    }
}

