/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.congestion;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.commons.congestion.CongestionMonitor;

public class CPUProcessCongestionMonitor
implements CongestionMonitor {
    private static final Logger logger = Logger.getLogger(CPUProcessCongestionMonitor.class);
    private static final String SOURCE = "CPU";
    private final FastList<CongestionListener> listeners = new FastList();
    private java.lang.management.OperatingSystemMXBean osMBean = ManagementFactory.getOperatingSystemMXBean();
    private int availableProcessors = this.osMBean.getAvailableProcessors();
    private long lastSystemTime = 0L;
    private long lastProcessCpuTime = 0L;
    private volatile double percentageOfCPUUsed;
    private volatile boolean cpuTooHigh = false;
    private double backToNormalCPUThreshold;
    private double cpuThreshold;

    public CPUProcessCongestionMonitor() {
        this.baselineCounters();
    }

    public void setBackToNormalCPUThreshold(double backToNormalCPUThreshold) {
        this.backToNormalCPUThreshold = backToNormalCPUThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal CPU threshold set to " + backToNormalCPUThreshold + "%"));
        }
    }

    public double getBackToNormalCPUThreshold() {
        return this.backToNormalCPUThreshold;
    }

    public void setCPUThreshold(double cpuThreshold) {
        this.cpuThreshold = cpuThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("CPU threshold set to " + this.cpuThreshold + "%"));
        }
    }

    public double getCPUThreshold() {
        return this.cpuThreshold;
    }

    public void monitor() {
        block6: {
            block5: {
                if (this.osMBean == null) {
                    return;
                }
                this.percentageOfCPUUsed = this.getCpuUsage();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("CPU Process Load Average = " + this.percentageOfCPUUsed));
                }
                if (!this.cpuTooHigh) break block5;
                if (!(this.percentageOfCPUUsed < this.backToNormalCPUThreshold)) break block6;
                logger.warn((Object)("CPU used: " + this.percentageOfCPUUsed + "% < to the back to normal CPU threshold : " + this.backToNormalCPUThreshold));
                this.cpuTooHigh = false;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionFinish(SOURCE);
                }
                break block6;
            }
            if (this.percentageOfCPUUsed > this.cpuThreshold) {
                logger.warn((Object)("CPU used: " + this.percentageOfCPUUsed + "% > to the CPU threshold : " + this.cpuThreshold));
                this.cpuTooHigh = true;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionStart(SOURCE);
                }
            }
        }
    }

    public synchronized double getCpuUsage() {
        long systemTime = System.nanoTime();
        long processCpuTime = 0L;
        if (this.osMBean instanceof java.lang.management.OperatingSystemMXBean) {
            processCpuTime = ((OperatingSystemMXBean)this.osMBean).getProcessCpuTime();
        }
        double cpuUsage = (double)(processCpuTime - this.lastProcessCpuTime) / (double)(systemTime - this.lastSystemTime);
        this.lastSystemTime = systemTime;
        this.lastProcessCpuTime = processCpuTime;
        return cpuUsage / (double)this.availableProcessors;
    }

    private void baselineCounters() {
        this.lastSystemTime = System.nanoTime();
        if (this.osMBean instanceof java.lang.management.OperatingSystemMXBean) {
            this.lastProcessCpuTime = ((OperatingSystemMXBean)this.osMBean).getProcessCpuTime();
        }
    }

    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getSource() {
        return SOURCE;
    }
}

